# Breaking Changes between Lucee 6.1 and 6.2



# Breaking Changes between Lucee 6.1 and 6.2

[Lucee 6.2 new features](../guides/lucee-6.2.md)

This document outlines the breaking changes introduced when upgrading from Lucee 6.1 to Lucee 6.2. Be aware of these changes when migrating your applications to ensure smooth compatibility.

## Changelogs

- [Release notes, guides, demos](https://dev.lucee.org/tag/lucee-62)
- [https://download.lucee.org/changelog/?version=6.2](https://download.lucee.org/changelog/?version=6.2)
- [New tags and functions](https://docs.lucee.org/reference/changelog.html)

## Other Breaking Changes in Lucee Releases

- [Breaking Changes between Lucee 5.4 and 6.0](breaking-changes-6-0.md)
- [Breaking Changes Between Lucee 6.0 and 6.1](breaking-changes-6-1.md)
- [Breaking Changes between Lucee 6.2 and 7.0](breaking-changes-7.md)

## Java Support

- Java 21 is recommended as it's a LTS release.
- Java 23 is supported
- Java 24-ea works, but there are some issues with date handling
- Java 11 is supported
- Java 8 is no longer supported

## Single Mode

Lucee 6.0 introduced Single Mode, Lucee 7.0 only supports single mode (multi-mode, i.e. web admins/contexts are removed)

[Single Mode vs Multi Mode](single-vs-multi-mode.md)

## Changing PreciseMath to be off by default

With Lucee 6, we introduced support for higher precision maths, by switching the underlying Java class from Double to BigInteger.

During the development of 6.2, which was heavily focussed on increasing Lucee's overall performance, it became apparent that the overhead of BigDecimal, both in terms of performance and memory usage was too simply high.

So, we decided to switch the default back to preciseMath=false, which really improved performance as this affects any use of numbers. For most Lucee applications, this change will have no functional affect.

Dynamically switching preciseMath on and off as required is recommended, rather than using it all the time.

As part of this change, we updated all our test cases to test switching dynamically during a request and identified a few problems which we addressed.




---

## LUCEE_PRECISE_MATH

*SysProp:* `-Dlucee.precise.math`
*EnvVar:* `LUCEE_PRECISE_MATH`

A boolean value. If enabled, this improves the accuracy of floating-point calculations but makes them slightly slower

**Type:** boolean | **Default:** false

---




## Support for Jakarta Servlet

Lucee 6.2 adds support for Jakarta Servlets, but it still based on javax.

Therefore, the javax libraries are required for Lucee 6.2 to work when deployed on a Jakarta based Servlet engine like Tomcat 10+, Jetty 12, Undertow 2.3.0, etc and newer.

Our Official Lucee 6.2 Installers and Docker images bundle Tomcat 10+ and these required javax libaries.

If you are manually deploying Lucee 6.2 to a Jakarta based servlet engine, you need to add the following javax libaries to the classpath (lib directory), otherwise, Lucee will fail to deploy.

- [javax.servlet-api-4.0.1.jar](https://repo1.maven.org/maven2/javax/servlet/javax.servlet-api/4.0.1/javax.servlet-api-4.0.1.jar) 
- [javax.servlet.jsp-api-2.3.3.jar](https://repo1.maven.org/maven2/javax/servlet/jsp/javax.servlet.jsp-api/2.3.3/javax.servlet.jsp-api-2.3.3.jar)
- [javax.el-api-3.0.0.jar](https://repo1.maven.org/maven2/javax/el/javax.el-api/3.0.0/javax.el-api-3.0.0.jar) 

Older Javax Servlet engines (i.e. Tomcat 9) are still supported for Lucee 6.2 as well, just make sure they are updated and still maintained.

Lucee 7 is Jakarta based and therefore requires a Jakarta based Servlet engine.

[LDEV-4910](https://luceeserver.atlassian.net/browse/LDEV-4910)

[Javax to Jakarta Namespace Ecosystem Progress](https://jakarta.ee/blogs/javax-jakartaee-namespace-ecosystem-progress/)

## Latest 6.2.2+ Updates not available via the Lucee Admin

Due to some upstream changes in Maven, the last visible update in the Admin maybe the 6.2.2.64-SNAPSHOT.

To upgrade to 6.2.2+, you will need to perform a one off [workaround](https://dev.lucee.org/t/lucee-6-2-7-0-latest-upgrades-not-showing-in-the-admin-workaround/15299)

## Lucee 6.2 is up to 50% faster for some operations than Lucee 5.4

While not exactly what you might expect as a breaking change, we did find that all the improvements made with 6.2 managed to surface some other underlying bugs, simply because Lucee got faster.

You also may find some race conditions, etc within your own code / applications.

## Default Application.Log Level is ERROR

[https://luceeserver.atlassian.net/browse/LDEV-5366](https://luceeserver.atlassian.net/browse/LDEV-5366)

## pagePoolClear() causes non heap memory to increase

Use [InspectTemplates()](../reference/functions/inspecttemplates.md) instead.

[LDEV-5491](https://luceeserver.atlassian.net/browse/LDEV-5491)

## Cookies Expires are now in GMT, rather than UTC

More of a bug fix than a breaking change, Lucee now adheres to the spec correctly, since with 6.2.2, making Cloudflare happier

[LDEV-4314](https://luceeserver.atlassian.net/browse/LDEV-4314)

## REST cfc will only look for Application.cfc in same directory

Previous behaviour was deemed to be a bug.

Workaround, create an Application.cfc which extends the parent Application.cfc

[LDEV-5323](https://luceeserver.atlassian.net/browse/LDEV-5323)

## Strict Equality Operator was sensitive to underlying java types

Lucee 6 improved the `===` operator to compare type and value, but was checking only the underlying java type, rather than cfml type, so numbers might fail

In 6.2.3.34, this was changes to compare cfml type and value, as expected

[LDEV-5806](https://luceeserver.atlassian.net/browse/LDEV-5806)

# Categories

[Compatibility / Migration with other CFML engines](../categories/compat.md)

# See Also

[Mathematical Precision](mathematical-precision.md)