# Breaking Changes between Lucee 5.4 and 6.0



# Breaking Changes between Lucee 5.4 and 6.0

This document outlines all the breaking changes which you should be aware with when upgrading from Lucee 5.4 to Lucee 6.0. 

The decision to make breaking changes are not made lightly, generally speaking, they are made to align Lucee with ACF where possible, address performance or edge cases which can lead to problems, and also to address potential security issues.

Please review all these changes when upgrading your applications to ensure they run smoothly and reliably.

When migrating, **the Lucee team highly recommends going straight to the latest 6.2 release**, via a fresh install, working thru the breaking changes documents for each release, as listed and linked below.

[Lucee 5 to 6 Migration Guide](lucee-5-to-6-migration-guide.md)

Users upgrading to Lucee 6.2, running on Tomcat 11 and Java 21, have reported really improved performance and vastly reduced memory usage, so enjoy!

## CFConfig.json

With Lucee 6, we switched from using XML config, `lucee-server.xml` for Lucee to adopting json config `.CFConfig.json`

Lucee 6 will automatically convert an XML config to JSON

[Configuration - CFConfig.json](configuration.md)

## Single Mode

Lucee 6.0 introduces Single Mode, which is on by default.

Lucee 7.0 only supports single mode (multi-mode, i.e. web admins/contexts are removed)

[Single Mode vs Multi Mode](single-vs-multi-mode.md)

## Changelogs

- [https://download.lucee.org/changelog/?version=6.0](https://download.lucee.org/changelog/?version=6.0)
- [New tags and functions](https://docs.lucee.org/reference/changelog.html)

## Other Breaking Changes in Lucee Releases

- [Breaking Changes Between Lucee 6.0 and 6.1](breaking-changes-6-1.md)
- [Breaking Changes between Lucee 6.1 and 6.2](breaking-changes-6-2.md)
- [Breaking Changes between Lucee 6.2 and 7.0](breaking-changes-7.md)

## Extensions

Some of the older extensions have been unbundled from the default Lucee distribution.

These extension are still available, but just need to be manually installed.

- CFCHART
- Hibernate ORM
- Lucene Search (CFSEARCH)
- FORM
- AXIS Webservices
- AJAX
- EHCache (unbundled in Lucee 7)
- Argon2 support was moved to an extension in Lucee 6.1

### CFQUERYPARAM no longer autocasts empty values to null

Prior to Lucee 6, cfqueryparam would automatically case empty values to null.

With Lucee 6, we have changed this behaviour to match ACF, as this can introduce subtle bugs and is slight less performant.

This behaviour for VARCHAR values remains unchanged.

**Restore old behavior (if needed):** 


---

## LUCEE_QUERY_ALLOWEMPTYASNULL

*SysProp:* `-Dlucee.query.allowemptyasnull`
*EnvVar:* `LUCEE_QUERY_ALLOWEMPTYASNULL`

In Lucee 5, an empty string passed into a query parameter with a numeric type was interpreted as null. In Lucee 6, this is no longer accepted and throws an exception. You can simulate the old behavior by setting this environment variable or SysProp to `true`. By setting the log level of the datasource log to `warn`, you will receive information in the log when the old behavior is used. This allows you to modify your code for the new behavior without encountering runtime issues with the existing code

**Type:** boolean | **Default:** false

**Related tags:** [<cfquery>](../reference/tags/query.md), [<cfqueryparam>](../reference/tags/queryparam.md)

**Related functions:** [QueryExecute()](../reference/functions/queryexecute.md)

---




[LDEV-4410](https://luceeserver.atlassian.net/browse/LDEV-4410)

### DateDiff arguments changed to match ACF

The order of the arguments for the member function [datetime.diff()](../reference/objects/datetime/diff.md) was changed in Lucee 6 to match ACF

[LDEV-2044](https://luceeserver.atlassian.net/browse/LDEV-2044)

### Use JVM cacerts by default

Prior to Lucee 6, Lucee would bundle its own `cacerts` file, which caused problems over time as newer root certificates wouldn't be accepted.

**Restore old behavior (if needed):** 


---

## LUCEE_USE_LUCEE_SSL_TRUSTSTORE

*SysProp:* `-Dlucee.use.lucee.SSL.TrustStore`
*EnvVar:* `LUCEE_USE_LUCEE_SSL_TRUSTSTORE`

Specifies the file location of the trust store that contains trusted Certificate Authorities (CAs) for SSL/TLS connections in Java applications. Lucee 6 uses the JVM trust store by default

**Type:** string

**Related tags:** [<cfhttp>](../reference/tags/http.md), [<cfmail>](../reference/tags/mail.md)

---




Since this change, [SSLCertificateInstall()](../reference/functions/sslcertificateinstall.md) no longer works

[LDEV-917](https://luceeserver.atlassian.net/browse/LDEV-917)

### Lucee dialect has been removed

The Lucee dialect was removed as it wasn't being unused and was no longer maintained.

Removing it reduced memory usage and increased performance.

[LDEV-4327](https://luceeserver.atlassian.net/browse/LDEV-4327)

### Automatic date parsing for mask "m d" removed.

This was removed as it produced false positives, you can still parse these dates by providing an explicit date mask.

[LDEV-4506](https://luceeserver.atlassian.net/browse/LDEV-4506)

### Session cookies default to being secure

With Lucee 6.1, the defaults for session cookies was changed to be `samesite=lax, httponly=true`

You can revert this change by setting custom values.

[LDEV-3448](https://luceeserver.atlassian.net/browse/LDEV-3448)

### Lucee mappings are now checked before the root filesystem

The previous behaviour lead to problems on Linux systems

**Restore old behavior (if needed):** 


---

## LUCEE_MAPPING_FIRST

*SysProp:* `-Dlucee.mapping.first`
*EnvVar:* `LUCEE_MAPPING_FIRST`

Let's say you have the following code: `<cfinclude template="/foo/bar/index.cfm">` And you have the following mappings defined: `/foo/bar` and `/foo`. Then Lucee will look for `/index.cfm` in `/foo/bar` and for `/bar/index.cfm` in `/foo` and invoke the first `index.cfm` it finds, which could be in both mappings. If this setting is set to `true`, Lucee will only check `/foo/bar` for `index.cfm`

**Type:** boolean | **Default:** true

**Related tags:** [<cfinclude>](../reference/tags/include.md)

**Related functions:** [ExpandPath()](../reference/functions/expandpath.md)

---




[LDEV-1718](https://luceeserver.atlassian.net/browse/LDEV-1718)

### The '===' operator now checks for value and type

Prior to Lucee 6, the `===` operator only returned true when comparing the same object, this has been changed to match the expected behavior (i.e. same as javascript).

[Operators](../guides/developing-with-lucee-server/operators.md)

[LDEV-1282](https://luceeserver.atlassian.net/browse/LDEV-1282)

However, prior to 6.2.3.34, it was checking the underlying java type, rather than cfml type, so comparing numbers might fail

In 6.2.3.34, this was changes to compare cfml type and value, as expected

[LDEV-5806](https://luceeserver.atlassian.net/browse/LDEV-5806) 

### Query.map() member function returns a new query.

Previously the `.query.map()` member function would modify the query, rather than returning a new query

[query.map()](../reference/objects/query/map.md)

[LDEV-556](https://luceeserver.atlassian.net/browse/LDEV-556)

### Empty sessions and client scopes are no longer persisted

For better performance and memory usage, an empty session or client scope is no longer saved.

**Restore old behavior (if needed):** 


---

## LUCEE_STORE_EMPTY

*SysProp:* `-Dlucee.store.empty`
*EnvVar:* `LUCEE_STORE_EMPTY`

A boolean value. If enabled, does not store empty sessions to the client or session storage

**Type:** boolean

---




[Session Handling in Lucee](session-handling.md)

[LDEV-3340](https://luceeserver.atlassian.net/browse/LDEV-3340)

### Allow multi-character delimiters for ListAppend()

[ListAppend()](../reference/functions/listappend.md)

[LDEV-2024](https://luceeserver.atlassian.net/browse/LDEV-2024)

### FileUpload now supports strict and allowedExtensions arguments

For ACF compatibility, the function signature for [FileUpload()](../reference/functions/fileupload.md) was changed.

[LDEV-2414](https://luceeserver.atlassian.net/browse/LDEV-2414)

### FileGetMimeType() now throws on a missing or empty file

[FileGetMimeType()](../reference/functions/filegetmimetype.md)

### ReplaceList() matches support includeEmptyFields

Lucee 6 now accepts the same arguments as ACF [ReplaceList()](../reference/functions/replacelist.md)

[LDEV-2729](https://luceeserver.atlassian.net/browse/LDEV-2729)

### struct.delete() now returns the modified struct

[struct.delete()](../reference/objects/struct/delete.md)

[LDEV-2915](https://luceeserver.atlassian.net/browse/LDEV-2915)

### deserializeJSON() with an empty string throws an exception

This was changed to match ACF behaviour.

[DeserializeJSON()](../reference/functions/deserializejson.md)

[LDEV-3413](https://luceeserver.atlassian.net/browse/LDEV-3413)

### cflocation addToken defaults to false

This was changed to match modern security expectations, as session tokens shouldn't never be shared with other websites

[<cflocation>](../reference/tags/location.md)

[LDEV-3437](https://luceeserver.atlassian.net/browse/LDEV-3437)

### cflocation no longer encodes the url by default

[<cflocation>](../reference/tags/location.md)

[LDEV-2164](https://luceeserver.atlassian.net/browse/LDEV-2164)

### DirectoryRename() should return the new path, not void

[DirectoryRename()](../reference/functions/directoryrename.md)

[LDEV-3453](https://luceeserver.atlassian.net/browse/LDEV-3453)

### ACF Compatibility Query.addRow(), Query.addColumn(), Query.deleteRow(), Query.deleteColumn()

For ACF compatibility, the member functions `Query.addRow()`, `Query.addColumn()`, `Query.deleteRow()`, and `Query.deleteColumn()` return the updated query (allowing method chaining).

[LDEV-3581](https://luceeserver.atlassian.net/browse/LDEV-3581)

### QueryAddRow() treats struct of arrays different than Adobe

[QueryAddRow()](../reference/functions/queryaddrow.md)

[LDEV-3933](https://luceeserver.atlassian.net/browse/LDEV-3933)

### DollarFormat incorrect negative values on Java 11

This was changed for consistency in CFML, as the underlying Java functionality changes between versions

Lucee 7 adds an additional argument, `useBrackets` to control this behavior

[DollarFormat()](../reference/functions/dollarformat.md)

[LDEV-3743](https://luceeserver.atlassian.net/browse/LDEV-3743)

### String member functions assume list instead of char array like Adobe

[LDEV-3747](https://luceeserver.atlassian.net/browse/LDEV-3747)

### Encrypt issue using Base64, invalid character [=] in base64 string at position

There is a new argument precise, which defaults to true, set to false if you encounter problems

- [Encrypt()](../reference/functions/encrypt.md)
- [Decrypt()](../reference/functions/decrypt.md)
- [ToBinary()](../reference/functions/tobinary.md)
- [BinaryDecode()](../reference/functions/binarydecode.md)

[LDEV-4101](https://luceeserver.atlassian.net/browse/LDEV-4101)

### CFFILE action=upload attemptedServerFile now returns the attempted filename

Previously, Lucee would incorrectly return the new file name

[<cffile>](../reference/tags/file.md)

[LDEV-4201](https://luceeserver.atlassian.net/browse/LDEV-4201)

### ArrayNew() typed argument changes

Changes were made to match ACF

[ArrayNew()](../reference/functions/arraynew.md)

[LDEV-4271](https://luceeserver.atlassian.net/browse/LDEV-4271)

### FileWriteLine uses wrong line separator on Windows

Behaviour was changed to match ACF and use the operating system line separator (CFLF instead of LF)

[FileWriteLine()](../reference/functions/filewriteline.md)

[LDEV-4332](https://luceeserver.atlassian.net/browse/LDEV-4332)

### NumberFormat rounding decimal places differently

Number format now rounds up instead of down to match ACF behavior.

[NumberFormat()](../reference/functions/numberformat.md)

[LDEV-4439](https://luceeserver.atlassian.net/browse/LDEV-4439)

### CFLDAP timeout is now in ms, not seconds

Fixed implementation bug and changed to milliseconds, to match ACF behavior.

[LDEV-1860](https://luceeserver.atlassian.net/browse/LDEV-1860)

# Categories

[Compatibility / Migration with other CFML engines](../categories/compat.md)

# See Also

[Lucee 5 to 6 Migration Guide](lucee-5-to-6-migration-guide.md)