# Update current Application Context



# Application Context update

Lucee allows you to update the existing application context, **per request** as defined for example in [Application.cfc guide](application-cfc.md).

This does not affect any other request, you are only changing the application settings for the current request.

For example, add a per-application mapping:

```cfml
<!--- creates a mapping with name "/test" that is pointing to the current directory --->
<cfapplication action="update" mappings="# {'/test': getDirectoryFromPath(getCurrentTemplatePath())} #">
```

This example doesn't extend the existing application mappings with this new one, it replaces them. 

So when you plan to add a mapping, it's best to first read the existing mappings with help of the function [GetApplicationSettings()](../reference/functions/getapplicationsettings.md) and update these mappings as follows:

```cfml
<!--- read the existing per-application mappings --->
<cfset mappings = getApplicationSettings().mappings>

<!--- add a mapping with name "/test" to the mappings struct --->
<cfset mappings['/test'] = getDirectoryFromPath(getCurrentTemplatePath())>

<!--- add all mappings --->
<cfapplication action="update" mappings="#mappings#">
```

Of course, it's not only mappings you can update. [Application.cfc / <cfapplication>](../reference/tags/application.md) lets you update all the settings you can do in the Application.cfc!

# Categories

[Application](../categories/application.md)

# See Also

[Application.cfc guide](application-cfc.md), [Application.cfc / <cfapplication>](../reference/tags/application.md)