# Lucee Recipes

Detailed Recipes showing you how to take advantage of the wide range of features in Lucee

- [Adding Caches via Application.cfc](recipes/caches-defined-in-application-cfc.md) - How to add per-application caches via Application.cfc in Lucee.
- [AI (experimental)](recipes/ai.md) - 
- [AI Augmentation with Lucene](recipes/ai-augmentation.md) - Documentation for augmenting AI queries using Lucene search in Lucee
- [AI Integration for Documentation (Experimental)](recipes/ai-for-documentation.md) - Guide to configuring AI for use in Lucee's Documentation tab, leveraging retrieval-augmented generation (RAG) and enhanced search functionality.
- [AI Session Serialization](recipes/ai-serialisation.md) - Documentation for serializing and deserializing AI sessions in Lucee
- [Application.cfc guide](recipes/application-cfc.md) - How to create and configure the Application.cfc
- [Archives - Creating and deploying Lucee Archives (.lar files)](recipes/archives-creating-and-deploy.md) - This document explains how to deploy an Application on a live server without using a single CFML file.
- [AST (Abstract Syntax Tree)](recipes/ast.md) - Generate Abstract Syntax Trees from CFML code for analysis, transformation, and tooling support
- [Automatic monitoring and applying CFConfig changes](recipes/check-for-changes.md) - Automatically check for changes in your configuration file with Lucee.
- [Basic Date](recipes/basic-date.md) - Learn how to output the current date in Lucee.
- [Best Practices: Structs vs Inline Components](recipes/structs-vs-components.md) - Performance analysis and best practices for choosing between structs and inline components in Lucee
- [Breaking Changes between Lucee 5.4 and 6.0](recipes/breaking-changes-6-0.md) - A guide to breaking changes introduced in Lucee between version 5.4 and 6.0
- [Breaking Changes Between Lucee 6.0 and 6.1](recipes/breaking-changes-6-1.md) - A guide to breaking changes introduced in Lucee between version 6.0 and 6.1
- [Breaking Changes between Lucee 6.1 and 6.2](recipes/breaking-changes-6-2.md) - A guide to breaking changes introduced in Lucee between version 6.1 and 6.2
- [Breaking Changes between Lucee 6.2 and 7.0](recipes/breaking-changes-7.md) - A guide to breaking changes introduced in Lucee between version 6.2 and 7.0
- [Cache a query for the current request](recipes/cached-within-request.md) - Cache a Query for the current request in Lucee.
- [Checksum](recipes/checksum.md) - This document explains how to use a checksum in Lucee.
- [Complete Guide to Threading in Lucee](recipes/thread-usage.md) - Complete guide to using threads and parallel execution in Lucee
- [Component Mappings](recipes/component-mappings.md) - How to define and use component mappings in Lucee.
- [Configuration - CFConfig.json](recipes/configuration.md) - Best practices for configuring Lucee in various environments.
- [Configuration Lucee 5](recipes/configuration-lucee5.md) - Best practices for configuring Lucee 5 environments.
- [Configure Lucee within your Application](recipes/configuration-administrator-cfc.md) - How to configure Lucee within your application using Administrator.cfc and cfadmin tag.
- [Console logging using SystemOutput](recipes/console-logging.md) - Use the console for debugging
- [Convert a CFML Function/Component to use in Java](recipes/convert-a-cfml-func-to-java.md) - Learn how to convert user-defined functions or components in Lucee to use them in Java. This guide demonstrates how to define components to implement Java interfaces, pass components to Java methods, explicitly define interfaces, and use the onMissingMethod feature. It also shows how to convert user-defined functions to Java lambdas.
- [Creating Component-Based Jobs with Quartz Scheduler](recipes/scheduler-quartz-component-jobs.md) - How to create and configure component-based jobs with the Quartz Scheduler extension
- [CSV Processing in Lucee 7](recipes/csv-processing.md) - Simple recipe for processing CSV data in Lucee 7 using Maven integration and Apache Commons CSV
- [Custom Event Gateways](recipes/event-gateway-create.md) - Here you will find a short introduction into writing your own Event Gateway type.
- [Custom Tag Mappings](recipes/custom-tag-mappings.md) - How to define and use custom tag mappings in Lucee.
- [Data Types in Lucee](recipes/types-in-lucee.md) - This document explains types in Lucee. Lucee is still an untyped language. Types are only a check put on top of the language.
- [Datasources](recipes/datasource-how-to-define-them.md) - How to define a Datasource in Lucee.
- [Date and Time Formatting in Lucee](recipes/date-time-formatting.md) - Comprehensive guide to formatting dates and times in Lucee with locale and timezone support
- [Define a mapping](recipes/mappings-how-to-define-a-reg-mapping.md) - All about the different mappings in Lucee and how to use them.
- [Directory Placeholders](recipes/directory-placeholders.md) - Placeholders are uses to reference specific Lucee directories
- [Docker](recipes/docker.md) - Guide on using and running Lucee with Docker
- [Dynamic Proxy Enhancements in Lucee 7](recipes/dynamic-proxy-enhancements.md) - Learn about the improvements to dynamic proxy creation in Lucee 7, including automatic inclusion of component functions and properties when implementing Java interfaces.
- [Encryption/Decryption with RSA public and private keys](recipes/encryption_decryption.md) - This document explains about Encryption/Decryption with public and private keys with simple examples.
- [Environment Variables / System Properties for Lucee](recipes/environment-variables-system-properties.md) - This document gives you an overview over all Environment Variables and System Properties supported by Lucee.
- [Event Gateways](recipes/event-gateways-how-they-work.md) - Overview of how Event Gateways work in Lucee.
- [Event Gateways in Lucee](recipes/event-gateways.md) - EG's are another way how to communicate with your Lucee server and are kind of a service running on Lucee, reacting on certain events.
- [Excel Processing in Lucee 7](recipes/excel-processing.md) - Simple recipe for processing Excel files in Lucee 7 using Maven integration and Apache POI
- [Exception - Cause](recipes/exception-cause.md) - Lucee 6.1 improves its support for exception causes, providing better debugging and error handling capabilities.
- [Exception Output](recipes/exception-output.md) - How to catch and display exceptions.
- [ExecutionLog](recipes/execution-log.md) - Log details about code execution at the statement level
- [Extension Installation](recipes/extension-installation.md) - A comprehensive guide on how to install extensions in Lucee.
- [Externalize strings](recipes/externalizing-strings.md) - Externalize strings from generated class files to separate files. This method is used to reduce the memory of the static contents for templates.
- [File Extensions](recipes/file-extensions.md) - Learn about the different file extensions supported by Lucee, including .cfm, .cfc, .cfml, and .cfs. This guide provides examples for each type of file.
- [File system - Mappings](recipes/filesystem-mapping.md) - Overview of different mapping types in the file system.
- [Function Listeners](recipes/function-listeners.md) - This document explains how to use a Function Listeners in Lucee.
- [Get Datasource Drivers Directly from Maven](recipes/get-dbdriver-from-maven.md) - Learn how to get datasource drivers directly from Maven.
- [getClass() Method for Components](recipes/component-getclass-method.md) - This document explains the getClass() method for CFML components that implement Java interfaces, enabling seamless Java interoperability.
- [Global Proxy](recipes/global-proxy.md) - Learn how to define a global proxy in Lucee. This guide demonstrates how to set up a global proxy in the Application.cfc file or .CFConfig.json, limit the proxy to specific hosts, and exclude specific hosts from using the proxy.
- [Hidden Gems](recipes/hidden-gems.md) - This document explains how to declare variables, function calls with dot and bracket notation, and passing arguments via URL/form scopes as an array.
- [Hooks and Monitors](recipes/hooks-and-monitors.md) - Configure and use hooks and monitors to extend Lucee functionality at various lifecycle points
- [Import](recipes/import.md) - Guide on using import to import components, Java classes, and custom tags in Lucee
- [Inline Components](recipes/inline-components.md) - Learn how to create and use inline components in Lucee. This guide demonstrates how to define components directly within your CFML code, making it easier to create and use components without needing a separate .cfc file. Examples include creating an inline component and using it similarly to closures.
- [Interacting with Java Libraries](recipes/java-libraries.md) - Guide on using Java libraries in Lucee 6.2 with Maven and import
- [Java - Explicit Casting of a Component to a Specific Interface](recipes/java-explicit-casting.md) - Shows how to explicitly cast a component to a specific interface.
- [Java Class Interaction](recipes/java-class-interaction.md) - Documentation for interacting with Java classes and objects in Lucee
- [Java in Functions and Closures, function() type='java'](recipes/java-in-functions-and-closures.md) - Learn how to write CFML code directly in a function or a closure with Java types in Lucee. This guide demonstrates how to define functions and components with Java types, and how to use Java lambda functions within Lucee. You will see examples of how to handle exceptions, define return types, and implement functional Java interfaces (Lambdas) seamlessly.
- [Java Scripting with Lucee](recipes/java-scripting.md) - Documentation for using Lucee as a scripting engine in Java applications via JSR-223
- [JavaSettings in Application.cfc, Components and CFConfig.json](recipes/java-settings.md) - Guide on configuring Java settings in Lucee using Application.cfc, including loading Java libraries from Maven
- [Language Server Protocol (LSP) for Lucee](recipes/language-server.md) - This document explains how to configure and use the Language Server Protocol implementation for Lucee CFML/CFScript.
- [Lazy Queries](recipes/lazy-queries.md) - How to use lazy queries
- [List existing Cache Connections](recipes/list-existing-cache-conn.md) - List existing Cache Connections available in Lucee.
- [Localmode, how to migrate from Classic to Modern Local Scope Mode](recipes/migrate.md) - Guide for safely migrating your Lucee application from classic to modern local scope mode
- [Logging](recipes/logging.md) - How to configure and customize logging
- [Logging CFHTTP Calls](recipes/http-logging.md) - Learn how Lucee logs all CFHTTP calls and how to manage these logs. This guide explains the default behavior, log file locations, and changes in logging from earlier Lucee versions.
- [Logging HTTP Calls](recipes/logging-http-calls.md) - This document explains how to log HTTP calls made by the cfhttp tag in Lucee.
- [Loop Labels](recipes/loop-labels.md) - Lucee supports labels for all loop tags and statements, allowing you to control the flow of nested loops more precisely.
- [Looping Through Files](recipes/loop-through-files.md) - This document explains how to handle large files in Lucee more efficiently.
- [Lucee 5 to 6 Migration Guide](recipes/lucee-5-to-6-migration-guide.md) - Comprehensive guide for migrating from Lucee 5 to Lucee 6, addressing breaking changes and compatibility issues
- [Lucene 3 Extension](recipes/lucene-search.md) - Documentation for the Lucene 3 Extension with vector and hybrid search capabilities
- [Mail Listeners](recipes/mail-listener.md) - Learn how to define mail listeners in Lucee. This guide demonstrates how to set up global mail listeners in the Application.cfc file to listen to or manipulate every mail executed. Examples include defining listeners directly in Application.cfc and using a component as a mail listener.
- [Mathematical Precision](recipes/mathematical-precision.md) - Learn about the switch from double to BigDecimal in Lucee 6 for more precise mathematical operations. This guide provides information on how to change the default behavior if needed.
- [Mocking Static Functions](recipes/static-mocking.md) - How to mock static functions in Lucee for better testability without unnecessary wrappers.
- [Monitoring - Enable for your session](recipes/monitoring-enable-for-your-session.md) - Shows you a way to enable Monitoring for your session
- [Monitoring/Debugging](recipes/monitoring-debugging.md) - Learn about the changes in Lucee 6.1 regarding Monitoring and Debugging. Understand the old and new behavior, and how to configure the settings in Lucee Admin and Application.cfc.
- [New Operator in Lucee](recipes/new-operator.md) - This document provides a guide on using the new operator in Lucee for creating instances of CFML components and Java classes.
- [Null Support](recipes/null-support.md) - This document explains how to set null support in the Lucee server admin, assigning `null` value for a variable and how to use `null` and `nullvalue`.
- [onBuild Function in Server.cfc](recipes/docker-onbuild.md) - The onBuild function in Server.cfc is used for tasks during the build phase in Lucee, particularly useful in Docker environments.
- [Overwriting and adding Built-in Functions and Tags](recipes/overwrite-build-in-functions-tags.md) - Learn how to overwrite or add built-in functions and tags in Lucee to customize behavior or backport fixes.
- [PDF Engine - CFDOCUMENT using Flying Saucer](recipes/pdf-engine-flying-saucer.md) - The new CFDOCUMENT PDF engine, Flying Saucer in Lucee 5.3
- [Precompiled](recipes/precompiled-code.md) - How to pre-compile code for a production server while the source code is deployed to avoid compilation on the production server for security reasons.
- [Quartz Scheduler](recipes/scheduler-quartz.md) - Advanced task scheduling using Quartz Scheduler integration
- [Quartz Scheduler Clustering](recipes/scheduler-quartz-clustering.md) - How to set up and configure clustering with the Quartz Scheduler extension
- [Query Async](recipes/query-async.md) - Learn how to execute queries asynchronously in Lucee. This guide demonstrates how to set up asynchronous query execution using a simple flag. Examples include defining async execution for queries and using local listeners to handle exceptions. Additionally, function listeners introduced in Lucee 6.1 can be used for this purpose.
- [Query Execution in Lucee](recipes/query-handling.md) - Complete guide to executing database queries in Lucee with performance comparisons and best practices
- [Query Indexes](recipes/query-indexes.md) - Learn how to set and use indexes for query results in Lucee. This guide demonstrates how to define a query with an index and access parts of the query using the index.
- [Query Listeners](recipes/query-listener.md) - Learn how to define query listeners in Lucee. This guide demonstrates how to set up global query listeners in the Application.cfc file to listen to or manipulate every query executed. Examples include defining listeners directly in Application.cfc and using a component as a query listener.
- [Query of Queries (QoQ)](recipes/query-of-queries.md) - Query of queries (QoQ) is a technique for re-querying an existing (in memory) query without another trip to the database.
- [Query of Queries sometimes it rocks, sometimes it sucks](recipes/query-of-query-sometime.md) - This document explains why Query of Queries (QoQ) may or may not be the best approach for your use case.
- [Query Result Logging](recipes/query-result-threshold.md) - Monitor and log database queries that return large result sets to prevent OutOfMemory errors
- [Query return type](recipes/query-return-type.md) - This document explains the different return types for a query with some examples.
- [Read XML with a listener Model (SAX)](recipes/read-xml-with-a-listener-model-sax.md) - Lucee not only allows you to convert an XML file to an object tree (DOM) but also supports an event-driven model (SAX).
- [Recommended Settings](recipes/recommended-settings.md) - A guide on how to configure your Lucee Server for the best performance and highest security.
- [Regions in Lucee](recipes/s3-region.md) - Guide on configuring and interacting with specific S3 regions in Lucee using the S3 extension.
- [Request Timeout](recipes/request-timeout.md) - Learn how to use request timeout correctly with Lucee.
- [REST Services with Lucee](recipes/rest-services.md) - A detailed guide on how to create REST Sevices using CFCs
- [Retry](recipes/retry.md) - This document explains how to use retry functionality with some simple examples.
- [Scheduled Tasks - efficiently updating in a single operation](recipes/cfschedule-bulk-update.md) - How to update scheduled tasks in a single operation
- [Script Templates (.cfs)](recipes/script-templates.md) - Learn about script templates in Lucee. This guide explains how Lucee supports templates with the `.cfs` extension, allowing you to write direct script code without the need for the `<cfscript>` tag.
- [Secret Management](recipes/secret-provider.md) - Managing Secrets in Lucee applications
- [Sending Emails](recipes/mail-how-to-send-a-mail.md) - How to send an email using Lucee with help of the tag cfmail.
- [Session Handling in Lucee](recipes/session-handling.md) - Comprehensive guide on session handling and configuration in Lucee, including session types, storage options, and security considerations.
- [Setting System Properties and Environment Variables](recipes/setting-system-properties-and-env-vars.md) - How to set and use Environment Variables or System Properties to configure specific Lucee Server settings.
- [Single Mode vs Multi Mode](recipes/single-vs-multi-mode.md) - Understanding the differences between Single mode and Multi mode in Lucee.
- [SQL Types](recipes/sql-types.md) - SQL types for query parameters
- [Startup Listeners: Server.cfc and Web.cfc](recipes/startup-listeners-code.md) - Lucee supports two types of Startup Listeners: Server.cfc and Web.cfc.
- [Static Scope in Components](recipes/static-scope-in-components.md) - Understanding the static scope in Lucee components and how it can be used for shared data and functions.
- [Sub Components](recipes/sub-components.md) - Learn how to create and use sub components in Lucee. This guide demonstrates how to define additional components within a .cfc file, making it easier to organize related components. Examples include creating a main component with sub components, and how to address/load these sub components.
- [Supercharge your website](recipes/supercharge-your-website.md) - This document explains how you can improve the performance of your website in a very short time with Lucee.
- [SystemOutput, writing to the console](recipes/function-systemoutput.md) - This document explains the systemoutput function with some simple examples.
- [Tag Islands](recipes/tag-islands.md) - Tag islands allow you to switch into tag mode from inside cfscript
- [Tag Syntax](recipes/tag-syntax.md) - How to use tags in script
- [Thread Dump During Startup](recipes/thread-dump-startup.md) - How to capture thread positions during Lucee startup for debugging and performance analysis
- [Thread Tasks](recipes/thread-task.md) - How to use Thread Tasks
- [Timeout](recipes/timeout.md) - Learn how to use the <cftimeout> tag in Lucee. This guide demonstrates how to define a timeout specific to a code block, handle timeouts with a listener, and handle errors within the timeout block.
- [Troubleshooting Lucee Server problems](recipes/troubleshooting.md) - A guide to diagnosing problems with Lucee
- [Update current Application Context](recipes/application-context-update.md) - How to update your Application settings, after they have been defined in Application.cfc.
- [Using Maven directly via CFML](recipes/maven.md) - How to use Maven in Lucee
- [Using S3 directly for source code](recipes/using-s3-directly-for-source-code.md) - Using S3 directly for source code
- [Virtual File Systems](recipes/virtual-file-system.md) - Lucee supports the following virtual file systems: ram, file, s3, http, https, zip, and tar.
- [WebSocket Extension](recipes/websocket-extension.md) - How to install, configure and create WebSockets
- [XML Fast And Easy, using SAX - Listener Functions](recipes/xml-fast-and-easy.md) - This document explains how to use XML parsing in Lucee.
- [YAML Processing in Lucee 7](recipes/yaml-processing.md) - Simple recipe for processing YAML files in Lucee 7 using Maven integration and SnakeYAML