# Lucee Documentation

Welcome to the Official [Lucee Server](https://lucee.org) Documentation

---

Lucee is a [high performance](https://community.ortussolutions.com/t/how-does-cfml-really-perform-compared-to-other-languages/9325), [open source](https://github.com/lucee/Lucee), ColdFusion / CFML server engine, written in Java.

The documentation here aims to provide a thorough reference and guide to all things to do with the Lucee Server. This includes reference material on both [Functions](reference/functions.md) and [Tags](reference/tags.md) as well as more in-depth articles in the [Guides and tutorials](guides.md) section.

Our documentation is an open source and community driven effort. It is also a constant work in progress and we always welcome feedback, improvements and suggestions.

If you're interested in contributing to Lucee as a Developer, checkout our [Git Repo](https://github.com/lucee/Lucee/blob/7.0/CONTRIBUTING.md)

## Lucee 7.0

Lucee 7 is our latest release, switching to only Single mode and Jakarta.

[Lucee 7 new features](guides/lucee-7.md)

[Lucee 7.0 ChangeLog](https://download.lucee.org/changelog/?version=7.0)

[Breaking Changes between Lucee 6.2 and 7.0](recipes/breaking-changes-7.md)

[Form posts about Lucee 7.0](https://dev.lucee.org/tag/lucee-7)

## Recipes - Lucee Guides and Tutorials

We are always adding and updating our detailed [Lucee Recipes](recipes.md) showing you how to take advantage of the wide range of features in Lucee.

Feel free to request new topics or ask questions via the [dev forum](https://dev.lucee.org/).

**Latest Content**




- [Dynamic Proxy Enhancements in Lucee 7](recipes/dynamic-proxy-enhancements.md) 10-Oct-25
- [SQL Types](recipes/sql-types.md) 10-Oct-25
- [Custom Tag Mappings](recipes/custom-tag-mappings.md) 10-Oct-25
- [Scheduled Tasks - efficiently updating in a single operation](recipes/cfschedule-bulk-update.md) 27-Aug-25
- [Hooks and Monitors](recipes/hooks-and-monitors.md) 26-Aug-25
- [REST Services with Lucee](recipes/rest-services.md) 23-Aug-25
- [Thread Dump During Startup](recipes/thread-dump-startup.md) 21-Aug-25
- [Query Result Logging](recipes/query-result-threshold.md) 14-Aug-25
- [Console logging using SystemOutput](recipes/console-logging.md) 14-Aug-25
- [Tag Islands](recipes/tag-islands.md) 13-Aug-25
- [AST (Abstract Syntax Tree)](recipes/ast.md) 18-Jul-25
- [Java Scripting with Lucee](recipes/java-scripting.md) 15-Jul-25
- [Recommended Settings](recipes/recommended-settings.md) 14-Jul-25
- [Date and Time Formatting in Lucee](recipes/date-time-formatting.md) 23-Jun-25
- [Lucee 5 to 6 Migration Guide](recipes/lucee-5-to-6-migration-guide.md) 16-Jun-25
- [Application.cfc guide](recipes/application-cfc.md) 05-Jun-25
- [Directory Placeholders](recipes/directory-placeholders.md) 05-Jun-25
- [Setting System Properties and Environment Variables](recipes/setting-system-properties-and-env-vars.md) 05-Jun-25
- [Best Practices: Structs vs Inline Components](recipes/structs-vs-components.md) 03-Jun-25
- [Excel Processing in Lucee 7](recipes/excel-processing.md) 27-May-25
- [CSV Processing in Lucee 7](recipes/csv-processing.md) 27-May-25



To see what's new in Tags and Functions refer to [Lucee Changelog, new Tags & Functions, Arguments and Attributes](reference/changelog.md)

## Deploying Lucee

[Deploying Lucee](guides/deploying-lucee-server-apps.md) - How to configure and deploy Lucee

[Locking Down Lucee ](guides/deploying-lucee-server-apps/locking-down-lucee-server.md) - Security best practices for Lucee

[Configuration - CFConfig.json](recipes/configuration.md) - All about Lucee's configuration file

## Lucee 6.2

[Lucee 6.2](https://dev.lucee.org/tag/lucee-62) is our latest stable release, with enhanced Java and Maven integration, Jakarta Servlet support and better runtime performance.

Lucee 6.2 up to 50% faster than Lucee 5.4, while using less memory.

Our Official Docker images and Installers for 6.2 all bundle Tomcat 10.1 and Java 21. This may cause issues with the switch to the Jakarta namespace, Lucee 6.2 supports both, but anything which integrates with Tomcat (i.e. urlrewrite) will need updating, see the [Jakarta](https://luceeserver.atlassian.net/issues/?jql=labels%20%3D%20%22jakarta%22) issues in our bug tracker.

[Lucee 6.2 ChangeLog](https://download.lucee.org/changelog/?version=6.2)

[Breaking Changes between Lucee 6.1 and 6.2](recipes/breaking-changes-6-2.md)

## Lucee 6.1

Targeting better performance and reduced memory usage, Lucee 6.1 introduces full support for Java 17 and 21, as well as Java 11.
Java 8 is no longer officially supported.

[Breaking Changes Between Lucee 6.0 and 6.1](recipes/breaking-changes-6-1.md)

## Lucee 6.0

[Lucee 6](https://dev.lucee.org/tag/lucee-6).

Highlights include, reduced size, faster startup, single context mode, JSON based configuration and much more.

As a Major Release, Lucee 6 does include some potential **BREAKING CHANGES**, for a range of security reasons and better compatibility with Adobe ColdFusion.

[Breaking Changes between Lucee 5.4 and 6.0](recipes/breaking-changes-6-0.md)

[Lucee 5 to 6 Migration Guide](recipes/lucee-5-to-6-migration-guide.md)

## Lucee 5.4 (LTS)

Lucee 5.4 is our [LTS stable release](https://lucee.org/downloads.html) and is recommended for production systems. More details are available in the [Lucee 5](/guides/lucee-5.html) section of these docs.

Only Java 8 and 11 are supported, there are various changes in Java 21 including date time handling which are not addressed in 5.4, time to upgrade!

As a LTS release, Lucee 5.4 will receive security updates and critical regression fixes until December 31st 2025, **but is no longer actively maintained.**

## Getting help

- Our mailing list / forum is over at [https://dev.lucee.org/](https://dev.lucee.org/)
- [Lucee Support - How to report bugs/problems and get help](guides/Various/tutorial-lucee/tutorial-reporting-bugs.md)
- [Troubleshooting Lucee Server problems](recipes/troubleshooting.md)

## Lucee 5.3

Lucee 5.3 (and older) now is no longer actively developed. It's time to upgrade to 5.4 LTS or 6 (recommended)

## Lucee 4.5

Lucee 4.5 is the [legacy stable release](https://lucee.org/downloads.html) of the Lucee platform. It is End of Life (EOL) and no longer supported.

## Java API Docs

The Java API documentation of Lucee Server's loader interfaces, are published at [https://www.javadoc.io/doc/org.lucee/lucee/latest/index.html](https://www.javadoc.io/doc/org.lucee/lucee/latest/index.html).

## Lucee on YouTube

We also have a channel on YouTube where you can find further tutorials and tips: [Lucee YouTube Channel](https://www.youtube.com/channel/UCdsCTvG8-gKUu4zA309EZYA)