# Lucee 7 new features

# Lucee 7 - Single Mode & Jakarta Edition

Lucee 7 is a major release that fundamentally changes how Lucee works by moving to **Single Mode only** and migrating to **Jakarta EE**. It also drops Java 8 support, delivers significant performance improvements, and reduces the core distribution size.

## What You Need to Know

- **Single Mode Only**: Multi-mode is gone - this is THE biggest change for users [Single Mode vs Multi Mode](../recipes/single-vs-multi-mode.md)
- **New Features**: Enhanced AI & Java support, AST parsing and a Secret Provider
- **Performance**: Multiple optimizations - faster startup, lower memory usage
- **Faster Startup and Deployment** Deployment is up to 3x faster than 6.2
- **Jakarta EE**: Full migration from javax to jakarta namespace (requires Tomcat 10.1+)
- **Fresh Install Required**: Cannot upgrade via admin - requires Tomcat 10.1+ and new extensions
- **Smaller & Faster**: 20MB smaller core distribution
- **Security First**: Better defaults, removed insecure legacy features

## New Features in Lucee 7

For a complete list of new and updated tags and functions, checkout our [Lucee Changelog, new Tags & Functions, Arguments and Attributes](../reference/changelog.md).

Some of these features were experimental in Lucee 6.2 and are now stable and production-ready in Lucee 7.

### AI Support

AI integration functions are now production-ready:

- [CreateAISession()](../reference/functions/createaisession.md) - Create a new AI session
- [inquiryaisession()](../reference/functions/inquiryaisession.md) - Query an AI session
- [SerializeAISession()](../reference/functions/serializeaisession.md) - Save AI conversation state
- [LoadAISession()](../reference/functions/loadaisession.md) - Restore AI conversation state
- [AIHas()](../reference/functions/aihas.md) - Check if AI provider exists
- [AIGetMetaData()](../reference/functions/aigetmetadata.md) - Get AI provider metadata

This enables persistent AI conversations across requests and application restarts.

- [AI Session Serialization](../recipes/ai-serialisation.md) - AI session serialization
- [AI Augmentation with Lucene](../recipes/ai-augmentation.md) - AI augmentation with Lucene (RAG)
- [AI (experimental)](../recipes/ai.md) - AI integration guide

### Enhanced Java Support

Improved Java interop and integration that was experimental in 6.2 is now stable.

- [Java Class Interaction](../recipes/java-class-interaction.md) - Seamless integration with Java classes
- [JavaSettings in Application.cfc, Components and CFConfig.json](../recipes/java-settings.md) - Java settings with Maven support
- [getClass() Method for Components](../recipes/component-getclass-method.md) - Dynamic proxy creation for components
- [Interacting with Java Libraries](../recipes/java-libraries.md) - Loading and using Java libraries
- [Java Scripting with Lucee](../recipes/java-scripting.md) - Using Java scripting engines
- [Java - Explicit Casting of a Component to a Specific Interface](../recipes/java-explicit-casting.md) - Type casting in Java interop
- [Java in Functions and Closures, function() type='java'](../recipes/java-in-functions-and-closures.md) - Java usage patterns
- [Convert a CFML Function/Component to use in Java](../recipes/convert-a-cfml-func-to-java.md) - Converting CFML to Java

### AST (Abstract Syntax Tree) Support

Parse CFML code into an [AST (Abstract Syntax Tree)](../recipes/ast.md) for analysis, tooling, and transformation.

- [astFromPath()](../reference/functions/astfrompath.md) - Parse CFML file to AST
- [astFromString()](../reference/functions/astfromstring.md) - Parse CFML string to AST

### Secret Provider

Store and retrieve secrets securely using the new [Secret Management](../recipes/secret-provider.md) functionality.

- [SecretProviderGet()](../reference/functions/secretproviderget.md) - Retrieve secrets from configured providers

This allows integration with secret management systems for credentials, API keys, and sensitive configuration.

### Dynamic Proxy Creation

Components implementing Java interfaces now automatically include all functions and properties in the dynamic proxy. Components can now call [getClass() Method for Components](../recipes/component-getclass-method.md) directly to simplify proxy creation for Java interoperability.

See [Dynamic Proxy Enhancements in Lucee 7](../recipes/dynamic-proxy-enhancements.md) for details and examples.

### Lucene 3 - Vector & Hybrid Search

Major upgrade to [Search](../categories/search.md) capabilities with modern semantic search features:

**New search modes:**

- **Vector search** - Semantic search using document embeddings
- **Hybrid search** - Combines keyword and vector search for best results
- **Enhanced chunking** - Better passage extraction and relevance

**Perfect for AI/RAG:**

These features enable Retrieval-Augmented Generation (RAG) patterns, allowing AI models to reference your indexed content for more accurate and contextually relevant responses.

See the [Lucene 3 Extension](../recipes/lucene-search.md) documentation for complete details.

## Dark mode Admin

The Admin now supports dark mode, easier on your eyes!

## Performance Improvements

Lucee 7 includes multiple performance optimizations:

**Specific Optimizations:**

- **queryExecute()** - Optimized execution
- **StringBuffer → StringBuilder** - Replaced throughout codebase
- **Lazy CGI Scope Loading** - Only load when accessed
- **Parser Whitespace Handling** - Optimized parsing
- **Application.cfc Single Execution** - Reduced overhead (LDEV-4978)

**Result:** Faster startup, lower memory usage, better runtime performance.

Modern Java versions (Java 21+) further enhance performance with JVM improvements.

## Single Mode Only

**This is the core change in Lucee 7.**

Multi-mode is gone. Lucee 7 only supports Single Mode (introduced in Lucee 6.0). This fundamentally changes how web contexts, configurations, and extensions work.

See [Single Mode vs Multi Mode](../recipes/single-vs-multi-mode.md) for complete details on what this means and how to migrate.

**Why this matters more than Jakarta:**

- Affects how you deploy and configure Lucee
- Changes how extensions are managed
- Impacts configuration file locations
- Requires understanding the new architecture

## The Jakarta Switch

Lucee 7 is now based on [Jakarta EE](https://jakarta.ee/) instead of Java EE.

**What this means:**

- **Tomcat 10.1 or higher required** (Tomcat 9 and older no longer supported)
- All `javax.*` imports become `jakarta.*`
- **All extensions must be Jakarta-compatible** (cannot use old javax extensions)
- Fresh install strongly recommended

```cfml
// Old (Lucee 6.2 and earlier)
import javax.servlet.http.HttpServletRequest;

// New (Lucee 7)
import jakarta.servlet.http.HttpServletRequest;
```

### Tomcat Version Requirements

- **Tomcat 10.1+**: Minimum (Jakarta EE support)
- **Tomcat 11**: Requires Java 17+ minimum

## Java Version Requirements

**Java 21: Recommended** (Target version)

- Official target for Lucee 7

**Java 24/25: Better Performance** (supported)

- Released too late in dev cycle to be the official target, will be for 7.1
- Offers better performance

**Java 17-20: Not Recommended**

- Has Unicode/date handling quirks

**Java 11: Minimum**

- Supported but slow
- Will be dropped in future releases
- Not recommended for production

**Java 8: ❌ NO LONGER SUPPORTED**

### ⚠️ Unicode Date Handling Warning

Java versions 17-20 have Unicode-related issues, particularly with date handling. These issues were resolved in Java 21. **Avoid Java 17-20 in production.**

If you're on Java 8, you **must** upgrade to at least Java 11, but **Java 21 is strongly recommended**.

## Extensions & Dependencies

### Extensions Require Jakarta Versions

**Critical:** You cannot use old Tomcat 9/javax-based extensions with Lucee 7. All extensions must be Jakarta-compatible.

When upgrading:

1. Check each extension for Jakarta compatibility
2. Install latest versions from the extension provider
3. Test thoroughly before production deployment

### No Longer Bundled

**EHCache** is no longer included by default (still available as an extension).

- **Old**: 84 MB `lucee.jar`
- **New**: 64 MB `lucee.jar`
- **Reduction**: 20MB (24% smaller)

[LDEV-5267](https://luceeserver.atlassian.net/browse/LDEV-5267)

If you need EHCache, install it as an extension.

### JDBC Driver Updates

- **MySQL**: Updated to latest driver
- **PostgreSQL**: Updated to latest driver

These updates bring bug fixes, security patches, and better performance.

## Breaking Changes

For the complete list, see [Breaking Changes between Lucee 6.2 and 7.0](../recipes/breaking-changes-7.md).

### High Impact Changes

**1. Single Mode Only**

- Multi-mode removed, no more web contexts or Administrators
- Different configuration architecture
- See [Single Mode vs Multi Mode](../recipes/single-vs-multi-mode.md) for migration

**2. Jakarta Namespace**

- `javax.*` → `jakarta.*`
- Requires Tomcat 10.1+
- All extensions must be Jakarta-compatible
- [LDEV-4910](https://luceeserver.atlassian.net/browse/LDEV-4910)

**3. Java 8 Dropped**

- Minimum: Java 11
- Recommended: Java 21
- Avoid: Java 17-20 (Unicode issues)

**4. Implicit Tag Variables Now Scope to Local**

When tags like [<cfquery>](../reference/tags/query.md), [<cflock>](../reference/tags/lock.md), [<cffile>](../reference/tags/file.md), and [<cfthread>](../reference/tags/thread.md) create **implicit result variables** inside functions, they now default to `local` scope instead of `variables` scope.

This fixes potential race conditions where implicit variables leaked into the shared `variables` scope.

[LDEV-5416](https://luceeserver.atlassian.net/browse/LDEV-5416)

**Before (Lucee 6.2):**

```cfml
function getUsers() {
	// No name attribute - creates implicit "result" variable in variables scope
	cfquery( datasource="myDB", sql="SELECT * FROM users" );
	return result; // result was in variables scope (thread safety issue!)
}
```

**After (Lucee 7):**

```cfml
function getUsers() {
	// No name attribute - creates implicit "result" variable in local scope
	cfquery( datasource="myDB", sql="SELECT * FROM users" );
	return local.result; // properly scoped to local!
}
```

**Restore old behavior (if needed):**

Since: 7.0.1.13

If you need the pre-LDEV-5416 behavior where implicit tag variables are created in `variables` scope (unless a `local` variable already exists):




---

## LUCEE_TAG_POPULATE_LOCALSCOPE

*SysProp:* `-Dlucee.tag.populate.localscope`
*EnvVar:* `LUCEE_TAG_POPULATE_LOCALSCOPE`

Controls whether tags like cflock and cfquery populate their default result variables to local scope when inside a function. When `true`, variables go to local scope. When `false`, restores pre LDEV-5416 behavior where variables go to variables scope

**Type:** boolean | **Default:** true | **Introduced:** 7.0.1.13

**Related tags:** [<cflock>](../reference/tags/lock.md), [<cfquery>](../reference/tags/query.md), [<cffile>](../reference/tags/file.md), [<cfthread>](../reference/tags/thread.md)

---




[LDEV-5849](https://luceeserver.atlassian.net/browse/LDEV-5849)

**5. Loader API Changed**

- Cannot upgrade via admin from 6.2 to 7.0
- Must manually replace loader JAR
- See upgrade process below

### Medium Impact Changes

**[<cfcache>](../reference/tags/cache.md) Query String Behavior**

- Now **ignores query strings** by default (matches Adobe ColdFusion)
- Use `useQueryString=true` for old behavior
- [LDEV-5722](https://luceeserver.atlassian.net/browse/LDEV-5722)

### Low Impact Changes

**[<cfhttp>](../reference/tags/http.md) URL Encoding**

- Spaces properly encoded (not double-encoded)
- Remove workarounds for old bug
- [LDEV-3349](https://luceeserver.atlassian.net/browse/LDEV-3349)

**[<cfmail>](../reference/tags/mail.md) Encoding**

- Quoted-printable encoding (7-bit) now default
- Better HTML email rendering
- [LDEV-4039](https://luceeserver.atlassian.net/browse/LDEV-4039)

**Cookie Storage Removed**

- `loginStorage="cookie"` - ❌ Removed
- `sessionStorage="cookie"` - ❌ Removed
- Insecure and rarely used
- [LDEV-5403](https://luceeserver.atlassian.net/browse/LDEV-5403)

## Security Improvements

### Bytecode Execution Blocked by Default

Preventing CFML files containing Java bytecode from being executed, protecting against CVE-2024-55354.




---

## LUCEE_COMPILER_BLOCK_BYTECODE

*SysProp:* `-Dlucee.compiler.block.bytecode`
*EnvVar:* `LUCEE_COMPILER_BLOCK_BYTECODE`

Controls whether Lucee blocks the direct execution of precompiled bytecode files (.cfm). When `true`, only source code CFML files are allowed. Bytecode execution is blocked by default in Lucee 7 for security reasons

**Type:** boolean | **Default:** true | **Introduced:** 6.1.1.114

---




[LDEV-5485](https://luceeserver.atlassian.net/browse/LDEV-5485)

### Insecure Features Removed

Cookie-based session storage removed (see Breaking Changes above).

## The Upgrade Process

### Fresh Install Required

**You cannot upgrade via the admin from 6.2 to 7.0.**

Lucee 7 requires:

- Tomcat 10.1+ (for Jakarta)
- All Jakarta-compatible extensions
- Single Mode architecture

**Recommended Approach:**

1. **Set up new Lucee 7 instance**
2. **Install Tomcat 10.1+**
3. **Install Lucee 7** from [download.lucee.org](https://download.lucee.org/)
4. **Install Jakarta-compatible extensions**
5. **Migrate configuration**
6. **Test thoroughly**
7. **Deploy**

### Manual Loader Replacement (Not Recommended)

If you must try to upgrade an existing installation:

1. **Stop Lucee**
2. **Upgrade Tomcat** to 10.1 or higher
3. **Replace the loader JAR**:
   - Find `lucee/lib/lucee-6.2.x.xxx.jar`
   - Replace with `lucee.jar` from [download.lucee.org](https://download.lucee.org/)
4. **Restart Lucee**

If you get a 500 error:

- Stop Lucee
- Delete `.lco` files from `lucee/tomcat/lucee-server/patches`
- Replace the loader JAR properly
- Restart

**Note:** Fresh install is strongly recommended over manual replacement.

### Migration Checklist

1. ✅ **Upgrade Java** to 21 (recommended) or 24/25 (best performance)
2. ✅ **Upgrade Tomcat** to 10.1 or higher
3. ✅ **Review Single Mode architecture** - understand the changes
4. ✅ **Check all extensions** for Jakarta compatibility
5. ✅ **Update javax imports** to jakarta (if you have Java code)
6. ✅ **Fix function-scoped queries** (add `local.` prefix)
7. ✅ **Test cfcache** if you rely on query string behavior
8. ✅ **Check cfhttp** calls if you have URL encoding workarounds
9. ✅ **Review cookie-based session storage** (if you were using it)
10. ✅ **Install EHCache extension** if you need it
11. ✅ **Run your test suite** extensively!

## Resources

- [Breaking Changes between Lucee 6.2 and 7.0](../recipes/breaking-changes-7.md) - Complete list of breaking changes
- [Single Mode vs Multi Mode](../recipes/single-vs-multi-mode.md) - Understanding Single Mode
- [Deploying Lucee](deploying-lucee-server-apps.md) - Deployment guide
- [Configuration - CFConfig.json](../recipes/configuration.md) - Configuration options
- [Environment Variables / System Properties for Lucee](../recipes/environment-variables-system-properties.md) - Environment variable reference
- [Lucee 5 to 6 Migration Guide](../recipes/lucee-5-to-6-migration-guide.md) - General migration guidance
- [Tomcat 9 to Tomcat 11 Upgrade Guide](https://dev.lucee.org/t/lucee-5-4-to-6-2-upgrade-guide-tomcat-9-to-tomcat-11/14854) - Fresh install process

## Community and Support

For questions, issues, or feature requests:

- [Lucee Dev Forum](https://dev.lucee.org/)
- [Troubleshooting Lucee Server problems](../recipes/troubleshooting.md)

# See Also

[Single Mode vs Multi Mode](../recipes/single-vs-multi-mode.md)