# Lucee 5

# Lucee 5

Lucee 5 is the first major release after forking from the Railo project. Lucee 5 is not about dazzling new features but about improving the core language and providing a complete architectural overhaul of the engine.

This brings Lucee and CFML to a whole new level! <https://download.lucee.org>.

## Architecture Enhancements ##

Lucee 5 has had a complete overhaul under the hood. A lot of the existing functionality has been completely re-worked, as well as extending the interfaces to the engine to make way for a lot of possible functionality in the future.

* [Lucee 5 and OSGi](lucee-5/osgi.md) - Lucee 5 is completely [OSGi](https://en.wikipedia.org/wiki/OSGi) based, OSGi is the defacto standard in most Java enterprise environments, to manage bundles (jar libraries) used by the environment.

* Modularity - CFML is come a long way over the years and along the way it has collected a lot of very useful functionality, but every bit of functionality you are not using is a burden. With Lucee 5, and in part thanks to OSGi, we have been able to moved a lot of functionality out of the core and into extensions. All these extensions are installed by default, so you have the same experience as you had before out of the box. However now you can uninstall what you are not using to reduce Lucee's footprint. Functionality that has so far been moved to extensions are Hibernate (ORM), Lucene (Search), all datasource drivers, S3 Resource, PDF/Document tags and chart tags. This is simply the beginning and we will be moving more functionality out into extensions over the coming months.

* Scripting (JSR 223) - Lucee 5 fully supports the [Java Scripting](https://en.wikipedia.org/wiki/Scripting_for_the_Java_Platform) standard. Java scripting allows you to use Lucee in places you could not previously. For example, the interface used by the Lucee build process within ANT, to run the CFML testcases and the CFML code has full access to the ANT environment.

* [Class Updating](lucee-5/class-updating.md) - Previously an optional feature in Lucee 4, class updating is now an integral part of Lucee 5. Lucee 5 is able to update existing classes and this has a large impact on memory consumption, particularly in environments where a lot of CFML templates are used. This feature no longer requires any configuration and is "always on".

* Bytecode Handling - We have improved the generated Java Bytecode produced in general by optimizing it for Java >=7 and we have done specific improvements of the generated bytecode in multiple places.

## Language Enhancements ##

Lucee 5 provides the following core language enhancements:

* [Abstract/Final Modifiers](lucee-5/abstract-final.md) - Lucee already supports interfaces, but interfaces have not been well adopted by the community, because they are only used to do "sign a contract" when you implement them. Abstract and Final modifiers are a much more intuitive and flexible way to do the same and more.

* [Static Scope in Components](../recipes/static-scope-in-components.md) - Lucee 5 supports static variables and functions inside components.

* [Lambda Expressions](lucee-5/lambda.md) - Lucee 5 support Lambda Expression alongside closures, a shorthand notation for anonymous functions.

* [New and modified functions](lucee-5/functions-tags.md) - New and modified functions in Lucee 5.

* [New and modified tags](lucee-5/tags.md) - New and modified tags in Lucee 5.

* [Cached Within](lucee-5/cached-within.md) - We not only added the attribute `cachedWithin` to the tag `cffile` and `cfhttp`, we have also added an interface to Lucee to make your own `cachedwithin` implementation.

* [Handling unquoted arguments as variables](lucee-5/unquoted-arguments.md)

* [The Lucee dialect (removed 6.1)](lucee-5/dialect-lucee.md) - In addition to the existing "CFML" language dialect, Lucee 5 comes with a completely new dialect simply called "Lucee".

* [Extended Java Interface](lucee-5/java-interface.md) - (TODO) - Lucee provides an interface to interact with Lucee from within Java, Lucee 5 has extended this interface with lots of new functionality, which makes it far easier to write Extensions for Lucee.

## Extensions ##

Lucee 5 has had a complete overhaul of the existing extension framework, to make it easier for anyone to create an extension. See [Extensions in Lucee 5](lucee-5/extensions.md)

## Install/Upgrade instructions ##

* Fresh install - We provide various possibilities to install Lucee in different ways, simply download your favorite package from [here](https://lucee.org/downloads.html).
* [Upgrading from Lucee 4.5](lucee-5/upgrading-lucee-45.md) - Updating from Lucee 4.5 (or Railo) is as simple as replacing a single file, but you can do a little bit more to have a clean system, see the instructions for more details.