# Installing Lucee on Windows

## Introduction

There are a few different ways to get Lucee up and running on Windows

- you can [Downloading and Installing Lucee](download-and-install.md) the traditional Installer. Watch this step by step video guide about [Installing Lucee on a clean Windows 2019 Datacenter with installer](windows/installing-lucee-on-windows-2019-with-installer-quick-video-guide.md)
- the Express version (which just runs out of a folder)
- [CommandBox](../getting-started/commandbox.md) which provides an automated way to manage and deploy both Lucee and Adobe ColdFusion servers (it's sort of like Docker but a million times less complex)

## Content ##

Here are some in depth guides to setting up an environment to run Lucee on a Windows, you probably won't
need to delve into the following sections if you are using one of the above approaches as they automate most of this.

* [Installing the Boncode connector and mod_cfml](windows/installing-the-boncode-connector-and-mod_cfml.md)
* [Installing Oracle Java on Windows](windows/installing-oracle-java-on-windows.md)
* [Installing Apache Tomcat on Windows](windows/installing-apache-tomcat-on-windows.md)
* [Installing Lucee And XAMPP (Apache2 & MariaDB) on Windows](windows/installing-lucee-with-xampp-apache2-and-mariadb-on-windows.md)
* [Configuring Tomcat as a Windows service](windows/configuring-tomcat-as-a-windows-service.md)
* [Starting Tomcat and verifying the installation on Windows](windows/starting-tomcat-and-verifying-the-installation-on-windows.md)
* [Installing and configuring Lucee (JAR files) on Windows](windows/installing-and-configuring-lucee-jar-file-on-windows.md)
* [Securing Tomcat and Lucee on Windows](windows/securing-tomcat-and-lucee-on-windows.md)
* [Scripts installing Tomcat and Lucee on Windows](windows/scripts-installing-tomcat-and-lucee-on-windows.md)
* [Installing the JDK on Windows](windows/installing-the-jdk-on-windows.md)
* [Installing the server JRE on Windows](windows/installing-the-server-jre-on-windows.md)

## Check your ports ##

You will run into problems if some of the ports Lucee uses are already in use.

A default install of Lucee uses ports 8888, 8005 and 8009

You can easily check which ports are already in use

- using Powershell ```Get-NetTCPConnection | ? {$_.State -eq "Listen"} | sort LocalPort -Descending```
- via Resource Monitor, Network Tab, Listening Ports (Windows-R, type resmon)
- or thru Task Manager, Performance, open Resource Monitor.

## Prerequisites ##

* A Windows machine with Full administrator privileges
* Basic understanding of the Windows Registry, file system and user management
* Basic familiarity with the command line

## Automated Deployment ##

All of the tasks described in this guide can be integrated into a software management tool such *Microsoft SCCM*. Everything can be done on the command line, which is perfect for scripting and packaging.

- - -
This guide is a work in progress. Please be patient, more to come ;-)

*Author: Martin Schaible. Thanks to Julian Halliwell for the proof reading.*