# Installing Lucee

### Lucee Installer Documentation ###

The Lucee Installer was created with the hope that it would make the deployment of Lucee a very simple process. The Installer creates a stand-alone instance of Lucee, Tomcat, and AdoptOpenJDK (Java JDK) specifically for use with Lucee. It can be run "by itself" or it can be connected to a pre-installed web server: IIS on Windows and Apache on Linux. This installer also performs the web-server to Tomcat server connections for you, which can be customized at any point after the install to meet your own unique needs.

### Developer Forum ###

If you do not find the answers you are looking for here, we encourage you to post to Lucee-Dev. There are many friendly members of the community who are willing to help:

* [Lucee Developer Forum](https://dev.lucee.org)

### Installing and Upgrading ###

[Downloading and Installing Lucee](installing-lucee/download-and-install.md)

**Windows**

* [Installing Lucee on Windows](installing-lucee/windows.md)

**Linux**

* [System Requirements Linux](installing-lucee/installation-linux/system-requirements.md)
* [Launching the Installer](installing-lucee/installation-linux/launching-the-installer.md)
* [Installing in Unattended Mode](installing-lucee/installation-linux/installing-in-unattended-mode.md)
* [Changing the User Account Lucee Runs As](installing-lucee/installation-linux/changing-the-user-account-lucee-uses.md)
* [Upgrading The JRE](installing-lucee/installation-linux/upgrade-JRE.md)
* [Installation on CentOS Linux 6 Best Practices](installing-lucee/installation-linux/installation-on-centOS-linux.md)
* [Installing Lucee on Ubuntu 20.04 LTS Server Apache2 - Video Guide](installing-lucee/installation-linux/linux-ubuntu-quick-video-guide.md)
* [Installing and running Lucee with CommandBox on Ubuntu 20.04 LTS Server and Apache2](installing-lucee/installation-linux/linux-install-ubuntu-commandbox.md)

### Deploying Lucee

[Deploying Lucee](deploying-lucee-server-apps.md)

### Lucee Server Administration ###

**Using Lucee with multiple webserver hosts**

* [mod_cfml](installing-lucee/mod_cfml.md) is an add on for Apache, Nginx and IIS which enables using Lucee with different hosts

**Windows**

* [Starting and Stopping Lucee on Windows](installing-lucee/lucee-server-adminstration-windows/starting-stoping-lucee.md)
* [Adding New Sites](installing-lucee/lucee-server-adminstration-windows/adding-new-site.md)
* [Updating Tomcat Memory Settings](installing-lucee/lucee-server-adminstration-windows/updating-memory-settings.md)
* [Utilizing Tomcat's Built-In Web Server](installing-lucee/lucee-server-adminstration-windows/utilizing-Tomcat-built-in-web-server.md)
* [Updating Tomcat's Server.xml File](installing-lucee/lucee-server-adminstration-windows/utilizing-Tomcat-server-xml-file.md)
* [Updating the uriworkermap.properties File](installing-lucee/lucee-server-adminstration-windows/updating-Tomcat-uriworkermap-properties-file.md)
* [Implementing Log Rotation with Log4j](installing-lucee/lucee-server-adminstration-windows/implementing-log-rotation-with-log4j.md)
* [Configuring SES URL's on Windows OS's](installing-lucee/lucee-server-adminstration-windows/Configuring-SES-url-on-windows.md)

**Linux**

* [Starting and Stopping Lucee on Linux](installing-lucee/lucee-server-adminstration-linux/start-and-stop-lucee.md)
* [Configure Tomcat to Listen to Port 80](installing-lucee/lucee-server-adminstration-linux/configure-Tomcat-listen-to-port.md)
* [Adding Sites](installing-lucee/lucee-server-adminstration-linux/adding-new-site.md)
* [Configuring SES URL's](installing-lucee/lucee-server-adminstration-linux/configuring-SES-url.md)

**Lucee Security Best Practices**

The following sections are intended for system administrators who want to deploy Lucee, via the Lucee Installer, in a secure but easy-to-follow way. This documentation is not intended to guarantee foolproof security, but rather serve as a set of guidelines for common security-minded best practices. It is important for the reader to understand that no system, no matter how well protected, will ever be 100% guaranteed secure; however, by following these simple guidelines the reader can ensure that their systems will deter the vast majority of common intrusion techniques.

* [Preparing your Server - Linux](deploying-lucee-server-apps/preparing-your-server-linux.md)
* [Using the Lucee Installer](installing-lucee/using-the-lucee-installer.md)
* [Locking Down Tomcat](deploying-lucee-server-apps/locking-down-your-lucee-stack.md)
* [Locking Down Lucee ](deploying-lucee-server-apps/locking-down-lucee-server.md)
* [Securing /WEB-INF/ by moving it outside of the web root](installing-lucee/securing-webinf.md)
* [Credits and Contributors](deploying-lucee-server-apps/security-authors-and-contributors.md)

### General Information ###

* [Credits](about-lucee/installation-credits.md)
* [Translations](get-involved/installer-Translation.md)

### Contribute ###

[Developer Forum](https://dev.lucee.org/)