# Getting to know Lucee Server

## What do you get with Lucee Server? ##

Lucee Server is a CFML engine. It allows you to write powerful web-based systems and deploy them to a variety of platforms.

Lucee Server is written in Java and runs in a Java Servlet Container. When you download and install Lucee Server, you get a Servlet Container plus the Lucee code.

But you don't need to worry about that: you access Lucee Server features using CFML, a fast, easy-to-use language that you'll learn in no time at all.

Just write CFML files - typically one per page on your site - and then request them through the browser. Lucee Server will compile your work the first time you request that page.

Lucee Server comes bundled with a lot of services that you'll find useful in building your apps - session management, database connectivity, ORM, search engine, mail, scheduling, fast caches, subsystems for accessing disks, remote servers, Amazon services, support for REST, XML, JSON and much more. At the core of Lucee Server is the Lucee Server Administrator - a web application that lets you configure and maintain your own Lucee applications.

## About CFML ##

CFML, or ColdFusion Markup Language is a catch-all term for a tag-based markup language (CFML) and its scripting counterpart (CFScript). It's an easy-to-learn language that abstracts away unnecessary complexity, leaving you to focus on building functionality.

Typically, you use CFML to write output templates, and CFScript to write business logic, though that's not set in stone -- you can mix and match as you wish.

Here's an example of both:

## CFML ##

CFML code usually goes into files with a .cfm extension.

This fragment outputs some employee details from an employee object, or bean. As you can see, CFML slots right into your presentation format. It's HTML in this case, but could just as easily be used to make RSS, XML, or indeed any data type you like.

```cfml
<cfoutput>
    <h1>Employee details</h1>
    <div>
        <dl>
            <dt>Name</dt>
            <dd>#employee.getName()#</dd>
            <dt>Date of birth</dt>
            <dd>#DateFormat(employee.getDOB(), "dd/mm/yyyy")#</dd>
        </dl>
    </div>
</cfoutput>
```

## CFScript ##

CFScript code usually goes into files with a .cfc extension.

This fragment gets a record from a database and populates an object or bean.

```cfml
var employeeQuery = new Query();
employeeQuery.setSQL("select name, dob from employee where id = :id");
employeeQuery.addParam(name="id", cfsqltype="cf_sql_integer", value="#url.id#");
employeeQuery.execute();
var getEmployee = employeeQuery.getResult();
var employee = new Employee();
employee.setName(getEmployee.name);
employee.setDOB(getEmployee.dob);
```

## Mixed mode ##

It's good practice to keep business logic and presentation separate, but if you want to prototype something quickly, you can bundle them together...

```cfml
<cfquery name="getEmployee">
    select name, dob from employee
    where id = <cfqueryparam type="cf_sql_integer" value="#url.id#">
</cfquery>
```

```cfml
<cfoutput query="getEmployee">
    <h1>Employee details</h1>
    <div>
        <dl>
            <dt>Name</dt>
            <dd>#name#</dd>
            <dt>Date of birth</dt>
            <dd>#DateFormat(dob, "dd/mm/yyyy")#</dd>
        </dl>
    </div>
</cfoutput>
```

... or mix and match CFML & CFScript like this:

```cfs
<cfscript>
    var getEmployeeQuery = new Query();
    getEmployeeQuery.setSQL("select name, dob from employee where id = :id");
    getEmployeeQuery.addParam(name="id", cfsqltype="cf_sql_integer", value="#url.id#");
    getEmployeeQuery.execute();
    var getEmployee = getEmployeeQuery.getResult();
</cfscript>
```

```cfml
<cfoutput query="getEmployee">
    <h1>Employee details</h1>
    <div>
        <dl>
            <dt>Name</dt>
            <dd>#name#</dd>
            <dt>Date of birth</dt>
            <dd>#DateFormat(dob, "dd/mm/yyyy")#</dd>
        </dl>
    </div>
</cfoutput>
```

## The History of CFML ##

CFML was invented by the Allaire brothers, back in 1995. Web pioneers, they had a vision of a language and platform that would allow easy connections between web pages and databases, freeing developers from the complexities of web development.

They came up with a tag-based syntax with would be familiar to those with HTML experience, and produced ColdFusion, their CFML server.

Before long, ColdFusion had been ported so that it worked on Windows & Unix platforms, and by 1999 had gained the ability to work with Java objects.

Perhaps ColdFusion's biggest changed happened in 2002, when it was released rewritten in Java and with support for object-oriented programming in CFML.

Since then, CFML has been enhanced over successive versions, helped by the introduction of the former CFML Advisory Committee, and the development of products like Lucee Server.

## Lucee Server & CFML compared with... ##

[Lucee Server compared with .NET](getting-to-know-lucee/lucee-server-compared-with-dotnet.md)

[Lucee server compared with Java](getting-to-know-lucee/lucee-server-compared-with-java.md)