# Contributing Contributor's Agreement

### What is it about? ###

Following the lead of other open source projects, the Lucee Server project requires contributors to jointly assign their copyright on contributed code. The Contributor Agreement (CA) gives Lucee Technologies GmbH and the contributor joint copyright interests in the code: the contributor retains copyrights while also granting those rights to Lucee Technologies GmbH as the open source project sponsor.

The CA is derived from the Oracle Contributor Agreement (OCA), used for Open JDK, Netbeans and OpenSolaris projects and others. There is a good OCA FAQ answering many questions.

The CA does not change the rights or responsibilities of the Lucee community under the GNU LESSER GENERAL PUBLIC LICENSE. By executing the CA, contributors protect the Lucee code base, enable alternative licensing models, and protect the flexibility to adapt the project to the changing demands of the community.

In order for the CA to be effective, the Lucee Server Project must obtain an assignment for all contributions. Please review the CA for a complete understanding of its terms and conditions. By contributing source code or other material to Lucee Server, you represent that you have a CA with Lucee Technologies GmbH for such contributions.

In order to track contributors, you understand that your full name and
username may be posted on a web page listing authorized contributors that is
accessible via a public URL.

## How to submit your Contributing Contributor's Agreement ##

[LAS Contributor License Agreement (CLA)](https://dev.lucee.org/t/las-contributor-license-agreement-cla/181)

[Online Contributor's Agreement from](https://cla-assistant.io/lucee/Lucee)

When you make your first PR for Lucee, GitHub Actions will automatically check for a CA and prompt you to sign one if required.

## Making a contributions ##

Before you invest time working on a change, discuss what you're trying to do with others on the Lucee Google Group. They're likely to be able to offer comments and suggestions that will result in a higher-quality change and a smoother submission process.

Announcing that you're working on a particular item can also help to avoid wasted effort in case someone else is already working on it.

Once you've submitted the CA, you can submit pull requests via GitHub following the normal GitHub workflow. It always helps to reference a ticket that has been registered via Lucee's JIRA account. Your pull request is much more likely to be accepted if you have also created a test case for it.