# Scopes

## Local scopes

These scopes are not necessarily available between components in the same request -- in other words elements or variables in these scopes may be "out of scope" if set in one module and referred to in another.

| Scope      |                    Description                                                   | Notes |
| ---------- | -------------------------------------------------------------------------------- | ----- |
| local      | The local scope for just the function, i.e. `var i;`                             |       |
| arguments  | Holds arguments that are passed to a function or CFC method, can be referenced by position or index                      |       |
| attributes | Contains attributes that are passed to a custom tag                              |       |
| caller     | Refers to the scope of the calling page when a custom tag or module is called    |       |
| this       | The public scope for a Component/CFC                                             |       |
| thread     | The scope within a thread                                                        |       |
| variables  | The private scope for a Component/CFC                                            |       |

## Request scopes

These scopes persist through a single request, i.e. any code, in any module, can refer to these scopes during the life of the request:

| Scope   |                    Description                                                                                                             | Notes                                                                                                                 |
| ------- | ------------------------------------------------------------------------------------------------------------------------------------------ | --------------------------------------------------------------------------------------------------------------------- |
| form    | Contains arguments that are received from HTML POST operations, i.e. usually form data                                                     | Lucee has an option to merge form and URL scopes. If this option is enabled, both scopes will contain the same items. |
| cgi     | Holds environment variables generated by the web server. |  CGI variables will vary according to server platform in use and browser.       |                                                                                                                       |               
| request | Used to store data across an entire request. Data put into the request scope will be accessible from all templates, CFCs, custom tags, etc |                                                                                                                       |
| url     |                                                                                                                                            |                                                                                                                       |

With Lucee 6.1, the url decoding was updated to use Apache Commons Codec, which is slightly stricter, but also more robust.

## Query scopes

By default in cfml, inside a query [<cfloop>](../../reference/tags/loop.md) or [<cfoutput>](../../reference/tags/output.md), queries are checked for unscoped variables, even before the `variables` scope.

In a function / cfc the `local` scope is checked before the `queries` scope, the `variables` scope is always checked afterwards.

This (slow) lookup can be disabled (for better performance) in the Lucee admin or via the `Application.cfc` setting `this.searchResults = false;`

```cfml
// Application.cfc
component {
   this.searchResults = false; // default is true
}
```

### Global scopes

These scopes persist between requests, i.e. a value can be set during one request then retrieved in a subsequent one:

| Scope       | Description                                                                        | Notes      |
| ----------- | ---------------------------------------------------------------------------------- | ---------- |
| application |	Holds elements that relate to the application as a whole.                          |            |
| client      | Contains elements that persist indefinitely for this particular client (browser).  |            |
| cookie      | Refers to the scope of the calling page when a custom tag or module is called      |            |
| server      | Used to store data that is accessible from any application on a particular server. |            |
| session     | Holds data pertaining to the user's session. See [Session Handling in Lucee](../../recipes/session-handling.md)              |            |
| cluster     |                                                                                    | Deprecated |

## Scope Cascading

When a variable is referenced without a scope, Lucee defaults to looking in the nearest scope.

For functions that nearest scope is `local` scope, followed by the `arguments` scope, otherwise, it's the `variables` scope (which is 3rd within functions).

Scope cascading is configurable in Lucee, at the server level via the Admin / .CFConfig.json, or via Application.cfc.

```cfml
// Application.cfc
component {
   this.scopeCascading="strict"; // default is standard
}
```

The available scope cascading modes are:

- `standard` [ local, arguments ], variables, cgi, url, form and cookie (default)
- `small` [ local, arguments ], variables, url and form
- `strict` [ local, arguments ], variables

`local` and `arguments`, are only available within a function.

Unlike ACF, Lucee has never included the `CFFILE` scope in the cascaded scopes.

**Strict is recommended for the best performance and security**, but requires testing and refactoring your code to ensure every variable is properly scoped.

## Form and URL scope struct behaviour

Lucee by default, will parse dotted form fields and url parameter names into structs, which differs from ACF.

I.e. calling `index.cfm?p=hello&p.ico=1`, results in an URL scope of `{"p":{"ico":"1"},"p.ico":"1"}`

Since Lucee 6.1, this behaviour can be toggled off via the admin / `.CFConfig.json` under **Settings - Scope** .

It can also be configured per [Application.cfc / <cfapplication>](../../reference/tags/application.md) using `this.formUrlAsStruct=boolean`

```cfml
component {
   this.formUrlAsStruct=false;
}
```

Which results in an URL scope of `{"p":"hello","p.ico":"1"}`

[LDEV-4815](https://luceeserver.atlassian.net/browse/LDEV-4815)

## What scope should I use in...? ##

### Custom tags ###

### Classic custom tags ###

The variables scope of a classic CFM-based custom tag is local to the custom tag only. It is safe to use that scope for any variables that you want to be available only within the tag itself.

### CFC-based custom tags ###

The normal rules for CFCs apply.

### Should I use scopes explicitly? ###

Different developers have opinions about whether it is best to explicitly write every scope, or to let Lucee look for the variable in each scope, i.e.

```cfml
myVariable
```

vs

```cfml
variables.myVariable
```

Please see [Using scopes explicitly in code](scope/using-scopes-explicitly-in-code.md) for details.

## Further information required ##

* CGI scope reference
* thisTag

# Categories

[Scopes](../../categories/scopes.md), [Compatibility / Migration with other CFML engines](../../categories/compat.md), [Core CFML Language](../../categories/core.md)

# See Also

[Localmode, how to migrate from Classic to Modern Local Scope Mode](../../recipes/migrate.md), [Static Scope in Components](../../recipes/static-scope-in-components.md), [Migrating to Lucee from ColdFusion](../updating-lucee/migrate-from-acf.md)