# Reserved Words

The reserved words in the Lucee CFML templating language are

- null (since Lucee 4.1)
- true
- false

But there are a few that cannot be used all over the place.

Even words such as "application" and "function" can be used as they are not reserved, so code such as:

```cfml
<cfscript>
	application = 1; // but keep reading below
	function = 1;
</cfscript>
```

is still valid, but since the words above are NOT valid, the following is NOT allowed :

```cfml
<cfscript>
	true = 1;
	null = 1;
</cfscript>
```

In Lucee Server [Scopes](scope.md) are always invoked first, which means all scope names, e.g. variables, url, form, session, application... are effectively reserved words. Lucee resolves scopes before a variable with the same name, so they can't be referenced/reached.

```cfml
application = 1;
dump( application ); // returns the application struct (not 1)

// normal structs can use scope names
st = {};
st.application = 1;
dump( st.application ); // returns 1
```

# Categories

[Core CFML Language](../../categories/core.md), [Scopes](../../categories/scopes.md)