# Lucee Syntax

## Lucee Server language & environment reference ##

### CFML language in Lucee Server ###

[Lucee Language and Syntax Differences](developing-with-lucee-server/language-syntax-differences.md)

Member functions

[Reserved Words](developing-with-lucee-server/reserved-word.md)

[Operators](developing-with-lucee-server/operators.md)

[General deviations from CFML Standards](Various/general-deviations.md)

[Directory Placeholders](../recipes/directory-placeholders.md)

[Scopes](developing-with-lucee-server/scope.md)

### CFML tags ###

[Tags](../reference/tags.md)

### CFML functions ###

[Functions](../reference/functions.md)

## UnSupported CFML ##

[Unsupported Tags & Functions](../reference/unsupported.md)

## Ideas for this page ##

Please feel free to add ideas and comments to this section, which will be created when the structure has been defined.

* Lucee Server language & environment reference

	* Description of Lucee Server language features
	* Reserved words
	* General differences between ACF & Lucee Server
	* Tags
	* Functions
	* Application.cfc & application settings

* Concepts

	* Application Lifecycle

	* Mail (i.e. cfmail, cfpop, cfimap, mail-related tips)

	* Caching
		* Template caching
		* Partial template caching
		* User caches
		* Query caching
		* Page pool

	Both currently on tips and tricks page.

	* Database access & datasources

	* Exception handling

	* Locking

	* Threading

	* Scheduling

	* Serialising data

	* Object-oriented CFML
		* Lucee Server magic functions
		* Implicit conversions

	* ORM

	* ReST Services

	* Event gateways

	* Using Lucee Server virtual filesystems

	* Lucee-Server-only concepts
		* Lucee Server resource bundles
		* Working with Resources and Mappings

	* Writing CFScript vs Tags
		* CFScript based tags

	* Closures

	* Member functions

	* Enhancing Lucee Server

	* Writing custom tags
		* in CFML
		* in CFScript

	* Creating built-in tags

	* Creating built-in functions

	* Extending Lucee Server with Java
		* Where to install external libraries

	* Extending Lucee Server with CFXs (deprecated really?)

	* Lucee Server Extensions
		* Using Lucee Server Extensions
			* Available extensions
			* CouchDB
			* Membase
			* MongoDB
			* Infinispan
			* etc
		* Building your own extensions
	* Creating your own Event Gateway types

* Practices
	* Integration with other systems, e.g. databases, message queues & search engines
	* Design patterns
	* Best practices / architectural patterns
	* Using scopes explicitly in code
	* Secure development
	* Unit testing & continuous integration
	* Debugging
	* Changing dump template
	* Editors & IDEs

* Tutorials & samples
	* Using Java libraries in Lucee Server
	* Sample applications
	* Examplar code samples

# See Also

[getClass() Method for Components](../recipes/component-getclass-method.md), [Import](../recipes/import.md), [New Operator in Lucee](../recipes/new-operator.md), [Null Support](../recipes/null-support.md), [Overwriting and adding Built-in Functions and Tags](../recipes/overwrite-build-in-functions-tags.md), [Tag Syntax](../recipes/tag-syntax.md), [Data Types in Lucee](../recipes/types-in-lucee.md)