# Template Performance / Caching

## Performance / Caching ##

The settings you make here determine how Lucee deals with changed CFM files. 

Normally Lucee will compile any modified file into a new Java class file. While this is very fast (depending on the complexity and size of the file to this might take around 10ms), however, each <cfinclude></cfinclude>, <cfmodule></cfmodule>, CFC invocation, CustomTags call, etc. will check whether the related file has changed.

The following settings are possible:

Setting value      |    Type  | Possible values / short description |
------------------------ | ------------------------- | --- |
Inspect templates (CFM/CFC) |  Radio |  `Never`: Never checks templates whether they have changed or not Once Checks templates only once per request<br> `Always` Checks every template for changes, <br>`Once`: Checks templates only once per request|
Template Cache |  Button  | Allows flushing the templates from the cache |
Query Cache    |  Button  | Allows flushing the queries that are in the query cache |

**Never (best performance)** If selected each requested template which is in the template cache will not be checked for a potential update. 

For sites where the templates do not change during the server runtime this minimizes the system load.

Select this option on a production server which you know that the used templates almost never change. 

If a template is updated, you can simply flush the template cache which will force the server to recheck the files. 

In order to flush the template cache you can also use the function [InspectTemplates()](../../reference/functions/inspecttemplates.md)

**Once (good)**  If selected the templates are only checks once per request for a potential update. 

For sites where the templates do not change very often during the server runtime this minimizes the system load.

I would say that this setting as the best, because it is a very good mix between actuality and performance. 

This is also the default setting.

**Always (bad)** If selected each template that is in the template cache will always be checked for a potential update. This is the best choice for sites where the templates might change during a request, or they change very quite often.

You cannot always choose one of the other two options, since sometimes files are generated by an application during the execution of a request. 

Therefore, this option may be a possibility. But if possible it should be avoided. In order to clear the page pool if you generate files just use the function pagePoolClear().

Let’s have a look what impact this setting has on a normal request. 

We will test the following code:

```cfml
<cfloop from="1" to="10000" index="i">
	<cfinclude template="susi.cfm"></cfinclude>
</cfloop>
```

The code might not make a lot of sense, but it should just simulate an everyday example. Here are the results with the different settings:

Setting   |   Number of Loops     |
----------|--------------------|----------|
          |  10,000            | 100,000 |
Never     |  22 ms             | 227 ms  |
Once      |  23 ms             | 236 ms  |
Always    |  345 ms            | 3447 ms |

You should imagine that on a busy server several things happen at the same time and that many files are involved. Please also consider that this is only the time it takes to check for the change of a template. This means that you can save a considerable amount of time. 

On a development server it might make sense to set the value to „always“ in order to immediately see the changes. But just remember to use the [InspectTemplates()](../../reference/functions/inspecttemplates.md) function.

In addition to determining the way how Lucee treats CFML templates that are in the template cache, you can additionally flush the template and query cache. 

The admin will always display the number of items that are currently stored in the cache. If you click on the "clear cache" button, the items are removed from it. 

Don’t be surprised that some elements reappear in the template cache. In order to flush the cache some templates had to be called and they land in this cache.

The server administrator determines what the standard caching method is, which of course you can overwrite in the webadmin. 

This is why you have a button here that will reset any changes you have made to the value set in the server admin.

# Categories

[Cache](../../categories/cache.md), [Lucee Server related Tags, Functions and Guides](../../categories/server.md)

# See Also

[InspectTemplates()](../../reference/functions/inspecttemplates.md)