# Why Lucee Server's great

We all think Lucee Server's great... and hopefully you will too. Don't just take our word for it though. Join our community of Lucee Server developers and administrators to learn more at any time - see the section [How to get help](how-to-get-help.md) to find out more.

### Free and open-source ###

It's free to use, and open source. Whether you're working on a small personal project or a massive corporate business, you can benefit from Lucee Server's low cost of ownership. Better yet, if you're not happy with the way Lucee Server works, or need to incorporate specific functionality, you can change it!

Lucee Server is released under the [GNU Lesser General Public License, version 2.1.](http://www.gnu.org/licenses/lgpl-2.1.html)

### Stable future ###

There's no need to worry that Lucee may disappear any time soon - investment from leading software houses, in the US & Europe, means that Lucee's future is assured for the foreseeable future.

### Fast ###

Performance is at the heart of what we do. Lucee has built the highest performing CFML engine available, so if you want to get more out of your servers and deliver a better experience to end-users of your sites, you owe it to yourself to try out Lucee Server.

### Quick to prototype ###

Lucee server uses CFML & CFScript - the familiar tag-based language & its scripted counterpart - meaning that you can prototype applications really quickly. Whether you're from a tag or script background, you can produce code in the way that suits you best.

And to get started, there's no need even to install Lucee Server. You can download our standalone version and be up and running in minutes.

### Robust deployment ###

Some development tools are great for development... but Lucee Server's all about stability. It's robust Java-based architecture means that you can have the confidence to deploy mission-critical applications and know they're just going to work.

### Object-oriented ###

If you're used to older versions of CFML, you'll love the new language features in Lucee Server. Lucee Server supports magic functions that automatically call getters and setters. It will now run implicit constructors, saving you from writing init methods. It supports interfaces and typing.

In short, it has everything you need to write robust OO code quickly - and it's all available in CFML & CFScript too.

### Cross-platform ###

Deploy on to a variety of local and cloud platforms - including Microsoft Windows, Linux, and Amazon Elastic Beanstalk services. Because Lucee's built with Java, you can deploy to your Java platform of choice.

### Scalable ###

You might want to start with the single machine non-installed version, but, when your application grows, we're still here for you. Lucee Server supports clustering with ease, and its robust clustering model will automatically sync data between clustered servers if a machine fails.

### Extendible ###

Lucee Server does most of what you'll need already... but if there's anything missing, you can extend it!

* Add built-in tags, functions & event gateways with CFML & CFScript
* Extend Lucee Server with Java classes & libraries
* Get extensions built by Lucee and others with our built-in extension library
* Download, modify & build Lucee Server's source
* Build admin plugins to extend the Lucee Server administrator functions

### Supported ###

### Lucee mailing list ###

Our Lucee mailing list has members from around the globe - including members of our development team - and will be happy to help you with any aspect of using Lucee Server, whether that's installation, configuration, architecting or coding. [Head over](https://dev.lucee.org/) and say hello!

### Support, training & consulting ###

There's a great community behind Lucee Server, but if your project needs more, Lucee is here to help.

We offer a range of training, support packages & consultancy services to get your project on track and keep it there. Whether you need up-front consultancy about the best way to design your project, or ongoing support for your developers, we can help.

### Open bug tracking ###

If you want to request a feature or discover a bug, you'll find our open bug tracking server [here](https://luceeserver.atlassian.net/).