# XML



# Functions

- **function-encodeforxml** - Encodes the given string for safe output in XML to reduce the risk of Cross Site Scripting attacks.
- **function-encodeforxmlattribute** - Encodes the given string for safe output in XMLAttribute to reduce the risk of Cross Site Scripting attacks.
- **function-encodeforxpath** - Encodes the given string for safe use in an XPath Query.
- **function-esapiencode** - Encodes the given string for safe output to reduce the risk of Cross Site Scripting attacks.
- **function-isxml** - Determines whether a string is well-formed XML text.
- **function-isxmlattribute** - Determines whether the function parameter is an XML Document Object Model (DOM) attribute node.
- **function-isxmldoc** - Determines whether a function parameter is an Extended Markup language (XML) document object.
- **function-isxmlelem** - Determines whether a function parameter is an Extended Markup language (XML) document object element.
- **function-isxmlnode** - Determines whether the function parameter is an XML document object node.
- **function-isxmlroot** - Determines whether a function parameter is the root element of an Extended Markup language (XML) document object.
- **function-xmlchildpos** - Gets the position of a child element within an XML document object.
- **function-xmlelemnew** - Creates an XML document object element
- **function-xmlformat** - Escapes special XML characters in a string, so that the string is safe to use with XML.
- **function-xmlgetnodetype** - Determines the type of an XML document object node.
- **function-xmlnew** - Creates an XML document object.
- **function-xmlparse** - Converts an XML document that is represented as a string variable into an XML document object.
- **function-xmlsearch** - Uses an XPath language expression to search an XML document object.
- **function-xmltransform** - Applies an Extensible Stylesheet Language Transformation (XSLT) to an XML document object that is represented as a string variable. An XSLT converts an XML document to another format or representation by applying an Extensible Stylesheet Language (XSL) stylesheet to it.
- **function-xmlvalidate** - Uses a Document Type Definition (DTD) or XML Schema to validate an XML text document or an XML document object.

# Methods

- **method-string-encodeforxml** - Encodes the given string for safe output in XML to reduce the risk of Cross Site Scripting attacks.
- **method-string-encodeforxmlattribute** - Encodes the given string for safe output in XMLAttribute to reduce the risk of Cross Site Scripting attacks.
- **method-string-encodeforxpath** - Encodes the given string for safe use in an XPath Query.
- **method-xml-childpos** - Gets the position of a child element within an XML document object. The position, in an XmlChildren array, of the Nth child that has the specified name.
- **method-xml-elemnew** - Creates an XML document object element
- **method-xml-getnodetype** - Determines the type of an XML document object node.
- **method-xml-search** - Uses an XPath language expression to search an XML document object.
- **method-xml-transform** - Applies an Extensible Stylesheet Language Transformation (XSLT) to an XML document object that is represented as a string variable. An XSLT converts an XML document to another format or representation by applying an Extensible Stylesheet Language (XSL) stylesheet to it.

# Objects

- **object-xml** - 

# Guides

- **read-xml-with-a-listener-model-sax** - Lucee not only allows you to convert an XML file to an object tree (DOM) but also supports an event-driven model (SAX).
- **xml-fast-and-easy** - This document explains how to use XML parsing in Lucee.