# Threads

- [Easy Parallelism in Lucee](https://www.rasia.io/blog/easy-parallelism-in-lucee.html)
- [Safe Concurrency with Lucee](https://www.rasia.io/blog/safe-concurrency-with-lucee.html)

# Functions

- **function-arrayeach** - call the given UDF/Closure with every value in the array.
- **function-arrayevery** - This function calls a given closure/function with every element in a given array and returns true, if all of the closure calls returns true.
- **function-arrayfilter** - This function creates a new Array that returns all the values from an array that match the given filter.
- **function-arraymap** - Calls the given closure with every element in the given array. the function returns an array that contains all values returned by the closure.
- **function-arrayreduce** - Iterates over every entry of the given array and calls the closure with every element. This function will reduce the array to a single value and will return the value.
- **function-each** - call the given UDF/Closure with every entry (key/value) in the given collection.
- **function-interruptthread** - Interrupts a specified thread by setting its interrupt status flag. This function sets the interrupt status flag on a CFThread. The behavior depends on the thread's current state: - If the thread is blocked in a ThreadJoin or sleep method call: its interrupt status will be cleared and it will receive an InterruptedException - If the thread is executing a long-running operation with interrupt checks: the operation may terminate early - If the thread is not alive: the interrupt request may have no effect
- **function-isinthread** - Determines whether the executing code is inside a cfthread or not.
- **function-listeach** - call the given UDF/Closure with every value in the string list.
- **function-listevery** - This function calls a given closure/function with every element in a given string list and returns true, if all of the closure calls returns true.
- **function-listmap** - Calls the given closure with every element in the given list. The function returns a list that contains all values returned by the closure.
- **function-listreduce** - Iterates over every entry of the given list and calls the closure with every element. This function will reduce the list to a single value and will return the value.
- **function-listsome** - This function calls a given closure/function with every element in a given string list and returns true, if one of the closure calls returns true.
- **function-logallthreads** - Creates detailed thread stack trace logs in JSONL format for performance analysis and debugging. This function captures stack traces from all running threads at specified intervals for a given duration. It executes asynchronously, returning immediately after starting the logging process, making it ideal for analyzing specific code segments by initiating logging just before the target code execution
- **function-queryeach** - call the given UDF/Closure with every row (struct) in the query.
- **function-queryevery** - This function calls a given closure/function with every element in a given query and returns true, if all of the closure calls returns true.
- **function-queryfilter** - This function creates a new Query that returns all rows from an query that match the given filter.
- **function-querymap** - Calls the given closure with every row in the query.
- **function-queryreduce** - Iterates over every row of the given query and calls the closure with that row. This function will reduce the query to a single value and will return this value.
- **function-runasync** - A function that returns a Future object, which is an eventual result of an asynchronous operation
- **function-structeach** - call the given UDF/Closure with every entry (key/value) in the struct.
- **function-structevery** - This function calls a given closure/function with every element in a given struct and returns true, if all of the closure calls returns true.
- **function-structmap** - Calls the given closure with every element in the given struct. the function returns a struct that contains all values returned by the closure.
- **function-threaddata** - returns the root cfthread scope.
- **function-threadinterrupt** - Interrupts a specified thread by setting its interrupt status flag. This function sets the interrupt status flag on a CFThread. The behavior depends on the thread's current state: - If the thread is blocked in a ThreadJoin or sleep method call: its interrupt status will be cleared and it will receive an InterruptedException - If the thread is executing a long-running operation with interrupt checks: the operation may terminate early - If the thread is not alive: the interrupt request may have no effect
- **function-threadjoin** - Makes the current thread wait until the thread or threads specified in the name attribute complete processing, or until the period specified in the timeout argument passes, before continuing processing. If you don't specify a timeout and thread you are joining to doesn't finish, the current thread also cannot finish processing
- **function-threadterminate** - Stops processing of the thread specified in the name attribute.

# Tags

- **tag-thread** - The cfthread tag enables you to create threads, independent streams of code execution, in your application.
- **tag-timeout** - Whilst similar to a [<cfthread>](../reference/tags/thread.md), code run inside the [<cftimeout>](../reference/tags/timeout.md) executes within the same scope as the current page

# Methods

- **method-array-each** - call the given UDF/Closure with every value in the array.
- **method-array-every** - This function calls a given closure/function with every element in a given array and returns true, if all of the closure calls returns true.
- **method-array-filter** - This function creates a new Array that returns all the values from an array that match the given filter.
- **method-array-map** - Calls the given closure with every element in the given array. the function returns an array that contains all values returned by the closure.
- **method-array-reduce** - Iterates over every entry of the given array and calls the closure with every element. This function will reduce the array to a single value and will return the value.
- **method-query-each** - call the given UDF/Closure with every row (struct) in the query.
- **method-query-every** - This function calls a given closure/function with every element in a given query and returns true, if all of the closure calls returns true.
- **method-query-filter** - This function creates a new Query that returns all rows from an query that match the given filter.
- **method-query-map** - Calls the given closure with every row in the given query. the function returns a query that contains all values returned by the closure.
- **method-query-reduce** - Iterates over every row of the given query and calls the closure with that row. This function will reduce the query to a single value and will return this value.
- **method-string-listeach** - call the given UDF/Closure with every value in the string list.
- **method-string-listevery** - This function calls a given closure/function with every element in a given string list and returns true, if all of the closure calls returns true.
- **method-string-listmap** - Calls the given closure with every element in the given list. The function returns a list that contains all values returned by the closure.
- **method-string-listreduce** - Iterates over every entry of the given list and calls the closure with every element. This function will reduce the list to a single value and will return the value.
- **method-string-listsome** - This function calls a given closure/function with every element in a given string list and returns true, if one of the closure calls returns true.
- **method-struct-each** - call the given UDF/Closure with every entry (key/value) in the struct.
- **method-struct-every** - This function calls a given closure/function with every element in a given struct and returns true, if all of the closure calls returns true.
- **method-struct-map** - Calls the given closure with every element in the given struct. the function returns a struct that contains all values returned by the closure.
- **method-struct-reduce** - Iterates over every entry of the given struct and calls the closure with every key/value. This function will reduce the struct to a single value and will return this value.

# Categories

- **category-iterator** - 

# Guides

- **thread-usage** - Complete guide to using threads and parallel execution in Lucee
- **function-listener** - This document explains how to use a Function Listeners in Lucee.
- **operators** - Mathematical, Logical, Ternary, Comparison, String and Elvis Operators
- **tag-syntax** - How to use tags in script
- **thread_task** - How to use Thread Tasks


# Categories

[Scopes](scopes.md)