# Structures



# Functions

- **function-arraytostruct** - Transform the array to a struct, by default, the index of the array is the key of the struct
- **function-isstruct** - Determines if the object is a structure
- **function-isvalid** - Tests whether a value meets a validation or data type rule.
- **function-len** - Determines the length of a string, array or struct
- **function-querytostruct** - Copy the query columns data to struct by using the columnKey argument
- **function-structappend** - Appends all the data from struct2 into struct2, replacing duplicate keys unless specified by the overwrite flag
- **function-structclear** - Removes all data from a structure.
- **function-structcopy** - Copies a structure. Copies top-level keys, values, and arrays in the structure by value; copies nested structures by reference.
- **function-structcount** - Counts the keys in a structure.
- **function-structdelete** - Removes an element from a structure.
- **function-structeach** - call the given UDF/Closure with every entry (key/value) in the struct.
- **function-structevery** - This function calls a given closure/function with every element in a given struct and returns true, if all of the closure calls returns true.
- **function-structfilter** - This function creates a new Struct that returns all entries from an struct that match the given filter.
- **function-structfind** - Determines the value associated with a key in a structure.
- **function-structfindkey** - Searches recursively through a substructure of nested arrays, structures, and other elements, for structures whose values match the search key in the value parameter.
- **function-structfindvalue** - Searches recursively through a substructure of nested arrays, structures, and other elements for structures with values that match the search key in the value parameter.
- **function-structget** - Gets a structure(s) from a specified path.
- **function-structinsert** - Inserts a key-value pair into a structure.
- **function-structisempty** - Determines whether a structure contains data.
- **function-structkeyarray** - Returns an array of the keys from a structure
- **function-structkeyexists** - Determines whether a specific key is present in a structure.
- **function-structkeylist** - Extracts keys from a struct.
- **function-structkeytranslate** - Converts any struct keys with dot notation into nested structures
- **function-structmap** - Calls the given closure with every element in the given struct. the function returns a struct that contains all values returned by the closure.
- **function-structnew** - Creates an empty structure.
- **function-structreduce** - Iterates over every entry of the given struct and calls the closure with every key/value. This function will reduce the struct to a single value and will return this value.
- **function-structsome** - This function calls a closure/function on every element in a struct until one returns true.
- **function-structsort** - Returns a sorted array of the top level keys in a structure. Sorts using alphabetic or numeric sorting, and can sort based on the values of any structure element.
- **function-structtosorted** - Returns a struct sorted by the top level keys in a structure. Sorts using alphabetic or numeric sorting.
- **function-structupdate** - Updates a key with a value.
- **function-structvaluearray** - Returns an Array with the values of the Struct

# Methods

- **method-array-tostruct** - Transform the array to a struct, by default, the index of the array is the key of the struct
- **method-query-tostruct** - Copy the query columns data to struct by using the columnKey argument
- **method-struct-append** - Appends all the data from struct2 into struct2, replacing duplicate keys unless specified by the overwrite flag
- **method-struct-clear** - Removes all data from a structure.
- **method-struct-copy** - Copies a structure. Copies top-level keys, values, and arrays in the structure by value; copies nested structures by reference.
- **method-struct-delete** - Removes an element from a structure.
- **method-struct-duplicate** - Returns a new duplicated version of the given object, removing all references to the old one
- **method-struct-each** - call the given UDF/Closure with every entry (key/value) in the struct.
- **method-struct-every** - This function calls a given closure/function with every element in a given struct and returns true, if all of the closure calls returns true.
- **method-struct-filter** - This function creates a new Struct that returns all entries from an struct that match the given filter.
- **method-struct-find** - Determines the value associated with a key in a structure.
- **method-struct-findkey** - Searches recursively through a substructure of nested arrays, structures, and other elements, for structures whose values match the search key in the value parameter.
- **method-struct-findvalue** - Searches recursively through a substructure of nested arrays, structures, and other elements for structures with values that match the search key in the value parameter.
- **method-struct-insert** - Inserts a key-value pair into a structure.
- **method-struct-isempty** - Determines whether a structure contains data.
- **method-struct-keyarray** - Returns an array of the keys from a structure
- **method-struct-keyexists** - Determines whether a specific key is present in a structure.
- **method-struct-keylist** - Extracts keys from a struct.
- **method-struct-keytranslate** - Converts any struct keys with dot notation into nested structures
- **method-struct-len** - Counts the keys in a structure.
- **method-struct-map** - Calls the given closure with every element in the given struct. the function returns a struct that contains all values returned by the closure.
- **method-struct-reduce** - Iterates over every entry of the given struct and calls the closure with every key/value. This function will reduce the struct to a single value and will return this value.
- **method-struct-some** - This function calls a closure/function on every element in a struct until one returns true.
- **method-struct-sort** - Returns a sorted array of the top level keys in a structure. Sorts using alphabetic or numeric sorting, and can sort based on the values of any structure element.
- **method-struct-tosorted** - Returns a struct sorted by the top level keys in a structure. Sorts using alphabetic or numeric sorting.
- **method-struct-update** - Updates a key with a value.
- **method-struct-valuearray** - Returns an Array with the values of the Struct

# Objects

- **object-struct** -