# Strings



# Functions

- **function-arraytolist** - Transform the array to a list of elements delimiter by the given string
- **function-asc** - Determines the value of a character.
- **function-chr** - Returns the character represented by the ascii value
- **function-cjustify** - Returns the given string justified to the center, padding out the words with spaces accordingly
- **function-compare** - Performs a case-sensitive comparison of two strings. -1, if string1 is less than string2 0, if string1 is equal to string2 1, if string1 is greater than string2
- **function-comparenocase** - Performs a case-insensitive comparison of two strings. An indicator of the difference: A negative number, if string1 is less than string2 0, if string1 is equal to string2 A positive number, if string1 is greater than string2
- **function-dateformat** - Formats a date string to a given output
- **function-datetimeformat** - Formats a date/time string to a given output
- **function-decimalformat** - Converts a number to a decimal-formatted string.
- **function-deserializejson** - Converts a JSON (JavaScript Object Notation) or JSON5 string data representation into CFML data, such as a struct or array.
- **function-dollarformat** - Formats a string in U.S. format.
- **function-find** - Finds the first occurrence of a substring in a string, from a specified start position. The search is case-sensitive.
- **function-findlast** - Finds the last occurrence of a substring in a string, from a specified start position. The search is case-sensitive.
- **function-findlastnocase** - Finds the last occurrence of a substring in a string, from a specified start position. If substring is not in string, returns zero. The search is case-insensitive.
- **function-findnocase** - Finds the first occurrence of a substring in a string, from a specified start position. If substring is not in string, returns zero. The search is case-insensitive.
- **function-findoneof** - Finds the first occurrence of any one of a set of characters in a string, from a specified start position. The search is case-sensitive.
- **function-gettoken** - Determines whether a token of the list in the delimiters parameter is present in a string. Returns the token found at position index of the string, as a string. If index is greater than the number of tokens in the string, returns an empty string.
- **function-htmlcodeformat** - Replaces special characters in a string with their HTML-escaped equivalents and inserts and tags at the beginning and end of the string. [version] HTML version to use. currently ignored. -1: The latest implementation of HTML 2.0: HTML 2.0 (Default) 3.2: HTML 3.2
- **function-htmleditformat** - Replaces special characters in a string with their HTML-escaped equivalents. [version] HTML version to use. currently ignored. -1: The latest implementation of HTML 2.0: HTML 2.0 (Default) 3.2: HTML 3.2 4.0: HTML 4.0
- **function-insert** - Inserts a substring in a string after a specified character position. If position = 0, prefixes the substring to the string.
- **function-isvalid** - Tests whether a value meets a validation or data type rule.
- **function-jsstringformat** - Escapes special JavaScript characters, such as single quotation mark, double quotation mark, and newline
- **function-lcase** - Converts the alphabetic characters in a string to lowercase.
- **function-left** - Returns a substring from beginning of the input string, with a length specified by the count argument.
- **function-len** - Determines the length of a string, array or struct
- **function-listappend** - Concatenates a list or element to a list.
- **function-listavg** - Calculates average from all numeric values given in the list
- **function-listchangedelims** - Changes a list delimiter. Returns a copy of the list, with each delimiter character replaced by new_delimiter.
- **function-listcompact** - Removes any empty items from the start and end of the list
- **function-listcontains** - Determines the index of the first list element that contains a specified substring. Returns the index of the first list element that contains substring. If not found, returns zero.
- **function-listcontainsnocase** - Determines the index of the first list element that contains a specified substring.
- **function-listdeleteat** - Deletes an element from a list. Returns a copy of the list, without the specified element.
- **function-listeach** - call the given UDF/Closure with every value in the string list.
- **function-listevery** - This function calls a given closure/function with every element in a given string list and returns true, if all of the closure calls returns true.
- **function-listfilter** - This function creates a new string list that returns all entries from an string list that match the given filter.
- **function-listfind** - Determines the index of the first list element in which a specified value occurs. Case-sensitive
- **function-listfindnocase** - Determines the index of the first list element in which a specified value occurs
- **function-listfirst** - Gets the first element of a list.
- **function-listgetat** - Gets a list element at a specified position.
- **function-listgetduplicates** - Gets a list of duplicate values from a list.
- **function-listindexexists** - Determines if an element at the given position exists or not
- **function-listinsertat** - Inserts an element in a list.
- **function-listitemtrim** - Removes all the white space surrounding each element, returning back the new list
- **function-listlast** - Gets the last element of a list.
- **function-listlen** - Determines the number of elements in a list.
- **function-listmap** - Calls the given closure with every element in the given list. The function returns a list that contains all values returned by the closure.
- **function-listprepend** - Inserts an element at the beginning of a list.
- **function-listqualifiedtoarray** - Copies the elements of a list to an array.
- **function-listqualify** - Inserts a string at the beginning and end of list elements.
- **function-listremoveduplicates** - Removes duplicate values from list.
- **function-listrest** - Gets a list, without its first element.
- **function-listsetat** - Replaces the contents of a list element.
- **function-listsort** - Sorts list elements according to a sort type and sort order.
- **function-listtoarray** - Copies the elements of a list to an array.
- **function-listtrim** - this function is deprecated, use instead ListCompact
- **function-listvaluecount** - Counts instances of a specified value in a list. The search is case-sensitive.
- **function-listvaluecountnocase** - Counts instances of a specified value in a list. The search is case-insensitive.
- **function-ljustify** - Left justifies characters in a string of a specified length.
- **function-lscurrencyformat** - Formats a number in a locale-specific currency format.
- **function-lsdateformat** - Formats a date string to a given output using the current sessions locale
- **function-lsdatetimeformat** - Formats a date string to a given output using the current locale
- **function-lseurocurrencyformat** - this function is just an alias for lsCurrencyFormat
- **function-lsiscurrency** - Determines whether a string is a valid representation of a currency amount in the current locale.
- **function-lsnumberformat** - Formats a number to the given format mask in the current locale
- **function-lsparsecurrency** - Converts a locale-specific currency string into a formatted number. Attempts conversion by comparing the string with each the three supported currency formats (none, local, international) and using the first that matches.
- **function-lsparseeurocurrency** - use function lsParseCurrency instead
- **function-lsparsenumber** - Converts a string that is a valid numeric representation in the current locale into a formatted number.
- **function-lstimeformat** - Formats a time string to a given output using the current locale.
- **function-ltrim** - Removes leading spaces from a string.
- **function-markdowntohtml** - Transforms Markdown formatted String into HTML.
- **function-metaphone** - Metaphone is a phonetic algorithm, an algorithm published in 1990 for indexing words by their English pronunciation. The algorithm produces variable length keys as its output, as opposed to Soundex's fixed-length keys. Similar sounding words share the same keys.
- **function-mid** - Extracts a substring from a string.
- **function-numberformat** - Creates a custom-formatted number value
- **function-paragraphformat** - Formats the carriage returns in a string to a HTML alternatives
- **function-parsedatetime** - Parses a date/time string according to the English (U.S.) locale conventions.
- **function-reescape** - Escapes regular expression control characters within a string.
- **function-refind** - Uses a regular expression (RE) to search a string for a pattern. The search is case sensitive.
- **function-refindnocase** - Uses a regular expression (RE) to search a string for a pattern, starting from a specified position. The search is case-insensitive.
- **function-rematch** - Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.
- **function-rematchnocase** - Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.
- **function-removechars** - Removes characters from a string.
- **function-repeatstring** - Creates a string that contains a specified number of repetitions of the specified string.
- **function-replace** - Replaces occurrences of substring1 in a string with substring2, in a specified scope. The search is case-sensitive.
- **function-replacelist** - Replaces occurrences of the elements from a delimited list in a string with corresponding elements from another delimited list. The search is case-sensitive.
- **function-replacelistnocase** - Replaces occurrences of the elements from a delimited list in a string with corresponding elements from another delimited list. The search is NOT case-sensitive.
- **function-replacenocase** - Replaces occurrences of substring1 with substring2, in the specified scope. The search is case-insensitive.
- **function-rereplace** - Uses a regular expression (RE) to search a string for a string pattern and replace it with another. The search is case-sensitive.
- **function-rereplacenocase** - Uses a regular expression to search a string for a string pattern and replace it with another. The search is case-insensitive.
- **function-reverse** - Reverses the order of items, such as the characters in a string, the digits in a number, or the elements in an array.
- **function-right** - Returns a substring from end of the input string, with a length specified by the count argument.
- **function-rjustify** - Right justifies characters of a string.
- **function-rtrim** - Removes spaces from the end of a string.
- **function-serializejson** - Converts CFML data into a JSON (JavaScript Object Notation) representation of the data.
- **function-soundex** - Soundex is a phonetic algorithm for indexing names by sound, as pronounced in English. The goal is for homophones to be encoded to the same representation so that they can be matched despite minor differences in spelling. The algorithm mainly encodes consonants; a vowel will not be encoded unless it is the first letter. Soundex is the most widely known of all phonetic algorithms, as it is a standard feature of MS SQL and Oracle, and is often used (incorrectly) as a synonym for &amp;quot;phonetic algorithm&amp;quot;
- **function-spanexcluding** - Gets characters from a string, from the beginning to a character that is in a specified set of characters. The search is case-sensitive.
- **function-spanincluding** - Gets characters from a string, from the beginning to a character that is not in a specified set of characters. The search is case-sensitive.
- **function-stringlen** - returns the len of a string
- **function-stripcr** - Deletes return characters from a string.
- **function-timeformat** - Formats a time string to a given output
- **function-toscript** - Creates a JavaScript expression that assigns the value of a variable to a JavaScript variable. This function can convert strings, numbers, arrays, structures, and queries to JavaScript syntax that defines equivalent variables and values.
- **function-tostring** - Converts a value to a string.
- **function-trim** - Removes leading and trailing spaces from a string.
- **function-trimwhitespace** - clean white space of the given string
- **function-ucase** - Converts the alphabetic characters in a string to uppercase.
- **function-ucfirst** - Capitalizes the first character of the given string.
- **function-urlencodedformat** - Generates a URL-encoded string. For example, it replaces spaces with %20, and non-alphanumeric characters with equivalent hexadecimal escape sequences. Passes arbitrary strings within a URL.
- **function-urlsessionformat** - Encodes the URL with the CFTOKEN/CFID/JSESSIONID
- **function-wrap** - Wraps text so that each line has a specified maximum number of characters.
- **function-xmlformat** - Escapes special XML characters in a string, so that the string is safe to use with XML.
- **function-xmltransform** - Applies an Extensible Stylesheet Language Transformation (XSLT) to an XML document object that is represented as a string variable. An XSLT converts an XML document to another format or representation by applying an Extensible Stylesheet Language (XSL) stylesheet to it.

# Methods

- **method-any-numberformat** - Creates a custom-formatted number value. For international number formatting use LSNumberFormat. [mask - quickly] _,9 Digit placeholder; . decimal point; 0 Pads with zeros; ( ) less than zero, puts parentheses around the mask + plus sign before positive number minus before negative - a space before positive minus sign before negative , Separates every third decimal place with a comma
- **method-any-tojson** - Converts CFML data into a JSON (JavaScript Object Notation) representation of the data.
- **method-array-tolist** - Transform the array to a list of elements delimiter by the given string
- **method-datetime-dateformat** - Formats a date string to a given output
- **method-datetime-datetimeformat** - Formats a date/time string to a given output
- **method-datetime-lsdateformat** - Formats a date string to a given output using the current sessions locale
- **method-datetime-lsdatetimeformat** - Formats a date string to a given output using the current locale
- **method-datetime-lstimeformat** - Formats a time string to a given output using the current locale.
- **method-datetime-timeformat** - Formats a time string to a given output
- **method-string-asc** - Determines the value of a character.
- **method-string-cjustify** - Returns the given string justified to the center, padding out the words with spaces accordingly
- **method-string-compare** - Performs a case-sensitive comparison of two strings. -1, if string1 is less than string2 0, if string1 is equal to string2 1, if string1 is greater than string2
- **method-string-comparenocase** - Performs a case-insensitive comparison of two strings. An indicator of the difference: A negative number, if string1 is less than string2 0, if string1 is equal to string2 A positive number, if string1 is greater than string2
- **method-string-decodeforhtml** - Decodes the given encoded string.
- **method-string-decodefromurl** - Decodes a string that has been encoded in the URL using the encodeForURL. this function is deprecated, use function ESAPIDecode('url',...) instead.
- **method-string-deserializejson** - Converts a JSON (JavaScript Object Notation) or JSON5 string data representation into CFML data, such as a struct or array.
- **method-string-each** - Iterates over a string and runs the closure function for each element in the string.
- **method-string-encodeforcss** - Encodes the given string for safe output in CSS to reduce the risk of Cross Site Scripting attacks.
- **method-string-encodefordn** - Encodes the given string for safe output in LDAP Distinguished Names.
- **method-string-encodeforhtml** - Encodes the given string for safe output in HTML to reduce the risk of Cross Site Scripting attacks.
- **method-string-encodeforhtmlattribute** - Encodes the given string for safe output in HTML to reduce the risk of Cross Site Scripting attacks.
- **method-string-encodeforjavascript** - Encodes the given string for safe output in JavaScript to reduce the risk of Cross Site Scripting attacks.
- **method-string-encodeforldap** - Encodes the given string for safe output in LDAP queries.
- **method-string-encodeforsql** - Encodes the given string for safe output in a query to reduce the risk of SQL Injection attacks. _This method is not recommended_ - the use of query parameters are strongly encouraged as a stronger alternative.
- **method-string-encodeforurl** - Encodes the given string for safe output in a URL.
- **method-string-encodeforxml** - Encodes the given string for safe output in XML to reduce the risk of Cross Site Scripting attacks.
- **method-string-encodeforxmlattribute** - Encodes the given string for safe output in XMLAttribute to reduce the risk of Cross Site Scripting attacks.
- **method-string-encodeforxpath** - Encodes the given string for safe use in an XPath Query.
- **method-string-encrypt** - Encrypts a string. Uses a symmetric key-based algorithm, in which the same key is used to encrypt and decrypt a string. The security of the encrypted string depends on maintaining the secrecy of the key. Uses an XOR-based algorithm that uses a pseudo-random 32-bit key, based on a seed passed by the user as a function parameter
- **method-string-every** - Determines if all elements of a string satisfy a given condition.
- **method-string-filter** - Filters a string to its elements for which the callback function returns true.
- **method-string-find** - Finds the first occurrence of a substring in a string, from a specified start position. The search is case-sensitive.
- **method-string-findlast** - Finds the last occurrence of a substring in a string, from a specified start position. The search is case-sensitive.
- **method-string-findlastnocase** - Finds the last occurrence of a substring in a string, from a specified start position. If substring is not in string, returns zero. The search is case-insensitive.
- **method-string-findnocase** - Finds the first occurrence of a substring in a string, from a specified start position. If substring is not in string, returns zero. The search is case-insensitive.
- **method-string-findoneof** - Finds the first occurrence of any one of a set of characters in a string, from a specified start position. The search is case-sensitive.
- **method-string-gettoken** - Determines whether a token of the list in the delimiters parameter is present in a string. Returns the token found at position index of the string, as a string. If index is greater than the number of tokens in the string, returns an empty string.
- **method-string-hash** - Converts a variable-length string to a 32-byte, hexadecimal string, using the MD5 algorithm. (It is not possible to convert the hash result back to the source string.) 32-byte, hexadecimal string
- **method-string-insert** - Inserts a substring in a string after a specified character position. If position = 0, prefixes the substring to the string.
- **method-string-lcase** - Converts the alphabetic characters in a string to lowercase.
- **method-string-left** - Returns a substring from beginning of the input string, with a length specified by the count argument.
- **method-string-len** - returns the len of a string
- **method-string-listappend** - Concatenates a list or element to a list.
- **method-string-listavg** - Calculates average from all numeric values given in the list
- **method-string-listchangedelims** - Changes a list delimiter. Returns a copy of the list, with each delimiter character replaced by new_delimiter.
- **method-string-listcompact** - Removes any empty items from the start and end of the list
- **method-string-listcontains** - Determines the index of the first list element that contains a specified substring. Returns the index of the first list element that contains substring. If not found, returns zero.
- **method-string-listcontainsnocase** - Determines the index of the first list element that contains a specified substring.
- **method-string-listdeleteat** - Deletes an element from a list. Returns a copy of the list, without the specified element.
- **method-string-listeach** - call the given UDF/Closure with every value in the string list.
- **method-string-listevery** - This function calls a given closure/function with every element in a given string list and returns true, if all of the closure calls returns true.
- **method-string-listfilter** - This function creates a new string list that returns all entries from an string list that match the given filter.
- **method-string-listfind** - Determines the index of the first list element in which a specified value occurs. Case-sensitive
- **method-string-listfindnocase** - Determines the index of the first list element in which a specified value occurs
- **method-string-listfirst** - Gets the first element of a list.
- **method-string-listgetat** - Gets a list element at a specified position.
- **method-string-listgetduplicates** - Gets a list of duplicate values from a list.
- **method-string-listindexexists** - Determines if an element at the given position exists or not
- **method-string-listinsertat** - Inserts an element in a list.
- **method-string-listitemtrim** - Removes all the white space surrounding each element, returning back the new list
- **method-string-listlast** - Gets the last element of a list.
- **method-string-listlen** - Determines the number of elements in a list.
- **method-string-listmap** - Calls the given closure with every element in the given list. The function returns a list that contains all values returned by the closure.
- **method-string-listprepend** - Inserts an element at the beginning of a list.
- **method-string-listqualifiedtoarray** - Copies the elements of a list to an array.
- **method-string-listqualify** - Inserts a string at the beginning and end of list elements.
- **method-string-listreduce** - Iterates over every entry of the given list and calls the closure with every element. This function will reduce the list to a single value and will return the value.
- **method-string-listremoveduplicates** - Removes duplicate values from list.
- **method-string-listrest** - Gets a list, without its first element.
- **method-string-listsetat** - Replaces the contents of a list element.
- **method-string-listsome** - This function calls a given closure/function with every element in a given string list and returns true, if one of the closure calls returns true.
- **method-string-listsort** - Sorts list elements according to a sort type and sort order.
- **method-string-listtoarray** - Copies the elements of a list to an array.
- **method-string-listvaluecount** - Counts instances of a specified value in a list. The search is case-sensitive.
- **method-string-listvaluecountnocase** - Counts instances of a specified value in a list. The search is case-insensitive.
- **method-string-ljustify** - Left justifies characters in a string of a specified length.
- **method-string-ltrim** - Removes leading spaces from a string.
- **method-string-map** - Iterates over every entry of the string and calls the closure function to work on the element of the string.
- **method-string-markdowntohtml** - Transforms Markdown formatted String into HTML.
- **method-string-mid** - Extracts a substring from a string.
- **method-string-paragraphformat** - Formats the carriage returns in a string to a HTML alternatives
- **method-string-parsedatetime** - Parses a date/time string according to the English (U.S.) locale conventions.
- **method-string-reduce** - Iterates over every element of the string and calls the closure to work on the elements of the string. This function will reduce the string to a single value and will return the value.
- **method-string-reescape** - Escapes regular expression control characters within a string.
- **method-string-refind** - Uses a regular expression (RE) to search a string for a pattern. The search is case sensitive.
- **method-string-refindnocase** - Uses a regular expression (RE) to search a string for a pattern, starting from a specified position. The search is case-insensitive.
- **method-string-rematch** - Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.
- **method-string-rematchnocase** - Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.
- **method-string-removechars** - Removes characters from a string.
- **method-string-repeatstring** - Creates a string that contains a specified number of repetitions of the specified string.
- **method-string-replace** - Replaces occurrences of substring1 in a string with substring2, in a specified scope. The search is case-sensitive.
- **method-string-replacelist** - Replaces occurrences of the elements from a delimited list in a string with corresponding elements from another delimited list. The search is case-sensitive.
- **method-string-replacelistnocase** - Replaces occurrences of the elements from a delimited list in a string with corresponding elements from another delimited list. The search is NOT case-sensitive.
- **method-string-replacenocase** - Replaces occurrences of substring1 with substring2, in the specified scope. The search is case-insensitive.
- **method-string-rereplace** - Uses a regular expression (RE) to search a string for a string pattern and replace it with another. The search is case-sensitive.
- **method-string-rereplacenocase** - Uses a regular expression to search a string for a string pattern and replace it with another. The search is case-insensitive.
- **method-string-reverse** - Reverses the order of items, such as the characters in a string, the digits in a number, or the elements in an array.
- **method-string-right** - Returns a substring from end of the input string, with a length specified by the count argument.
- **method-string-rjustify** - Right justifies characters of a string.
- **method-string-rtrim** - Removes spaces from the end of a string.
- **method-string-sanitizehtml** - Sanitizes unsafe HTML input and removes elements and attributes like JavaScript, onclick, etc. See also https://github.com/OWASP/java-html-sanitizer
- **method-string-second** - Detects and masks sensitive information (such as passwords, API keys, tokens, etc.) from a given string. The function identifies patterns commonly used for sensitive data and replaces them with a mask.
- **method-string-some** - This function calls a given closure/function with every element in a given string and returns true, if one of the closure calls returns true.
- **method-string-sort** - Returns a string containing the sorted characters from the input.
- **method-string-spanexcluding** - Gets characters from a string, from the beginning to a character that is in a specified set of characters. The search is case-sensitive.
- **method-string-spanincluding** - Gets characters from a string, from the beginning to a character that is not in a specified set of characters. The search is case-sensitive.
- **method-string-stripcr** - Deletes return characters from a string.
- **method-string-tobase64** - Calculates the Base64 representation of a string or binary object. The Base64 format uses printable characters, allowing binary data to be sent in forms and e-mail, and stored in a database or file.
- **method-string-trim** - Removes leading and trailing spaces from a string.
- **method-string-trimwhitespace** - clean white space of the given string
- **method-string-ucase** - Converts the alphabetic characters in a string to uppercase.
- **method-string-ucfirst** - Capitalizes the first character of the given string.
- **method-string-urldecode** - Decodes a URL-encoded string, converting encoded characters back to their original form. This function handles URL encoding conventions such as converting plus signs (`+`) to spaces and percent-encoded sequences (`%xx`) to their corresponding characters. The function throws an exception when encountering malformed URL encodings (such as incomplete or invalid percent sequences like `%G`)
- **method-string-urlencode** - Encodes a string to be URL-safe according to the application/x-www-form-urlencoded MIME format
- **method-string-urlencodedformat** - Generates a URL-encoded string. For example, it replaces spaces with %20, and non-alphanumeric characters with equivalent hexadecimal escape sequences. Passes arbitrary strings within a URL.
- **method-string-wrap** - Wraps text so that each line has a specified maximum number of characters.
- **method-xml-transform** - Applies an Extensible Stylesheet Language Transformation (XSLT) to an XML document object that is represented as a string variable. An XSLT converts an XML document to another format or representation by applying an Extensible Stylesheet Language (XSL) stylesheet to it.

# Objects

- **object-string** -