# Lucee Server related Tags, Functions and Guides



# Functions

- **function-applicationpathcacheclear** - flush the application.[cfc|cfm] path cache
- **function-bundleinfo** - if the given object is loaded by an OSGi bundle, this function is returning information about that bundle
- **function-componentcacheclear** - flush the component path cache
- **function-configimport** - Imports configuration using the &amp;quot;CFConfig.json&amp;quot; format.
- **function-configtranslate** - translate an old Lucee XML configuration to the new CFConfig.json configuration
- **function-ctcacheclear** - flush the custom tag path cache
- **function-ctcachelist** - list elements in the custom tag path cache
- **function-dbpoolclear** - clears all existing datasource connection
- **function-ec2describeinstances** - This function interfaces with the EC2 service to retrieve detailed information about specified EC2 instances. It supports custom filtering, specific instance IDs, regional targeting, and legacy mode handling.
- **function-extensionexists** - Checks if a certain extension exists or not.
- **function-extensionlist** - Checks if a certain extension exists or not.
- **function-getbuiltinfunction** - return a build in function as an object, matching the given name, throws an exception when the function does not exist.
- **function-getclasspath** - returns an array containing the Java classpath of the current environment.
- **function-getcontextinfo** - Returns information about the current context.
- **function-getcontextroot** - Returns path to the J2EE server context root for the current request.
- **function-getcpuusage** - returns the CPU usage for a defined time range (default: 1000ms).
- **function-getfreespace** - Returns the number of unallocated bytes in the partition named by this abstract path name.
- **function-getfunctioncalledname** - Returns the name of variable used to call the current function
- **function-getfunctiondata** - Returns information about a built in function (BIF)
- **function-getfunctionkeywords** - returns all keywords defined with all functions
- **function-getfunctionlist** - Returns all the currently registered functions
- **function-getlocalhostip** - Returns the localhost IP address, which is 127.0.0.1 for IPv4 and ::1 for IPv6 addresses.
- **function-getmemoryusage** - Returns detailed information to the memory usage of the container.
- **function-getmetricdata** - Gets server performance metrics.
- **function-getpagecontext** - Gets the current PageContext object that provides access to page attributes and configuration, request and response objects.
- **function-getsystemfreememory** - The amount of memory that is currently free, in bytes.
- **function-getsystemproporenvvar** - Return the list of supported system properties or env vars Lucee supports.
- **function-getsystemtotalmemory** - The amount of memory that is available to the operating system, in bytes.
- **function-gettagdata** - Returns Information about a Tag as Struct
- **function-gettaglist** - Returns a struct containing all the Tags supported by Lucee.
- **function-gettotalspace** - Returns the size of the partition named by this abstract pathname.
- **function-getvfsmetadata** - Returns metadata about the Virtual File system (VFS)
- **function-inspecttemplates** - Flag all the cfml code (cfm, cfcs) in the cache of compiled code (aka the Page Pool) to be checked once for any changes.
- **function-internalrequest** - Makes a request to the CFML Engine internally.
- **function-isinthread** - Determines whether the executing code is inside a cfthread or not.
- **function-logallthreads** - Creates detailed thread stack trace logs in JSONL format for performance analysis and debugging. This function captures stack traces from all running threads at specified intervals for a given duration. It executes asynchronously, returning immediately after starting the logging process, making it ideal for analyzing specific code segments by initiating logging just before the target code execution
- **function-maveninfo** - Retrieves information about a Maven artifact and its dependencies. This function allows you to query details about a specific Maven artifact by providing its coordinates (groupId, artifactId, and optionally version). It returns a query containing information about the artifact itself and all of its dependencies based on the specified scope
- **function-pagepoolclear** - Clear out all the cfml code (cfm, cfcs) in the cache of compiled code (aka the Page Pool)
- **function-pagepoollist** - Lists all the cfml code (cfm, cfcs) in the cache of compiled code (aka the Page Pool)
- **function-restinitapplication** - Registers the directory path with the service mapping provided.
- **function-secretproviderget** - Returns a reference to a secret value stored in a configured Secret Provider. The function doesn't immediately return the actual value, but rather a value object that can be handled by Lucee like a simple value. This reference is automatically resolved to its actual value when: - It's converted to a real simple value (string, boolean, number, date) - It's used in operations requiring a simple value When used, the function automatically validates that the secret exists and throws an exception if not found
- **function-sslcertificateinstall** - install certificates of a specific host
- **function-sslcertificatelist** - Returns a list of SSL certificates. If a host is specified, it lists the certificates available for that specific host. If no host is specified, it lists all certificates stored in the KeyStore.
- **function-systemcacheclear** - clears all caches or the specified cache

# Tags

- **tag-lock** - Provides two types of locks to ensure the integrity of shared data: Exclusive lock and Read-only lock.
- **tag-objectcache** - Flushes an object cache or returns the current size.
- **tag-processingdirective** - Sets compiler directives that affect the entire template. Unlike most CFML tags, cfprocessingdirective is processed at compile time and must be placed at the root level of your template.
- **tag-registry** - Reads, writes, and deletes keys and values in the system registry. The cfregistry tag is supported on all platforms, including Linux, Solaris, and HP-UX.
- **tag-setting** - Controls various aspects of page processing, such as the output of HTML code in pages. One benefit of this option is managing whitespace that can occur in output pages served by CFML.

# Guides

- **archives-creating-and-deploy** - This document explains how to deploy an Application on a live server without using a single CFML file.
- **cookbook-check-for-changes** - Automatically check for changes in your configuration file with Lucee.
- **cfadmin-docs** - Since several people asked us to document the CFAdmin tag, we are publishing it here already so that you can have a look at all the actions and attributes as well as the examples available. General information The tag is used for all changes one wants to do in the Lucee configuration. Depending on what value for the attribute type you pass (web|server) either the local web configuration is changed or the global server one
- **mappings-component-mappings** - How to define and use component mappings in Lucee.
- **config** - Best practices for configuring Lucee in various environments.
- **config-lucee5** - Best practices for configuring Lucee 5 environments.
- **configuration-web-xml** - How to configure Tomcat's web.xml for Lucee
- **cookbook-configuration-administrator-cfc** - How to configure Lucee within your application using Administrator.cfc and cfadmin tag.
- **configuring-regional-settings** - Lucee by default, uses the JVM's default timezone, which comes from the operating system.
- **console-logging** - Use the console for debugging
- **mappings-custom-tag-mappings** - How to define and use custom tag mappings in Lucee.
- **datasource-how-to-define-them** - How to define a Datasource in Lucee.
- **mappings-how-to-define-a-reg-mapping** - All about the different mappings in Lucee and how to use them.
- **deploying-lucee-server-apps** - [Lucee Security Best Practices](../guides/deploying-lucee-server-apps/securing-lucee-server-apps.md) [Lockdown Guide](../guides/deploying-lucee-server-apps/lockdown-guide.md) [Locking Down Tomcat](../guides/deploying-lucee-server-apps/locking-down-your-lucee-stack.md) The deploy folder There is a `/deploy` folder under the `/lucee-server/` folder which can be used to customize Lucee . The `/deploy` folder is polled on startup and every 60 seconds by Lucee's Controller thread. It looks for `
- **configuration-directory-placeholders** - Placeholders are uses to reference specific Lucee directories
- **Docker** - Guide on using and running Lucee with Docker
- **running-lucee-download-and-install** -  Download and Install Lucee Server Lucee can be installed and run almost everywhere that is capable of running a [supported Java Version](/guides/installing-lucee/download-and-install.html supportedJavaVersions). You can even run Lucee on a small RaspberryPI. Because of its great flexibility, Lucee Server comes in different flavors to match your needs (Lucee Installer, Docker, Lucee Express, CommandBox, or manually deploying Lucee
- **environment-variables-system-properties** - This document gives you an overview over all Environment Variables and System Properties supported by Lucee.
- **Externalizing_Strings** - Externalize strings from generated class files to separate files. This method is used to reduce the memory of the static contents for templates.
- **file-extensions** - Learn about the different file extensions supported by Lucee, including .cfm, .cfc, .cfml, and .cfs. This guide provides examples for each type of file.
- **full-list-environment-variables-system-properties** -  Environment Variables / System Properties for Lucee This is an automatically generated list of Environment Variables and System Properties you can set for the Lucee Server, extracted directly from Lucee, see [GetSystemPropOrEnvVar()](../reference/functions/getsystemproporenvvar.md) There is also [Environment Variables / System Properties for Lucee](../recipes/environment-variables-system-properties.md) Each sub-heading is the name of the Environment Variable (EnvVar), the equivalent Java System Property (SysProp) is identical, simply in lower case, with underscores replaced by dots
- **local-scope-migration** - Guide for safely migrating your Lucee application from classic to modern local scope mode
- **locking-down-lucee-server** - Security best practises to lock down your Lucee server
- **locking-down-your-lucee-stack** - Restricting Access to Tomcat's Web Server
- **logging** - How to configure and customize logging
- **monitoring-debugging** - Learn about the changes in Lucee 6.1 regarding Monitoring and Debugging. Understand the old and new behavior, and how to configure the settings in Lucee Admin and Application.cfc.
- **onbuild-function** - The onBuild function in Server.cfc is used for tasks during the build phase in Lucee, particularly useful in Docker environments.
- **precompiled-code** - How to pre-compile code for a production server while the source code is deployed to avoid compilation on the production server for security reasons.
- **recommended-settings** - A guide on how to configure your Lucee Server for the best performance and highest security.
- **request-timeout** - Learn how to use request timeout correctly with Lucee.
- **cfschedule-bulk** - How to update scheduled tasks in a single operation
- **secret-management** - Managing Secrets in Lucee applications
- **relocating-web-inf** - By default, Lucee places its web-context configuration and data files in a folder named WEB-INF within the web root of each website.
- **session-handling** - Comprehensive guide on session handling and configuration in Lucee, including session types, storage options, and security considerations.
- **running-lucee-system-properties** - How to set and use Environment Variables or System Properties to configure specific Lucee Server settings.
- **single-vs-multi-mode** - Understanding the differences between Single mode and Multi mode in Lucee.
- **linux-starting-and-stopping-lucee** - In a Linux environment, Lucee can be controlled by using the provided [lucee_ctl](https://github.com/lucee/lucee-installer/blob/master/lucee/linux/sys/engine_ctl_template) script, which is configured by the installer according to your choices. During a standard install, it is possible for two (2) copies of this file to be created
- **windows-start-stop-lucee** - If you run the Lucee installer, it will create a Windows Service and also enable optional control panels based on Apache Tomcat which is implemented by the Lucee installer. There are then a couple different methods to start or stop the Lucee/Tomcat service on a Windows machine. We'll go over these items here. While the Tomcat implementation underlying Lucee also offers other ways to start and stop Lucee from the command line (via the lucee\tomcat\bin folder), this documentation is not referring to that
- **startup-listeners-code** - Lucee supports two types of Startup Listeners: Server.cfc and Web.cfc.
- **supercharge-your-website** - This document explains how you can improve the performance of your website in a very short time with Lucee.
- **systemoutput-recipe** - This document explains the systemoutput function with some simple examples.
- **webserver-cache** -  Performance / Caching The settings you make here determine how Lucee deals with changed CFM files. Normally Lucee will compile any modified file into a new Java class file. While this is very fast (depending on the complexity and size of the file to this might take around 10ms), however, each , , CFC invocation, CustomTags call, etc
- **troubleshooting** - A guide to diagnosing problems with Lucee
- **windows-update-memory-settings** -  Lucee 6.2 The Lucee Installer since Lucee 6.2, doesn't set memory default, which the allows the JVM to automatically size the memory, the default is usually 50% of available memory. [LDEV-5332](https://luceeserver.atlassian.net/browse/LDEV-5332) Windows As your site grows and your memory needs increase, you will inevitably need to adjust the memory settings for the Lucee Server JVM from it's default setting of 256MB of RAM
- **using-s3-directly-for-source-code** - Using S3 directly for source code
- **virtual-file-system** - Lucee supports the following virtual file systems: ram, file, s3, http, https, zip, and tar.