# S3 

Lucee S3 Extension Source Code <https://github.com/lucee/extension-s3>

The s3* functions listed below are optimised for use with S3, while you can use the file* functions, these S3 specific functions will perform better and may expose additional S3 specific functionality.

Open Issues: [https://luceeserver.atlassian.net](https://luceeserver.atlassian.net/issues/?jql=labels%20%3D%20%22s3%22)

[Video: S3 for source code](https://www.youtube.com/watch?v=twQomRCbaCY)

# Functions

- **function-ec2describeinstances** - This function interfaces with the EC2 service to retrieve detailed information about specified EC2 instances. It supports custom filtering, specific instance IDs, regional targeting, and legacy mode handling.
- **function-getvfsmetadata** - Returns metadata about the Virtual File system (VFS)
- **function-s3clearbucket** - Removes all objects from a bucket, unless maxage is set, in that case only objects that are older than maxage are removed.
- **function-s3copy** - Copies an object in S3 from one bucket to an other.
- **function-s3createbucket** - Creates a bucket on S3.
- **function-s3download** - Downloads an object from an S3 bucket. It can save the object to a specified path, return its content directly, or process the content in parts through a provided closure or UDF (User-Defined Function).
- **function-s3exists** - Checks if given object exists in
- **function-s3generatepresignedurl** - Generates a presigned URL pointing to the object given. You can provide the endpoint as a bucket/object definition (S3AddACL(bucket:&amp;quot;mybucket&amp;quot;,object:&amp;quot;myobject.txt&amp;quot;) ) or as a virtual filesystem path (S3AddACL(path:&amp;quot;s3://mybucket/myobject.txt&amp;quot;) ).
- **function-s3getversioninfo** - Returns version information as a query for a specific object or bucket.
- **function-s3listbucket** - List all objects in a bucket
- **function-s3move** - Moves an object in S3 from one bucket to an other.
- **function-s3read** - Reads an object from S3 as a string.
- **function-s3readbinary** - Reads an object from S3 as a binary.
- **function-s3upload** - Uploads a file to S3.
- **function-s3write** - Writes a value to S3.
- **function-storeaddacl** - Adds ACL to existing ACL for object or bucket. This function operates identically to &amp;quot;S3AddACL&amp;quot;, making it deprecated. The updated function offers greater flexibility in defining the endpoint.
- **function-storegetacl** - Returns an array of structures, with each structure representing an ACL (Access Control List) grant. This function operates identically to &amp;quot;S3GetACL&amp;quot;, making it deprecated. The updated function offers greater flexibility in defining the endpoint.
- **function-storegetmetadata** - Returns the metadata related to the object or bucket. This function operates identically to &amp;quot;S3GetMetaData&amp;quot;, making it deprecated. The updated function offers greater flexibility in defining the endpoint.
- **function-storesetacl** - Sets the ACL for object or bucket. This function operates identically to &amp;quot;S3SetACL&amp;quot;, making it deprecated. The updated function offers greater flexibility in defining the endpoint.
- **function-storesetmetadata** - Sets the metadata on bucket or object. This function operates identically to &amp;quot;S3SetMetaData&amp;quot;, making it deprecated. The updated function offers greater flexibility in defining the endpoint.

# Categories

- **category-files** - Provides access to File System Resources, this includes virtual file systems like ram, s3, git, ftp and ssh

# Guides

- **s3-regions** - Guide on configuring and interacting with specific S3 regions in Lucee using the S3 extension.
- **using-s3-directly-for-source-code** - Using S3 directly for source code
- **virtual-file-system** - Lucee supports the following virtual file systems: ram, file, s3, http, https, zip, and tar.


# Categories

[File handling](files.md)

# See Also

[Virtual File Systems](../recipes/virtual-file-system.md)