# Regex

By default, Lucee uses the older [Oro](https://jakarta.apache.org/oro/demo.html) Regex Engine, which is compatible with ACF.

Since [5.3.8.79](https://luceeserver.atlassian.net/browse/LDEV-2892), Lucee also supports using the more modern, compatible engine built into java.

You can switch engines using the following options in your [Application.cfc / <cfapplication>](../reference/tags/application.md)

```
this.regex.engine = "java";  // default is "perl"
// or
this.useJavaAsRegexEngine = true;
```

To switch between Regex engines on the fly (`<cfapplication>` only affects the current thread / request )

```
<!--- do perl regex stuff --->
<cfapplication action=“update” regex=“java”>
<!--- do modern java regex stuff --->
<cfapplication action=“update” regex=“perl”>
<!--- back to cperl  regex stuff --->
```

# Functions

- **function-isvalid** - Tests whether a value meets a validation or data type rule.
- **function-reescape** - Escapes regular expression control characters within a string.
- **function-refind** - Uses a regular expression (RE) to search a string for a pattern. The search is case sensitive.
- **function-refindnocase** - Uses a regular expression (RE) to search a string for a pattern, starting from a specified position. The search is case-insensitive.
- **function-rematch** - Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.
- **function-rematchnocase** - Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.
- **function-rereplace** - Uses a regular expression (RE) to search a string for a string pattern and replace it with another. The search is case-sensitive.
- **function-rereplacenocase** - Uses a regular expression to search a string for a string pattern and replace it with another. The search is case-insensitive.

# Methods

- **method-string-reescape** - Escapes regular expression control characters within a string.
- **method-string-refind** - Uses a regular expression (RE) to search a string for a pattern. The search is case sensitive.
- **method-string-refindnocase** - Uses a regular expression (RE) to search a string for a pattern, starting from a specified position. The search is case-insensitive.
- **method-string-rematch** - Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.
- **method-string-rematchnocase** - Uses a regular expression (RE) to search a string for a pattern, starting from a specified position.
- **method-string-rereplace** - Uses a regular expression (RE) to search a string for a string pattern and replace it with another. The search is case-sensitive.
- **method-string-rereplacenocase** - Uses a regular expression to search a string for a string pattern and replace it with another. The search is case-insensitive.