# Queries



# Functions

- **function-dbpoolclear** - clears all existing datasource connection
- **function-encodeforsql** - Encodes the given string for safe output in a query to reduce the risk of SQL Injection attacks. _This method is not recommended_ - the use of query parameters are strongly encouraged as a stronger alternative.
- **function-getmetadata** - Returns back meta information depending on the object passed in
- **function-isquery** - Determines whether value is a query.
- **function-isvalid** - Tests whether a value meets a validation or data type rule.
- **function-iswithintransaction** - Determines whether the current thread is within a transaction block or not.
- **function-query** - Create and populate a query object in the form query(columnName1:[1,2,3],columnName2:[4,5,6])
- **function-queryaddcolumn** - Adds a column to a query and populates its rows with the contents of a one-dimensional array. Pads query columns, if necessary, to ensure that all columns have the same number of rows.
- **function-queryaddrow** - Adds rows to a query, either empty row(s) or you can add a row with data
- **function-queryappend** - Adds all values of one query to the end of another query. Both queries need to have the same columns.
- **function-queryclear** - Clears all rows from a query
- **function-queryclose** - When using lazy=&amp;quot;true&amp;quot;, it is important to close the resultSet during a request or it will continue to use heap memory.
- **function-querycolumnarray** - return the column names as array
- **function-querycolumncount** - column count of given query
- **function-querycolumndata** - Returns all the data in a query for a given column
- **function-querycolumnexists** - Determines whether a specific column is present in a query.
- **function-querycolumnlist** - return the column names as list
- **function-queryconvertforgrid** - Use instead the function QuerySlice.
- **function-querycurrentrow** - return the row where the pointer of the query is pointing ATM
- **function-querydeletecolumn** - removes a row from a query and return removed row as array
- **function-querydeleterow** - Deletes the row within a query object. Modifies the original query object
- **function-queryeach** - call the given UDF/Closure with every row (struct) in the query.
- **function-queryevery** - This function calls a given closure/function with every element in a given query and returns true, if all of the closure calls returns true.
- **function-queryexecute** - Executes a SQL query, returns the result.
- **function-queryfilter** - This function creates a new Query that returns all rows from an query that match the given filter.
- **function-querygetcell** - return the value of a specific query cell
- **function-querygetcellbyindex** - return the value of a specific query cell
- **function-querygetrow** - this function is deprecated, use function QueryRowData instead.
- **function-queryinsertat** - Adds data (query,struct or array) into query.
- **function-queryisempty** - returns query empty or not
- **function-querykeyexists** - Determines whether a specific column is present in a query.
- **function-querylazy** - Executes a SQL query without loading the data entirely to memory. Instead it calls the given Function with every single row
- **function-querymap** - Calls the given closure with every row in the query.
- **function-querynew** - Creates an empty query (query object).
- **function-queryprepend** - Adds all values of one query the begin to another query. Both queries need to have the same columns.
- **function-queryrecordcount** - row count of given query
- **function-queryreduce** - Iterates over every row of the given query and calls the closure with that row. This function will reduce the query to a single value and will return this value.
- **function-queryrenamecolumn** - Rename a column
- **function-queryreverse** - reverse the row order of a complete query
- **function-queryrowbyindex** - 
- **function-queryrowdata** - Returns a struct with the data from a query for a given row number
- **function-queryrowdatabyindex** - 
- **function-queryrowswap** - swaps one row of a query with an other.
- **function-querysetcell** - Sets a cell to a value. If no row number is specified, the cell on the last row is set.
- **function-querysetrow** - Adds a row to a query, either by struct or array
- **function-queryslice** - creates a new query containing a part of the given query
- **function-querysome** - This function calls a given closure/function with every element in a given query and returns true, if one of the closure calls returns true.
- **function-querysort** - Sorts the query based on the column specified and the order criteria given. Modifies the original query object
- **function-querytostruct** - Copy the query columns data to struct by using the columnKey argument
- **function-transactioncommit** - commits a pending transaction
- **function-transactionrollback** - rolls back a pending transaction
- **function-transactionsetsavepoint** - Saves a specific state within a transaction
- **function-valuearray** - Returns an array of all the values, for a given column within the query. this function is deprecated, use instead the function queryColumnData
- **function-valuelist** - Returns a list of all the values, for a given column within the query, delimited by the value given. this function is deprecated, use instead the function queryColumnData

# Tags

- **tag-insert** - Inserts records in data sources.
- **tag-procparam** - Specifies parameter information, including type, name, value, and length. The cfprocparam tag is nested within a cfstoredproc tag.
- **tag-query** - Passes SQL statements to a data source. Not limited to queries.
- **tag-queryparam** - Checks the data type of a query parameter.
- **tag-storedproc** - Executes stored procedures by an ODBC or native connection to a server database. It specifies database connection information and identifies the stored procedure.
- **tag-transaction** - Groups multiple queries into a single unit. The cftransaction tag provides commit and rollback processing.

# Methods

- **method-query-addcolumn** - Adds a column to a query and populates its rows with the contents of a one-dimensional array. Pads query columns, if necessary, to ensure that all columns have the same number of rows.
- **method-query-addrow** - Adds a specified number of empty rows to a query.
- **method-query-append** - Adds all values of one query to the end of another query. Both queries need to have the same columns.
- **method-query-clear** - Clears all rows from a query
- **method-query-columnarray** - return the column names as array
- **method-query-columncount** - column count of given query
- **method-query-columndata** - Returns all the data in a query for a given column
- **method-query-columnexists** - Determines whether a specific column is present in a query.
- **method-query-columnlist** - return the column names as list
- **method-query-currentrow** - return the row where the pointer of the query is pointing ATM
- **method-query-deletecolumn** - removes a row from a query and return removed row as array
- **method-query-deleterow** - Deletes the row within a query object. Modifies the original query object
- **method-query-each** - call the given UDF/Closure with every row (struct) in the query.
- **method-query-every** - This function calls a given closure/function with every element in a given query and returns true, if all of the closure calls returns true.
- **method-query-filter** - This function creates a new Query that returns all rows from an query that match the given filter.
- **method-query-getcell** - return the value of a specific query cell
- **method-query-getcellbyindex** - return the value of a specific query cell
- **method-query-getrow** - this function is deprecated, use function QueryRowData instead.
- **method-query-insertat** - Adds data (query,struct or array) into query.
- **method-query-isempty** - returns query empty or not
- **method-query-keyexists** - Determines whether a specific column is present in a query.
- **method-query-map** - Calls the given closure with every row in the given query. the function returns a query that contains all values returned by the closure.
- **method-query-prepend** - Adds all values of one query the begin to another query. Both queries need to have the same columns.
- **method-query-recordcount** - row count of given query
- **method-query-reduce** - Iterates over every row of the given query and calls the closure with that row. This function will reduce the query to a single value and will return this value.
- **method-query-renamecolumn** - Rename a column
- **method-query-reverse** - reverse the row order of a complete query
- **method-query-rowbyindex** - 
- **method-query-rowdata** - Returns a struct with the data from a query for a given row number
- **method-query-rowdatabyindex** - 
- **method-query-rowswap** - swaps one row of a query with an other.
- **method-query-setcell** - Sets a cell to a value. If no row number is specified, the cell on the last row is set.
- **method-query-setrow** - Adds a row to a query, either by struct or array
- **method-query-slice** - creates a new query containing a part of the given query
- **method-query-some** - This function calls a given closure/function with every element in a given query and returns true, if one of the closure calls returns true.
- **method-query-sort** - Sorts the query based on the column specified and the order criteria given. Modifies the original query object
- **method-query-tostruct** - Copy the query columns data to struct by using the columnKey argument
- **method-string-encodeforsql** - Encodes the given string for safe output in a query to reduce the risk of SQL Injection attacks. _This method is not recommended_ - the use of query parameters are strongly encouraged as a stronger alternative.

# Objects

- **object-query** - 

# Categories

- **category-orm** - Ortus have forked the original Lucee ORM extension and are actively maintaining it. [Ortus Lucee ORM Extension](https://www.ortussolutions.com/products/orm-extension) [Ortus ORM Extension on Forgebox](https://www.forgebox.io/view/D062D72F-F8A2-46F0-8CBC91325B2F067B) The Lucee ORM extension is no longer maintained, anyone still using the Lucee version is advised to migrate

# Guides

- **cache-a-query-for-the-curr-context** - Cache a Query for the current request in Lucee.
- **datasource-how-to-define-them** - How to define a Datasource in Lucee.
- **get-datasource-drivers-from-maven** - Learn how to get datasource drivers directly from Maven.
- **lazy_queries** - How to use lazy queries
- **query-async** - Learn how to execute queries asynchronously in Lucee. This guide demonstrates how to set up asynchronous query execution using a simple flag. Examples include defining async execution for queries and using local listeners to handle exceptions. Additionally, function listeners introduced in Lucee 6.1 can be used for this purpose
- **query-execution-recipe** - Complete guide to executing database queries in Lucee with performance comparisons and best practices
- **query-indexes** - Learn how to set and use indexes for query results in Lucee. This guide demonstrates how to define a query with an index and access parts of the query using the index.
- **query-listeners** - Learn how to define query listeners in Lucee. This guide demonstrates how to set up global query listeners in the Application.cfc file to listen to or manipulate every query executed. Examples include defining listeners directly in Application.cfc and using a component as a query listener.
- **query-of-queries** - Query of queries (QoQ) is a technique for re-querying an existing (in memory) query without another trip to the database.
- **query-of-query-sometime** - This document explains why Query of Queries (QoQ) may or may not be the best approach for your use case.
- **query-result-threshold** - Monitor and log database queries that return large result sets to prevent OutOfMemory errors
- **query-return-type** - This document explains the different return types for a query with some examples.
- **sql-types** - SQL types for query parameters


# Categories

[ORM](orm.md)