# Parsing



# Functions

- **function-canonicalize** - Canonicalization is simply the operation of reducing a possibly encoded string down to its simplest form. This is important, because attackers frequently use encoding to change their input in a way that will bypass validation filters, but still be interpreted properly by the target of the attack. Note that data encoded more than once is not something that a normal user would generate and should be regarded as an attack
- **function-deserializejson** - Converts a JSON (JavaScript Object Notation) or JSON5 string data representation into CFML data, such as a struct or array.
- **function-htmlparse** - parse the given html (not only xhtml) as xml Object, work similar to xmlParse, but this function is very forgiving with the syntax..
- **function-lsparsecurrency** - Converts a locale-specific currency string into a formatted number. Attempts conversion by comparing the string with each the three supported currency formats (none, local, international) and using the first that matches.
- **function-lsparsedatetime** - Converts a string that is a valid date/time representation in the current locale into a date/time object.
- **function-lsparseeurocurrency** - use function lsParseCurrency instead
- **function-lsparsenumber** - Converts a string that is a valid numeric representation in the current locale into a formatted number.
- **function-parsedatetime** - Parses a date/time string according to the English (U.S.) locale conventions.
- **function-parsenumber** - Parses the string argument as a numeric value.
- **function-val** - Converts numeric characters that occur at the beginning of a string to an number.
- **function-xmlparse** - Converts an XML document that is represented as a string variable into an XML document object.

# Methods

- **method-string-deserializejson** - Converts a JSON (JavaScript Object Notation) or JSON5 string data representation into CFML data, such as a struct or array.
- **method-string-parsedatetime** - Parses a date/time string according to the English (U.S.) locale conventions.