# Numbers



# Functions

- **function-abs** - Absolute-value function. The absolute value of a number is the number without its sign.
- **function-acos** - Returns the angle whose cosine is the value passed as the argument.
- **function-asin** - Determines the arcSine of a number. The arcSine is the angle whose sine is number.
- **function-atn** - ArcTangent function. The arcTangent is the angle whose tangent is number.
- **function-bitand** - Performs a bitwise logical AND operation.
- **function-bitmaskclear** - Performs a bitwise mask clear operation.
- **function-bitmaskread** - Performs a bitwise mask read operation.
- **function-bitmaskset** - Performs a bitwise mask set operation.
- **function-bitnot** - Performs a bitwise logical NOT operation.
- **function-bitor** - Performs a bitwise logical OR operation.
- **function-bitshln** - Performs a bitwise shift-left, no-rotation operation.
- **function-bitshrn** - Performs a bitwise shift-right, no-rotation operation.
- **function-bitxor** - Performs a bitwise logical XOR operation.
- **function-ceiling** - Determines the closest integer that is greater than a specified number.
- **function-cos** - Calculates the cosine of an angle that is entered in radians. A number; the cosine of the angle.
- **function-decimalformat** - Converts a number to a decimal-formatted string.
- **function-exp** - Calculates the exponent whose base is e that represents number.
- **function-fix** - Converts a real number to an integer.
- **function-floor** - Calculates the closest integer that is smaller than number.
- **function-formatbasen** - String Converts number to a string, in the base specified by radix. For example: FormatBaseN(1024,16) 
- **function-inputbasen** - Converts string, using the base specified by radix, to an integer. For example: InputBaseN(&amp;quot;3ff&amp;quot;,16) 
- **function-int** - Calculates the closest integer that is smaller than number.
- **function-isnumeric** - Determines if the object represents a numeric
- **function-isnumericdate** - Evaluates whether a real number is a valid representation of a date (date/time object).
- **function-log** - Calculates the natural logarithm of a number. Natural logarithms are based on the constant e (2.71828182845904).
- **function-log10** - Calculates the logarithm of number, to base 10.
- **function-lsisnumeric** - Determines whether a string is a valid representation of a number in the current locale.
- **function-lsnumberformat** - Formats a number to the given format mask in the current locale
- **function-lsparsenumber** - Converts a string that is a valid numeric representation in the current locale into a formatted number.
- **function-max** - Determines the greater of two numbers.
- **function-min** - Determines the lesser of two numbers.
- **function-numberformat** - Creates a custom-formatted number value
- **function-parsenumber** - Parses the string argument as a numeric value.
- **function-pi** - Gets the mathematical constant p, accurate to 15 digits. The number 3.14159265358979.
- **function-precisionevaluate** - Evaluates one or more string expressions.
- **function-rand** - Generates a pseudo-random number in the range 0 - 1.
- **function-randomize** - Seeds the pseudo-random number generator with an integer number, ensuring repeatable number patterns.
- **function-randrange** - Generates a random integer between two specified numbers.
- **function-round** - Rounds a number to the closest integer.
- **function-sgn** - Determines the sign of a number.
- **function-sin** - Calculates the sine of an angle that is entered in radians.
- **function-sqr** - Calculates the square root of a number.
- **function-tan** - Calculates the tangent of an angle that is entered in radians.
- **function-tonumeric** - Converts given value to a number
- **function-val** - Converts numeric characters that occur at the beginning of a string to an number.

# Methods

- **method-any-numberformat** - Creates a custom-formatted number value. For international number formatting use LSNumberFormat. [mask - quickly] _,9 Digit placeholder; . decimal point; 0 Pads with zeros; ( ) less than zero, puts parentheses around the mask + plus sign before positive number minus before negative - a space before positive minus sign before negative , Separates every third decimal place with a comma
- **method-numeric-abs** - Absolute-value function. The absolute value of a number is the number without its sign.
- **method-numeric-acos** - Returns the angle whose cosine is the value passed as the argument.
- **method-numeric-asin** - Determines the arcSine of a number. The arcSine is the angle whose sine is number.
- **method-numeric-atn** - ArcTangent function. The arcTangent is the angle whose tangent is number.
- **method-numeric-bitand** - Performs a bitwise logical AND operation.
- **method-numeric-bitmaskclear** - Performs a bitwise mask clear operation.
- **method-numeric-bitmaskread** - Performs a bitwise mask read operation. Returns an integer, created from length bits of number, beginning at start.
- **method-numeric-bitmaskset** - Performs a bitwise mask set operation.
- **method-numeric-bitnot** - Performs a bitwise logical NOT operation.
- **method-numeric-bitor** - Performs a bitwise logical OR operation.
- **method-numeric-bitshln** - Performs a bitwise shift-left, no-rotation operation.
- **method-numeric-bitshrn** - Performs a bitwise shift-right, no-rotation operation.
- **method-numeric-bitxor** - Performs a bitwise logical XOR operation.
- **method-numeric-ceiling** - Determines the closest integer that is greater than a specified number.
- **method-numeric-cos** - Calculates the cosine of an angle that is entered in radians. A number; the cosine of the angle.
- **method-numeric-exp** - Calculates the exponent whose base is e that represents number. The constant e equals 2.71828182845904, the base of the natural logarithm. This function is the inverse of Log, the natural logarithm of number.
- **method-numeric-fix** - Converts a real number to an integer.
- **method-numeric-floor** - Calculates the closest integer that is smaller than number.
- **method-numeric-int** - Calculates the closest integer that is smaller than number.
- **method-numeric-log** - Calculates the natural logarithm of a number. Natural logarithms are based on the constant e (2.71828182845904).
- **method-numeric-log10** - Calculates the logarithm of number, to base 10.
- **method-numeric-max** - Determines the greater of two numbers.
- **method-numeric-min** - Determines the lesser of two numbers.
- **method-numeric-round** - Rounds a number to the closest integer.
- **method-numeric-sgn** - Determines the sign of a number.
- **method-numeric-sin** - Calculates the sine of an angle that is entered in radians.
- **method-numeric-sqr** - Calculates the square root of a number.
- **method-numeric-tan** - Calculates the tangent of an angle that is entered in radians.

# Objects

- **object-number** - 

# Guides

- **mathematical-precision** - Learn about the switch from double to BigDecimal in Lucee 6 for more precise mathematical operations. This guide provides information on how to change the default behavior if needed.