# Java



# Functions

- **function-bundleinfo** - if the given object is loaded by an OSGi bundle, this function is returning information about that bundle
- **function-createdynamicproxy** - Wraps the given component with a Java class that implements the specified interfaces. If no interfaces are provided, Lucee will create a proxy based on the component's interface itself.
- **function-createobject** - The CreateObject function takes different arguments depending on the value of the first argument:
- **function-getclasspath** - returns an array containing the Java classpath of the current environment.
- **function-getpagecontext** - Gets the current PageContext object that provides access to page attributes and configuration, request and response objects.
- **function-isinstanceof** - Determines whether an object is an instance of a Lucee interface or component, or of a Java class.
- **function-javacast** - Converts the data type of a CFML variable to pass as an argument to an overloaded method of a Java object. Use only for scalar and string arguments. [type - quickly] boolean,int,long,float,double,string
- **function-manifestread** - reads a manifest file and returns the content as struct
- **function-maveninfo** - Retrieves information about a Maven artifact and its dependencies. This function allows you to query details about a specific Maven artifact by providing its coordinates (groupId, artifactId, and optionally version). It returns a query containing information about the artifact itself and all of its dependencies based on the specified scope
- **function-mavenload** - Loads all JAR files from one or more Maven endpoints and makes them available for use within the Lucee server environment. This function can be used to load dependencies, including transitive ones, for example at server startup. Example Usage of MavenLoad Function The `MavenLoad` function allows you to load JAR files from Maven repositories, including all transitive dependencies
- **function-serialize** - opposite of evaluate, this function serialize all cfml object and all serializable Java objects. can also serialize Components.
- **function-unserializejava** - literal definition of a serialized Java Object by function serialize

# Tags

- **tag-import** - The tag `import` has multiple purposes: 1. Import components with the attribute `path` 2. Import Java classes (Lucee 6.2+) with the attribute `path` or its alias `java` 3. Import CFML/JSP custom tags with the attributes `prefix` and `taglib` In script syntax, you can use: - `cfimport(path=&amp;quot;org.lucee.example.MyCFC&amp;quot;);` - `import org
- **tag-object** - Lets you call methods in COM, CORBA, and JAVA objects.

# Guides

- **convert-a-cfml-func-to-java** - Learn how to convert user-defined functions or components in Lucee to use them in Java. This guide demonstrates how to define components to implement Java interfaces, pass components to Java methods, explicitly define interfaces, and use the onMissingMethod feature. It also shows how to convert user-defined functions to Java lambdas
- **csv-processing-lucee7** - Simple recipe for processing CSV data in Lucee 7 using Maven integration and Apache Commons CSV
- **dynamic-proxy-enhancements** - Learn about the improvements to dynamic proxy creation in Lucee 7, including automatic inclusion of component functions and properties when implementing Java interfaces.
- **excel-processing-lucee7** - Simple recipe for processing Excel files in Lucee 7 using Maven integration and Apache POI
- **component-getclass-method** - This document explains the getClass() method for CFML components that implement Java interfaces, enabling seamless Java interoperability.
- **import** - Guide on using import to import components, Java classes, and custom tags in Lucee
- **java-libraries** - Guide on using Java libraries in Lucee 6.2 with Maven and import
- **java-explicit-casting** - Shows how to explicitly cast a component to a specific interface.
- **java-class-interaction** - Documentation for interacting with Java classes and objects in Lucee
- **java-in-functions-and-closures** - Learn how to write CFML code directly in a function or a closure with Java types in Lucee. This guide demonstrates how to define functions and components with Java types, and how to use Java lambda functions within Lucee. You will see examples of how to handle exceptions, define return types, and implement functional Java interfaces (Lambdas) seamlessly
- **java-settings** - Guide on configuring Java settings in Lucee using Application.cfc, including loading Java libraries from Maven
- **lucee-5-osgi** - Lucee 5 is completely based around OSGi
- **lucee-with-maven** - You can add Lucee to your Maven pom.xml files via the following: And the dependency via: ```lucee org.lucee lucee 5.3.8.206 ``` Or the single Lucee jar artifactId is &amp;quot;lucee-jar&amp;quot;. (The above has all the dependencies, with the exception of database drivers which are marked as &amp;quot;optional&amp;quot;, thus not included by default
- **new-operator** - This document provides a guide on using the new operator in Lucee for creating instances of CFML components and Java classes.
- **tutorial-using-java-in-lucee** -  Do you really need Java? Before you start creating Java objects in Lucee you should ask yourself: Do I really need Java here or can I get the same result with CFML alone? It's been said in computing that &amp;quot;premature optimization is the root of all evil&amp;quot; and Sean will (rightfully) remind you that &amp;quot;perfection is the enemy of the good&amp;quot;, so if you can achieve similar results without referring to Java objects -- please stick to CFML path
- **maven** - How to use Maven in Lucee
- **yaml-processing-lucee7** - Simple recipe for processing YAML files in Lucee 7 using Maven integration and SnakeYAML