# Image manipulation



# Functions

- **function-getreadableimageformats** - Returns a list of image formats that Lucee can read on the operating system where Lucee is deployed.
- **function-getwriteableimageformats** - Returns a list of image formats that Lucee can write on the operating system where Lucee is deployed.
- **function-imageaddborder** - Adds a rectangular border around the outside edge of an image. The border can be a solid color or generated using various edge extension methods. The original image remains centered while the border increases the image dimensions.
- **function-imageblur** - Applies a box blur filter to smooth an image by averaging pixel values within a square region. Useful for reducing image noise or creating soft focus effects.
- **function-imagecaptcha** - Creates a captcha image
- **function-imageclearrect** - Clears the specified rectangle by filling it with the background color of the current drawing surface.
- **function-imagecoderinfo** - Gives detailed information about all coder used by the image extension.
- **function-imagecopy** - Creates a new image by copying a rectangular area from the source image. If destination coordinates are provided, the copied area is also drawn at the new location in the resulting image.
- **function-imagecrop** - Crops an image to a specified rectangular area. The function modifies the original image by extracting the defined region. If the specified crop area extends beyond the image boundaries, the function automatically adjusts to fit within the image dimensions.
- **function-imagedrawarc** - Draws a circular or elliptical arc.
- **function-imagedrawbeveledrect** - Draws a rectangle with beveled edges.
- **function-imagedrawcubiccurve** - Draws a cubic curve.
- **function-imagedrawimage** - this function is deprecated, use ImagePaste instead. Draws a image on a image with the baseline of the first character positioned at (x,y) in the image.
- **function-imagedrawline** - Draws a single line defined by two sets of x and y coordinates on a image.
- **function-imagedrawlines** - Draws a sequence of connected lines defined by arrays of x and y coordinates.
- **function-imagedrawoval** - Draws an oval.
- **function-imagedrawpoint** - Draws a point at the specified (x,y) coordinate.
- **function-imagedrawquadraticcurve** - Draws a curved line. The curve is controlled by a single point.
- **function-imagedrawrect** - Draws a rectangle.
- **function-imagedrawroundrect** - Draws a rectangle with rounded corners.
- **function-imagedrawtext** - Draws a text string on a image with the baseline of the first character positioned at (x,y) in the image.
- **function-imagefilter** - the function ImageFilter allows to execute a filter against a image.
- **function-imagefiltercolormap** - These are passed to the function ImageFilters (see ImageFilter documentation) which convert gray values to colors.
- **function-imagefiltercurves** - the curves for the wrap grid
- **function-imagefilterkernel** - These are passed to the function ImageFilters
- **function-imagefilterwarpgrid** - A warp grid. These are passed to the function ImageFilters (see ImageFilter documentation).
- **function-imageflip** - Transforms an image by flipping or rotating it along specified axes. This operation modifies the original image in place.
- **function-imagefonts** - return all available
- **function-imageformats** - return all available readers and writers
- **function-imagegetblob** - Retrieves the bytes of the underlying image. The bytes are in the same image format as the source image.
- **function-imagegetbufferedimage** - Returns the java.awt.BufferedImage object underlying the current image.
- **function-imagegetexifmetadata** - Retrieves the Exchangeable Image File Format (EXIF) headers in an image as a CFML structure.
- **function-imagegetexiftag** - Retrieves the specified EXIF tag in an image.
- **function-imagegetheight** - Retrieves the height of the image in pixels.
- **function-imagegetiptcmetadata** - Retrieves the International Press Telecommunications Council (IPTC )headers in a image as a struct. The IPTC metadata contains text that describes the image that is stored with it. IPTC metadata includes, but is not limited to, caption, keywords, credit, copyright, object name, created date, byline, headline, and source
- **function-imagegetwidth** - Retrieves the width of the specified image.
- **function-imagegrayscale** - Converts a image to grayscale.
- **function-imageinfo** - Returns a structure containing image information. When called with an image argument, returns details about the specific image including height, width, color model, size, and filename. When called without arguments, returns information about the Lucee image processing extension including its OSGi bundle version and status
- **function-imagenegative** - Creates a negative version of the image by inverting all pixel values. Each color channel value is subtracted from 255, resulting in opposite colors (e.g., white becomes black, red becomes cyan).
- **function-imagenew** - Creates a image.
- **function-imageoverlay** - Combines two images by overlaying one on top of the other using alpha compositing. The second image is blended with the first based on its transparency.
- **function-imagepaste** - Composites one image onto another at specified coordinates. The second image is overlaid on top of the first image, preserving transparency and using high-quality interpolation.
- **function-imageread** - Reads the source pathname or URL and creates a image.
- **function-imagereadbase64** - Creates a image from a Base64 string.
- **function-imageresize** - Resizes a image.
- **function-imagerotate** - Rotates a image at a specified point by a specified angle.
- **function-imagerotatedrawingaxis** - Rotates all subsequent drawing on a image at a specified point by a specified angle.
- **function-imagescaletofit** - Creates a resized image with the aspect ratio maintained.
- **function-imagesetantialiasing** - Switches antialiasing on or off in rendered graphics.
- **function-imagesetbackgroundcolor** - Sets the background color for the image. The background color is used for clearing a region. Setting the background color only affects the subsequent ImageClearRect calls
- **function-imagesetdrawingalpha** - Sets the current drawing alpha for images. All subsequent graphics operations use the specified alpha.
- **function-imagesetdrawingcolor** - Sets the current drawing color for images. All subsequent graphics operations use the specified color.
- **function-imagesetdrawingstroke** - Sets the drawing stroke for points and lines in subsequent images.
- **function-imagesetdrawingtransparency** - Specifies the degree of transparency of drawing functions.
- **function-imagesharpen** - Enhances image clarity by applying an unsharp mask filter. This technique works by: 1. Creating a blurred copy of the original image 2. Finding edges by comparing differences 3. Enhancing edge contrast where differences are found *Note:* Despite the name &amp;quot;unsharp mask&amp;quot;, this process actually increases sharpness.
- **function-imageshear** - Transforms an image by shearing it along one axis, creating a slanted or skewed effect. Positive values slant in one direction, negative values in the opposite direction.
- **function-imagesheardrawingaxis** - Shears the drawing canvas.
- **function-imagetranslate** - Moves an image to a new position by specified x and y offsets. The original image content is cleared and redrawn at the new location.
- **function-imagetranslatedrawingaxis** - Translates the origin of the image context to the point (x,y) in the current coordinate system.
- **function-imagewrite** - Writes a image to the specified filename or destination.
- **function-imagewritebase64** - Writes Base64 images to the specified filename and destination.
- **function-imagewritetobrowser** - Writes image to browser.
- **function-imagexordrawingmode** - Sets the paint mode of the image to alternate between the image's current color and the new specified color.
- **function-isimage** - Determines whether a variable returns a image.
- **function-isimagefile** - Verifies whether an image file is valid.

# Tags

- **tag-image** - Lets you resize and add labels to GIF and JPEG format images.

# Methods

- **method-image-addborder** - Adds a rectangular border around the outside edge of an image. The border can be a solid color or generated using various edge extension methods. The original image remains centered while the border increases the image dimensions.
- **method-image-blur** - Applies a box blur filter to smooth an image by averaging pixel values within a square region. Useful for reducing image noise or creating soft focus effects.
- **method-image-clearrect** - Clears the specified rectangle by filling it with the background color of the current drawing surface.
- **method-image-coderinfo** - Gives detailed information about all coder used by the image extension.
- **method-image-copy** - Creates a new image by copying a rectangular area from the source image. If destination coordinates are provided, the copied area is also drawn at the new location in the resulting image.
- **method-image-crop** - Crops an image to a specified rectangular area. The function modifies the original image by extracting the defined region. If the specified crop area extends beyond the image boundaries, the function automatically adjusts to fit within the image dimensions.
- **method-image-drawarc** - Draws a circular or elliptical arc.
- **method-image-drawbeveledrect** - Draws a rectangle with beveled edges.
- **method-image-drawcubiccurve** - Draws a cubic curve.
- **method-image-drawdrawlines** - Draws a sequence of connected lines defined by arrays of x and y coordinates.
- **method-image-drawimage** - this function is deprecated, use ImagePaste instead. Draws a image on a image with the baseline of the first character positioned at (x,y) in the image.
- **method-image-drawline** - Draws a single line defined by two sets of x and y coordinates on a image.
- **method-image-drawoval** - Draws an oval.
- **method-image-drawpoint** - Draws a point at the specified (x,y) coordinate.
- **method-image-drawquadraticcurve** - Draws a curved line. The curve is controlled by a single point.
- **method-image-drawrect** - Draws a rectangle.
- **method-image-drawroundrect** - Draws a rectangle with rounded corners.
- **method-image-drawtext** - Draws a text string on a image with the baseline of the first character positioned at (x,y) in the image.
- **method-image-filter** - Executes a filter on the given image
- **method-image-filtercolormap** - These are passed to the function ImageFilters (see ImageFilter documentation) which convert gray values to colors.
- **method-image-flip** - Transforms an image by flipping or rotating it along specified axes. This operation modifies the original image in place.
- **method-image-getblob** - Retrieves the bytes of the underlying image. The bytes are in the same image format as the source image.
- **method-image-getbufferedimage** - Returns the java.awt.BufferedImage object underlying the current image.
- **method-image-getexifmetadata** - Retrieves the Exchangeable Image File Format (EXIF) headers in an image as a CFML structure.
- **method-image-getexiftag** - Retrieves the specified EXIF tag in an image.
- **method-image-getheight** - Retrieves the height of the image in pixels.
- **method-image-getiptcmetadata** - Retrieves the International Press Telecommunications Council (IPTC )headers in a image as a struct. The IPTC metadata contains text that describes the image that is stored with it. IPTC metadata includes, but is not limited to, caption, keywords, credit, copyright, object name, created date, byline, headline, and source
- **method-image-getwidth** - Retrieves the width of the specified image.
- **method-image-grayscale** - Converts a image to grayscale.
- **method-image-info** - Returns a structure containing image information. When called with an image argument, returns details about the specific image including height, width, color model, size, and filename. When called without arguments, returns information about the Lucee image processing extension including its OSGi bundle version and status
- **method-image-negative** - Creates a negative version of the image by inverting all pixel values. Each color channel value is subtracted from 255, resulting in opposite colors (e.g., white becomes black, red becomes cyan).
- **method-image-overlay** - Combines two images by overlaying one on top of the other using alpha compositing. The second image is blended with the first based on its transparency.
- **method-image-paste** - Composites one image onto another at specified coordinates. The second image is overlaid on top of the first image, preserving transparency and using high-quality interpolation.
- **method-image-readbase64** - Creates a image from a Base64 string.
- **method-image-resize** - Resizes a image.
- **method-image-rotate** - Rotates a image at a specified point by a specified angle.
- **method-image-rotatedrawingaxis** - Rotates all subsequent drawing on a image at a specified point by a specified angle.
- **method-image-scaletofit** - Creates a resized image with the aspect ratio maintained.
- **method-image-setantialiasing** - Switches antialiasing on or off in rendered graphics.
- **method-image-setbackgroundcolor** - Sets the background color for the image. The background color is used for clearing a region. Setting the background color only affects the subsequent ImageClearRect calls
- **method-image-setdrawingalpha** - Sets the current drawing alpha for images. All subsequent graphics operations use the specified alpha.
- **method-image-setdrawingcolor** - Sets the current drawing color for images. All subsequent graphics operations use the specified color.
- **method-image-setdrawingstroke** - Sets the drawing stroke for points and lines in subsequent images.
- **method-image-setdrawingtransparency** - Specifies the degree of transparency of drawing functions.
- **method-image-sharpen** - Enhances image clarity by applying an unsharp mask filter. This technique works by: 1. Creating a blurred copy of the original image 2. Finding edges by comparing differences 3. Enhancing edge contrast where differences are found *Note:* Despite the name &amp;quot;unsharp mask&amp;quot;, this process actually increases sharpness.
- **method-image-shear** - Transforms an image by shearing it along one axis, creating a slanted or skewed effect. Positive values slant in one direction, negative values in the opposite direction.
- **method-image-sheardrawingaxis** - Shears the drawing canvas.
- **method-image-translate** - Moves an image to a new position by specified x and y offsets. The original image content is cleared and redrawn at the new location.
- **method-image-translatedrawingaxis** - Translates the origin of the image context to the point (x,y) in the current coordinate system. Modifies the image context so that its new origin corresponds to the point (x,y) in the image's original coordinate system.
- **method-image-write** - Writes a image to the specified filename or destination.
- **method-image-writebase64** - Writes Base64 images to the specified filename and destination.
- **method-image-writetobrowser** - Writes image to browser.
- **method-image-xordrawingmode** - Sets the paint mode of the image to alternate between the image's current color and the new specified color.

# Objects

- **object-image** -