# Formatting



# Functions

- **function-booleanformat** - True, for a non-zero value; False, otherwise.
- **function-cjustify** - Returns the given string justified to the center, padding out the words with spaces accordingly
- **function-dateformat** - Formats a date string to a given output
- **function-datetimeformat** - Formats a date/time string to a given output
- **function-decimalformat** - Converts a number to a decimal-formatted string.
- **function-dollarformat** - Formats a string in U.S. format.
- **function-htmlcodeformat** - Replaces special characters in a string with their HTML-escaped equivalents and inserts and tags at the beginning and end of the string. [version] HTML version to use. currently ignored. -1: The latest implementation of HTML 2.0: HTML 2.0 (Default) 3.2: HTML 3.2
- **function-htmleditformat** - Replaces special characters in a string with their HTML-escaped equivalents. [version] HTML version to use. currently ignored. -1: The latest implementation of HTML 2.0: HTML 2.0 (Default) 3.2: HTML 3.2 4.0: HTML 4.0
- **function-jsstringformat** - Escapes special JavaScript characters, such as single quotation mark, double quotation mark, and newline
- **function-ljustify** - Left justifies characters in a string of a specified length.
- **function-lscurrencyformat** - Formats a number in a locale-specific currency format.
- **function-lsdateformat** - Formats a date string to a given output using the current sessions locale
- **function-lsdatetimeformat** - Formats a date string to a given output using the current locale
- **function-lseurocurrencyformat** - this function is just an alias for lsCurrencyFormat
- **function-lsiscurrency** - Determines whether a string is a valid representation of a currency amount in the current locale.
- **function-lsnumberformat** - Formats a number to the given format mask in the current locale
- **function-lstimeformat** - Formats a time string to a given output using the current locale.
- **function-numberformat** - Creates a custom-formatted number value
- **function-paragraphformat** - Formats the carriage returns in a string to a HTML alternatives
- **function-rjustify** - Right justifies characters of a string.
- **function-serializejson** - Converts CFML data into a JSON (JavaScript Object Notation) representation of the data.
- **function-timeformat** - Formats a time string to a given output
- **function-truefalseformat** - True, for a non-zero value; False, otherwise.
- **function-urlencodedformat** - Generates a URL-encoded string. For example, it replaces spaces with %20, and non-alphanumeric characters with equivalent hexadecimal escape sequences. Passes arbitrary strings within a URL.
- **function-urlsessionformat** - Encodes the URL with the CFTOKEN/CFID/JSESSIONID
- **function-xmlformat** - Escapes special XML characters in a string, so that the string is safe to use with XML.
- **function-yesnoformat** - Yes, for a non-zero value; No, otherwise.

# Methods

- **method-any-numberformat** - Creates a custom-formatted number value. For international number formatting use LSNumberFormat. [mask - quickly] _,9 Digit placeholder; . decimal point; 0 Pads with zeros; ( ) less than zero, puts parentheses around the mask + plus sign before positive number minus before negative - a space before positive minus sign before negative , Separates every third decimal place with a comma
- **method-any-tojson** - Converts CFML data into a JSON (JavaScript Object Notation) representation of the data.
- **method-boolean-booleanformat** - True, for a non-zero value; False, otherwise.
- **method-boolean-yesnoformat** - Yes, for a non-zero value; No, otherwise.
- **method-datetime-dateformat** - Formats a date string to a given output
- **method-datetime-datetimeformat** - Formats a date/time string to a given output
- **method-datetime-lsdateformat** - Formats a date string to a given output using the current sessions locale
- **method-datetime-lsdatetimeformat** - Formats a date string to a given output using the current locale
- **method-datetime-lstimeformat** - Formats a time string to a given output using the current locale.
- **method-datetime-timeformat** - Formats a time string to a given output
- **method-string-cjustify** - Returns the given string justified to the center, padding out the words with spaces accordingly
- **method-string-ljustify** - Left justifies characters in a string of a specified length.
- **method-string-paragraphformat** - Formats the carriage returns in a string to a HTML alternatives
- **method-string-rjustify** - Right justifies characters of a string.
- **method-string-urlencodedformat** - Generates a URL-encoded string. For example, it replaces spaces with %20, and non-alphanumeric characters with equivalent hexadecimal escape sequences. Passes arbitrary strings within a URL.

# Guides

- **date-time-formatting** - Comprehensive guide to formatting dates and times in Lucee with locale and timezone support