# File handling

Provides access to File System Resources, this includes virtual file systems like ram, s3, git, ftp and ssh

# Functions

- **function-contractpath** - Does the opposite of the function expandPath(). Tries to match given absolute path to the mappings in the environment. When no mappings match, lucee creates a relative path from the current position.
- **function-directorycopy** - Copies the contents of a directory to a destination directory.
- **function-directorycreate** - Creates new directory for specified path
- **function-directorydelete** - Deltes directory for given path
- **function-directoryexists** - Determines whether a directory exists.
- **function-directoryinfo** - returns detailed info about the given directory.
- **function-directorylist** - Lists the contents of a specified directory and returns the list as an array or a query.
- **function-directoryrename** - Renames given directory
- **function-expandpath** - Creates an absolute, platform-appropriate path that is equivalent to the value of relative_path, appended to the base path. This function (despite its name) can accept an absolute or relative path in the relative_path attribute
- **function-fileappend** - appends the entire content to the specified file.
- **function-fileclose** - Closes an file that is open.
- **function-filecopy** - Copies the specified on-disk or in-memory source file to the specified destination file.
- **function-filedelete** - Deletes the specified file on the server.
- **function-fileexists** - Determines whether a file exists
- **function-filegetmimetype** - Returns the mimetype of the given file
- **function-fileinfo** - returns detailed info about the given file.
- **function-fileiseof** - Determines whether Lucee has reached the end of the file while reading it.
- **function-filemodetosymbolic** - Converts a mode mask to it's symbolic representation.
- **function-filemove** - Moves file from source to destination
- **function-fileopen** - Opens an file to read, write, or append.
- **function-fileread** - Reads an on-disk or in-memory text file or a file object created with the FileOpen function.
- **function-filereadbinary** - Reads an on-disk or in-memory binary file (such as an executable or image file) on the server, into a binary object
- **function-filereadline** - Reads a line from an file.
- **function-fileseek** - Shifts the file pointer to the given position. The file must be opened with seekable option
- **function-filesetaccessmode** - Sets the attributes of an on-disk file on UNIX or Linux. This function does not work with in-memory files.
- **function-filesetattribute** - For the given path, sets the file attributes.
- **function-filesetlastmodified** - For the given file, set the last modification date
- **function-fileskipbytes** - Shifts the file pointer by the given number of bytes.
- **function-filetouch** - Touches given file, creates the file if not already exists.
- **function-fileupload** - Uploads file to a directory on the server.
- **function-fileuploadall** - Uploads file to a directory on the server.
- **function-filewrite** - If you specify a file path, writes the entire content to the specified file. If you specify a file object, writes text or binary data to the file object.
- **function-filewriteline** - Opens up the file (or uses the existing file object) and appends the given line of text
- **function-getcanonicalpath** - Returns the canonical pathname string based on the given string.
- **function-getcurrenttemplatepath** - Gets the absolute path of the page that calls this function.
- **function-getdirectoryfrompath** - Extracts a directory from an absolute path. Returns the absolute path, without the filename.
- **function-getfilefrompath** - Extracts a filename from an absolute path.
- **function-getfileinfo** - Retrieves information about file.
- **function-getfreespace** - Returns the number of unallocated bytes in the partition named by this abstract path name.
- **function-getprofilesections** - Gets all the sections of an initialization file. An initialization file, as a struct whose format is as follows: - Each initialization file section name is a key in the struct - Each list of entries in a section of an initialization file is a value in the struct
- **function-getprofilestring** - Gets an initialization file entry.
- **function-gettempdirectory** - Returns the full path to the currently assigned temporary directory, optionally creating a unique temp directory
- **function-gettempfile** - Creates a unique temporary file with a prefix in a directory.
- **function-gettotalspace** - Returns the size of the partition named by this abstract pathname.
- **function-getvfsmetadata** - Returns metadata about the Virtual File system (VFS)
- **function-imagewrite** - Writes a image to the specified filename or destination.
- **function-isfileobject** - Determines whether a value is an file object. True, if the value represents a file object.
- **function-isimagefile** - Verifies whether an image file is valid.
- **function-iszipfile** - Verifies whether an zip file is valid.
- **function-setprofilestring** - Sets the value of a profile entry in an initialization file.

# Tags

- **tag-directory** - Handles interactions with directories.
- **tag-file** - Handles all interactions with files

# Categories

- **category-s3** - Provides access to S3 resources

# Guides

- **tag-fileupload** - This tag is not supported by Lucee.
- **mappings-how-to-define-a-reg-mapping** - All about the different mappings in Lucee and how to use them.
- **configuration-directory-placeholders** - Placeholders are uses to reference specific Lucee directories
- **cookbook-filesystem-mapping** - Overview of different mapping types in the file system.
- **file-system-types** - Lucee gives you access to a number of resources Local Files Provides access to the files on the local physical file system. Format ```lucee [file://] absolute-path ``` Where absolute-path is a valid absolute file name for the local filesystem. Examples ```lucee /home/someuser/somedir c:\program files\some dir c:/program files/some dir file://home/someuser/somedir file://C:/Documents and Settings file:////somehost/someshare/afile
- **file-upload-result** - Return a struct with the information about the file upload operations as the result of [[tag-file|cffile action=&amp;quot;upload&amp;quot;]], [[function-fileupload]], or [[function-fileuploadall]]. General Information | Key | Description | |----------------------|-------------| | attemptedServerFile | Name of the file that Lucee attempted to save | | clientDirectory | Directory of the uploaded file in the client's system | | clientFile | File name of the uploaded file in the client's system | | clientFileExt | Extension of the uploaded file in the client's system | | clientFileName | File name of the uploaded file without extension in the client's system | | contentSubtype | MIME content subtype of the file (e
- **loop_through_files** - This document explains how to handle large files in Lucee more efficiently.
- **lucee-resources** - Extend your file system with any virtual file system


# Categories

[[category-s3]]