# Extensions

Lucee Extensions add additional functionality, such as tags or functions, JDBC support or admin plugins

When writing a Lucee Extension in Java, remember to only use the java / functions / api from the [Lucee Loader interface](https://www.javadoc.io/doc/org.lucee/lucee/latest/index.html)

# Functions

- **function-extensionexists** - Checks if a certain extension exists or not.
- **function-extensionlist** - Checks if a certain extension exists or not.

# Guides

- **plugins** -  Admin Plugins Lucee extensions can contribute pages to the web-based administrator that allow you to interact with the user, collection licensing details or display data. To bundle a plugin with your Lucee extension, create a directory called `plugins` in your extension. Any folders inside the plugins directory will be a plugin named after the folder name they are contained in
- **building-testing-extensions** - How to build, test and submit changes to Lucee extensions, using Ant, GitHub and Lucee script-runner
- **extension-couchdb** -  CouchDB Cache Provider Extension The Lucee Server CouchDB Cache Provider Extension allows you to use CouchDB as a key/value cache for your Objects (components), Templates, Queries and Resources (such as files etc). CouchDB is a free and open source document-oriented database written in the Erlang programming language
- **tutorial-extension-provider-part2** -  Creating an extension - Part 2 In the first part of the tutorial entry we created an extension provider for a local context which we can use in order to create our extension of choice Mango Blog. This entry will cover the collection of the necessary data in the config.xml file which is part of the installation repository
- **tutorial-extension-provider-part1** - Creating a local extension provider
- **tutorial-extension-provider-part4** -  Writing an extension - Part 4 - The installer After we have created and validated the configuration data, we should now finally install the software. The install method gives you the possibility to do nearly whatever you like within the Lucee boundaries. In order to have some support methods available you can extend some existing helper CFC's
- **component-jobs-quartz-scheduler** - How to create and configure component-based jobs with the Quartz Scheduler extension
- **extension-cfcs-matrix** - The methods marked red are system methods and should therefore not be called in the installation application. The hierarchy looks like follows: ExtensionConfig.cfc ? ExtensionStep.cfc ? ExtensionGroup.cfc ? ExtensionItem.cfc ? ExtensionOption.cfc **ExtensionConfig.cfc** Method | Description ------------ | ------------- createStep(string: label, string: description): ExtensionStep | Creates and links a new step
- **extension-config-xml-matrix** -  config.xml matrix **Tag config** Attribute | Description ------------ | ------------- dynamic | This attribute contains a method name of the install.cfc. It can completely fill the form dynamically. The method receives the loaded ExtensionConfig CFC as an argument. **Tag Step** Attribute | Description ------------ | ------------- dynamic | This attribute contains a method name of the install
- **extension-installation** - A comprehensive guide on how to install extensions in Lucee.
- **tutorial-extension-provider** - Tutorial, Creating an extension for Lucee 3.1
- **lucee-5-extensions** - Application` section. If you add the file to the `/lucee-server/deploy/` folder, you might need to wait a little bit, it can take Lucee up to a minute to recognize and install the extension. After the extension disappears from the 'deploy' directory it is installed. If you now go to the Lucee Server Admin and to the `Extension -&amp;gt; Application` section, you should see it there as installed
- **extensions** - In this section, you'll find information about Lucee extensions, which provide additional functions, tags, JDBC/Cache drivers and admin plugins for Lucee Extensions can be installed via the Web or Server Admin, under Extensions, Applications. [Extensions in Lucee 5](../guides/lucee-5/extensions.md) How to build Lucee 5 extensions. [Admin Plugins](../guides/extensions/plugins.md) How to build admin plugins [Extension Provider](../guides/Various/tutorial-lucee/tutorial-extension-provider.md) Extension Provider Tutorial [Available extensions](https://download
- **lucene-3-extension** - Documentation for the Lucene 3 Extension with vector and hybrid search capabilities
- **extension-membase** - Membase Cache Provider Extension
- **extension-mongodb** - MongoDB Cache Provider Extension
- **scheduler-quartz** - Advanced task scheduling using Quartz Scheduler integration
- **clustering-quartz-scheduler** - How to set up and configure clustering with the Quartz Scheduler extension
- **tutorial-extension-provider-part3** -  Writing a Lucee extension - Part 3 After we have created the provider and created the form, we now want to validate the form so that one can check for different circumstances in the form editing. So whether combinations of fields are allowed only or similar other checks. For this you can use the method called validate of the install
- **tutorial-extension-provider-part5** -  Writing an extension - Part IV - Tips and tricks We have completely built an extension from scratch and created the form to enter the data and validate it with the help of the install.cfc methods. The install method in there finally installs the application. In order to work quite fast when creating an extension there are a couple of things that might help