# Encode/Decode

Used to prevent XSS, these functions use the ESAPI (Enterprise Security API) library to safely handle user input.

[https://github.com/lucee/extension-esapi](https://github.com/lucee/extension-esapi)

# Functions

- **function-canonicalize** - Canonicalization is simply the operation of reducing a possibly encoded string down to its simplest form. This is important, because attackers frequently use encoding to change their input in a way that will bypass validation filters, but still be interpreted properly by the target of the attack. Note that data encoded more than once is not something that a normal user would generate and should be regarded as an attack
- **function-decodeforhtml** - Decodes the given encoded string.
- **function-decodefromurl** - Decodes a string that has been encoded in the URL using the encodeForURL. this function is deprecated, use function ESAPIDecode('url',...) instead.
- **function-encodeforcss** - Encodes the given string for safe output in CSS to reduce the risk of Cross Site Scripting attacks.
- **function-encodefordn** - Encodes the given string for safe output in LDAP Distinguished Names.
- **function-encodeforhtml** - Encodes the given string for safe output in HTML to reduce the risk of Cross Site Scripting attacks.
- **function-encodeforhtmlattribute** - Encodes the given string for safe output in HTML to reduce the risk of Cross Site Scripting attacks.
- **function-encodeforjavascript** - Encodes the given string for safe output in JavaScript to reduce the risk of Cross Site Scripting attacks.
- **function-encodeforldap** - Encodes the given string for safe output in LDAP queries.
- **function-encodeforsql** - Encodes the given string for safe output in a query to reduce the risk of SQL Injection attacks. _This method is not recommended_ - the use of query parameters are strongly encouraged as a stronger alternative.
- **function-encodeforurl** - Encodes the given string for safe output in a URL.
- **function-encodeforxml** - Encodes the given string for safe output in XML to reduce the risk of Cross Site Scripting attacks.
- **function-encodeforxmlattribute** - Encodes the given string for safe output in XMLAttribute to reduce the risk of Cross Site Scripting attacks.
- **function-encodeforxpath** - Encodes the given string for safe use in an XPath Query.
- **function-esapidecode** - Decodes a string that has been encoded with ESAPIEncode.
- **function-esapiencode** - Encodes the given string for safe output to reduce the risk of Cross Site Scripting attacks.
- **function-htmleditformat** - Replaces special characters in a string with their HTML-escaped equivalents. [version] HTML version to use. currently ignored. -1: The latest implementation of HTML 2.0: HTML 2.0 (Default) 3.2: HTML 3.2 4.0: HTML 4.0
- **function-sanitize** - Detects and masks sensitive information (such as passwords, API keys, tokens, etc.) from a given string. The function identifies patterns commonly used for sensitive data and replaces them with a mask.
- **function-sanitizehtml** - Sanitizes unsafe HTML input and removes elements and attributes like JavaScript, onclick, etc. See also https://github.com/OWASP/java-html-sanitizer
- **function-tobase64** - Calculates the Base64 representation of a string or binary object.
- **function-tobinary** - Calculates the binary representation of Base64-encoded data.
- **function-urldecode** - Decodes a URL-encoded string, converting encoded characters back to their original form. This function handles URL encoding conventions such as converting plus signs (`+`) to spaces and percent-encoded sequences (`%xx`) to their corresponding characters. The function throws an exception when encountering malformed URL encodings (such as incomplete or invalid percent sequences like `%G`)
- **function-urlencode** - Encodes a string to be URL-safe according to the application/x-www-form-urlencoded MIME format
- **function-urlencodedformat** - Generates a URL-encoded string. For example, it replaces spaces with %20, and non-alphanumeric characters with equivalent hexadecimal escape sequences. Passes arbitrary strings within a URL.

# Methods

- **method-string-decodeforhtml** - Decodes the given encoded string.
- **method-string-decodefromurl** - Decodes a string that has been encoded in the URL using the encodeForURL. this function is deprecated, use function ESAPIDecode('url',...) instead.
- **method-string-encodeforcss** - Encodes the given string for safe output in CSS to reduce the risk of Cross Site Scripting attacks.
- **method-string-encodefordn** - Encodes the given string for safe output in LDAP Distinguished Names.
- **method-string-encodeforhtml** - Encodes the given string for safe output in HTML to reduce the risk of Cross Site Scripting attacks.
- **method-string-encodeforhtmlattribute** - Encodes the given string for safe output in HTML to reduce the risk of Cross Site Scripting attacks.
- **method-string-encodeforjavascript** - Encodes the given string for safe output in JavaScript to reduce the risk of Cross Site Scripting attacks.
- **method-string-encodeforldap** - Encodes the given string for safe output in LDAP queries.
- **method-string-encodeforsql** - Encodes the given string for safe output in a query to reduce the risk of SQL Injection attacks. _This method is not recommended_ - the use of query parameters are strongly encouraged as a stronger alternative.
- **method-string-encodeforurl** - Encodes the given string for safe output in a URL.
- **method-string-encodeforxml** - Encodes the given string for safe output in XML to reduce the risk of Cross Site Scripting attacks.
- **method-string-encodeforxmlattribute** - Encodes the given string for safe output in XMLAttribute to reduce the risk of Cross Site Scripting attacks.
- **method-string-encodeforxpath** - Encodes the given string for safe use in an XPath Query.
- **method-string-sanitizehtml** - Sanitizes unsafe HTML input and removes elements and attributes like JavaScript, onclick, etc. See also https://github.com/OWASP/java-html-sanitizer