# Decision logic



# Functions

- **function-arrayisdefined** - Returns whether there exists an item in the array at the selected index.
- **function-arrayisempty** - Determines if the array is empty.
- **function-directoryexists** - Determines whether a directory exists.
- **function-fileexists** - Determines whether a file exists
- **function-isarray** - Determines whether a value is an array.
- **function-isbinary** - Determines whether a value is stored as binary data.
- **function-isboolean** - Determines if the object represents a boolean value
- **function-isclosure** - checks if given Object is a closure or not.
- **function-iscustomfunction** - Determines whether a name represents a custom function
- **function-isdate** - Determines whether a string or Java object can be converted to a date/time value.
- **function-isdebugmode** - Determines whether debugging output is enabled.
- **function-isdefined** - Evaluates a string value to determine whether the variable named in it exists.
- **function-isempty** - Returns whether or not a given value is &amp;quot;empty&amp;quot;.
- **function-isfileobject** - Determines whether a value is an file object. True, if the value represents a file object.
- **function-isimage** - Determines whether a variable returns a image.
- **function-isimagefile** - Verifies whether an image file is valid.
- **function-isinstanceof** - Determines whether an object is an instance of a Lucee interface or component, or of a Java class.
- **function-isipinrange** - Checks if an ip is in the range of a list of given ips. IPv4 and IPv6 are supported.
- **function-isipv6** - checks if given IP is of IPV6 format
- **function-isjson** - Evaluates whether a string is in a valid JSON (JavaScript Object Notation) or JSON5 data interchange format.
- **function-isleapyear** - Determines whether a year is a leap year.
- **function-islocalhost** - Determines whether the specified IP address is the localhost.
- **function-isnull** - Determines whether given object is null or not
- **function-isnumeric** - Determines if the object represents a numeric
- **function-isnumericdate** - Evaluates whether a real number is a valid representation of a date (date/time object).
- **function-isobject** - Determines whether a value is an object.
- **function-ispdfobject** - Determines whether a value is a PDF object.
- **function-isquery** - Determines whether value is a query.
- **function-issimplevalue** - Determines if the object represents a simple value like a string, number, boolean etc
- **function-issoaprequest** - Determines whether a CFC is being called as a web service.
- **function-isstruct** - Determines if the object is a structure
- **function-isuserinanyrole** - Determines whether an authenticated user belongs to any role in a list of roles.
- **function-isuserinrole** - Determines whether an authenticated user belongs to the specified Role.
- **function-isuserloggedin** - Determines whether a user is logged in.
- **function-isvalid** - Tests whether a value meets a validation or data type rule.
- **function-iswddx** - Determines whether a value is a well-formed WDDX packet.
- **function-iswithintransaction** - Determines whether the current thread is within a transaction block or not.
- **function-isxml** - Determines whether a string is well-formed XML text.
- **function-isxmlattribute** - Determines whether the function parameter is an XML Document Object Model (DOM) attribute node.
- **function-isxmldoc** - Determines whether a function parameter is an Extended Markup language (XML) document object.
- **function-isxmlelem** - Determines whether a function parameter is an Extended Markup language (XML) document object element.
- **function-isxmlnode** - Determines whether the function parameter is an XML document object node.
- **function-isxmlroot** - Determines whether a function parameter is the root element of an Extended Markup language (XML) document object.
- **function-iszipfile** - Verifies whether an zip file is valid.
- **function-len** - Determines the length of a string, array or struct
- **function-lsiscurrency** - Determines whether a string is a valid representation of a currency amount in the current locale.
- **function-lsisdate** - Determines whether a string is a valid representation of a date/time value in the current locale.
- **function-lsisnumeric** - Determines whether a string is a valid representation of a number in the current locale.
- **function-objectequals** - compares simply and complex objects for equality, by default, string comparison is not case sensitive
- **function-structisempty** - Determines whether a structure contains data.

# Methods

- **method-array-isdefined** - Returns whether there exists an item in the array at the selected index.
- **method-array-isempty** - Determines if the array is empty.
- **method-struct-isempty** - Determines whether a structure contains data.

# Guides

- **types-in-lucee** - This document explains types in Lucee. Lucee is still an untyped language. Types are only a check put on top of the language.