# Debugging



# Functions

- **function-callstackdump** - Dump the context (stacktrace) of the current position.
- **function-callstackget** - Returns the context (stacktrace) of the current position.
- **function-componentcachelist** - list elements in the component path cache
- **function-debugadd** - Adding data to debug output.
- **function-dump** - Outputs the elements, variables and values of most kinds of CFML objects. Useful for debugging. You can display the contents of simple and complex variables, objects, components, user-defined functions, and other elements.
- **function-echo** - Writes the given string to the main response buffer regardless of conditions established by the cfsetting tag. see also function writeOutput.
- **function-getcomponentmetadata** - Gets metadata (such as the functions and implemented interfaces of a component) for a CFC or Interface.
- **function-getcomponentstaticscope** - returns the static scope of a specific component, of course access rules apply.
- **function-getcontextinfo** - Returns information about the current context.
- **function-getcontextroot** - Returns path to the J2EE server context root for the current request.
- **function-getcpuusage** - returns the CPU usage for a defined time range (default: 1000ms).
- **function-getmetadata** - Returns back meta information depending on the object passed in
- **function-getpagecontext** - Gets the current PageContext object that provides access to page attributes and configuration, request and response objects.
- **function-gettickcount** - Returns the elapsed time from a specific reference point, based on the specified `unit`. The default unit, &amp;quot;milli,&amp;quot; represents milliseconds since midnight, January 1, 1970 UTC, and aligns with conventional system time. The &amp;quot;nano&amp;quot; and &amp;quot;micro&amp;quot; units offer high-resolution timing based on the Java Virtual Machine's internal clock, ideal for measuring elapsed time rather than absolute wall-clock time
- **function-isdebugmode** - Determines whether debugging output is enabled.
- **function-logallthreads** - Creates detailed thread stack trace logs in JSONL format for performance analysis and debugging. This function captures stack traces from all running threads at specified intervals for a given duration. It executes asynchronously, returning immediately after starting the logging process, making it ideal for analyzing specific code segments by initiating logging just before the target code execution
- **function-sizeof** - this function is experimental, do not use in a production environment. this function returns the size in bytes of a given object.
- **function-systemoutput** - writes the given string to the output stream.
- **function-trace** - Displays and logs debugging data about the state of an application at the time this function executes.
- **function-writedump** - Outputs the elements, variables and values of most kinds of CFML objects. Useful for debugging. You can display the contents of simple and complex variables, objects, components, user-defined functions, and other elements.
- **function-writelog** - Writes a message to a log file.

# Tags

- **tag-dump** - Outputs the elements, variables and values of most kinds of CFML objects. Useful for debugging. You can display the contents of simple and complex variables, objects, components, user-defined functions, and other elements.
- **tag-log** - Writes a message to a log file.
- **tag-processingdirective** - Sets compiler directives that affect the entire template. Unlike most CFML tags, cfprocessingdirective is processed at compile time and must be placed at the root level of your template.
- **tag-setting** - Controls various aspects of page processing, such as the output of HTML code in pages. One benefit of this option is managing whitespace that can occur in output pages served by CFML.
- **tag-throw** - The cfthrow tag raises a developer-specified exception
- **tag-timer** - Displays execution time for a specified section of CFML code.
- **tag-trace** - Displays and logs debugging data about the state of an application at the time the cftrace tag executes.

# Guides

- **exception-cause** - Lucee 6.1 improves its support for exception causes, providing better debugging and error handling capabilities.
- **exception-output** - How to catch and display exceptions.
- **execution_log** - Log details about code execution at the statement level
- **lucee-step-debugger-installation-guide** - How to set up the step debugger &amp;quot;luceedebug&amp;quot; for enhanced CFML Debugging in Visual Studio Code and Lucee
- **monitoring-enable-for-your-session** - Shows you a way to enable Monitoring for your session
- **monitoring-debugging** - Learn about the changes in Lucee 6.1 regarding Monitoring and Debugging. Understand the old and new behavior, and how to configure the settings in Lucee Admin and Application.cfc.
- **systemoutput-recipe** - This document explains the systemoutput function with some simple examples.
- **thread-dump-startup** - How to capture thread positions during Lucee startup for debugging and performance analysis
- **troubleshooting** - A guide to diagnosing problems with Lucee