# Date and time

[Datetime Timezone Handling in Lucee CFML](https://www.andrewdixon.co.uk/2019/05/25/datetime-timezone-handling-in-lucee-cfml/)

[Video on Timezones in Lucee](https://www.youtube.com/watch?v=aIggbT8f3ls)

# Functions

- **function-beat** - Outputs the current swatch/beat time.
- **function-clearTimeZone** - resets the timezone for the current request to Lucee default setting.
- **function-createdate** - Creates a CFML date object from the given year, month and day
- **function-createdatetime** - Creates a CFML date/time object from the given year, month, day, hour, minute and second
- **function-createodbcdate** - Creates an ODBC date object.
- **function-createodbcdatetime** - Creates an ODBC date-time object.
- **function-createodbctime** - Creates an ODBC time object.
- **function-createtime** - Creates a CFML time object from the given hour, minute and second
- **function-createtimespan** - Creates a timespan object that defines a time period.
- **function-dateadd** - Adds units of time to a date object.
- **function-datecompare** - Compares two dates to a given optional resolution
- **function-datediff** - Determines the number of given date parts between two different dates
- **function-dateformat** - Formats a date string to a given output
- **function-datepart** - Extracts the given date part from the date object
- **function-datetimeformat** - Formats a date/time string to a given output
- **function-day** - Determines the day of the month, in a date. The ordinal for the day of the month, ranging from 1 to 31.
- **function-dayofweek** - Determines the day of the week, in a date.
- **function-dayofweekasstring** - Determines the day of the week as a string from 1-7
- **function-dayofweekshortasstring** - Returns the string representation of the given day index in short form
- **function-dayofyear** - Determines the day of the year, in a date.
- **function-daysinyear** - Determines the number of days in a year.
- **function-firstdayofmonth** - Determines the ordinal (day number, in the year) of the first day of the month in which a given date falls.
- **function-gethttptimestring** - Gets the current time, in the Universal Time code (UTC).
- **function-getlocale** - Gets the current geographic/language locale value.
- **function-getlocaleinfo** - returns info to a specific Locale
- **function-getnumericdate** - Returns a real number whose integer part represents the number of days since the EPOCH and whose fractional part represents the time value expressed in hours then divided by 24
- **function-gettimezone** - returns the timezone defined for the current request.
- **function-gettimezoneinfo** - Returns a structure representing the current timezone
- **function-hour** - Gets the current hour of the day. Ordinal value of the hour, in the range 0 - 23.
- **function-isdate** - Determines whether a string or Java object can be converted to a date/time value.
- **function-isleapyear** - Determines whether a year is a leap year.
- **function-isnumericdate** - Evaluates whether a real number is a valid representation of a date (date/time object).
- **function-isvalid** - Tests whether a value meets a validation or data type rule.
- **function-lsdateformat** - Formats a date string to a given output using the current sessions locale
- **function-lsdatetimeformat** - Formats a date string to a given output using the current locale
- **function-lsdayofweek** - Returns the day of the week the date represents in locale format
- **function-lsisdate** - Determines whether a string is a valid representation of a date/time value in the current locale.
- **function-lsparsedatetime** - Converts a string that is a valid date/time representation in the current locale into a date/time object.
- **function-lstimeformat** - Formats a time string to a given output using the current locale.
- **function-lsweek** - Returns the week number in the year of the date referenced, based on the local influence.
- **function-millisecond** - Returns the milliseconds of the referenced date
- **function-minute** - Extracts the minute value from a date/time object.
- **function-month** - Extracts the month value from a date/time object.
- **function-monthshortasstring** - Returns the string label for the given month in short format
- **function-now** - Returns the current date and time
- **function-nowserver** - this function is deprecated, returns the current time on the server independent on lucee timezone definition
- **function-parsedatetime** - Parses a date/time string according to the English (U.S.) locale conventions.
- **function-quarter** - Calculates the quarter of the year in which a date falls.
- **function-second** - Extracts the ordinal for the second from a date/time object.
- **function-setlocale** - Sets the country/language locale for CFML processing and the page returned to the client.
- **function-settimezone** - change the timezone definition for the current request.
- **function-timeformat** - Formats a time string to a given output
- **function-week** - From a date/time object, determines the week number within the year. An integer in the range 1-53; the ordinal of the week, within the year.
- **function-year** - From a date/time object, gets the year value.

# Methods

- **method-datetime-add** - Adds units of time to a date.
- **method-datetime-compare** - Compares to date, to the given optional resolution.
- **method-datetime-dateformat** - Formats a date string to a given output
- **method-datetime-datetimeformat** - Formats a date/time string to a given output
- **method-datetime-day** - Determines the day of the month, in a date. The ordinal for the day of the month, ranging from 1 to 31.
- **method-datetime-dayofweek** - Determines the day of the week, in a date.
- **method-datetime-dayofyear** - Determines the day of the year, in a date.
- **method-datetime-daysinmonth** - Determines the number of days in a month.
- **method-datetime-daysinyear** - Determines the number of days in a year.
- **method-datetime-diff** - Determines the number of given date parts between two different dates
- **method-datetime-firstdayofmonth** - Determines the ordinal (day number, in the year) of the first day of the month in which a given date falls.
- **method-datetime-hour** - Gets the current hour of the day. Ordinal value of the hour, in the range 0 - 23.
- **method-datetime-lsdateformat** - Formats a date string to a given output using the current sessions locale
- **method-datetime-lsdatetimeformat** - Formats a date string to a given output using the current locale
- **method-datetime-lsdayofweek** - Returns the day of the week the date represents in locale format
- **method-datetime-lstimeformat** - Formats a time string to a given output using the current locale.
- **method-datetime-millisecond** - Returns the milliseconds of the referenced date
- **method-datetime-minute** - Extracts the minute value from a date/time object.
- **method-datetime-month** - Extracts the month value from a date/time object.
- **method-datetime-part** - Extracts the given date part from the date object
- **method-datetime-quarter** - Calculates the quarter of the year in which a date falls.
- **method-datetime-second** - Extracts the ordinal for the second from a date/time object.
- **method-datetime-timeformat** - Formats a time string to a given output
- **method-datetime-week** - From a date/time object, determines the week number within the year.
- **method-datetime-year** - From a date/time object, gets the year value.
- **method-string-parsedatetime** - Parses a date/time string according to the English (U.S.) locale conventions.
- **method-timezone-info** - Returns a structure describing the current timezone

# Objects

- **object-datetime** - 
- **object-timezone** - Timezone

# Categories

- **category-internationalization** - 

# Guides

- **cookbook-basic-date** - Learn how to output the current date in Lucee.
- **configuring-regional-settings** - Lucee by default, uses the JVM's default timezone, which comes from the operating system.
- **custom-dateTime-format-locale-files** - This documentation shows how to set the custom date and time format using .df files