# Cryptography



# Functions

- **function-argon2checkhash** - Returns hash of input using Argon2.
- **function-csrfgeneratetoken** - Provides a random token and stores it in the session.
- **function-csrfverifytoken** - Validates the given token against the same stored in the session for a specific key.
- **function-decrypt** - Decrypts a string that is encrypted with the Encrypt function.
- **function-decryptbinary** - Decrypts the given binary with the optional parameters
- **function-encrypt** - Encrypts a string. Uses a symmetric key-based algorithm, in which the same key is used to encrypt and decrypt a string.
- **function-encryptbinary** - Encrypts binary data using a specific algorithm and encoding method.
- **function-generate3deskey** - Generates a secure key value for use in the encrypt function with the 3DES algorithm.
- **function-generateargon2hash** - Returns hash of input using Argon2.
- **function-generatepbkdfkey** - Implementation of Password-Based Key-Derivation Function (PBKDF).
- **function-generatersakeys** - Generates a secure keys (private and public) for use in the encrypt function with the RSA algorithm.
- **function-generatesecretkey** - Gets a secure key value for use in the encrypt function.
- **function-hash** - Returns the one-way hash of a variable-length input string based on the algorithm, producing a fixed-length string.
- **function-hash40** - This function only exists for backward compatibility to Lucee 4.0
- **function-hmac** - Creates a hash-based message authentication code (HMAC)
- **function-randomize** - Seeds the pseudo-random number generator with an integer number, ensuring repeatable number patterns.
- **function-randrange** - Generates a random integer between two specified numbers.
- **function-sslcertificatelist** - Returns a list of SSL certificates. If a host is specified, it lists the certificates available for that specific host. If no host is specified, it lists all certificates stored in the KeyStore.

# Guides

- **checksum** - This document explains how to use a checksum in Lucee.
- **encryption_decryption** - This document explains about Encryption/Decryption with public and private keys with simple examples.