# Core CFML Language

The core elements of the CFML Language.

CFML started as a tag based language and then introduced [<cfscript>](../reference/tags/script.md).

So keep in mind, all these tags, i.e [<cfif>](../reference/tags/if.md) can be also used in [<cfscript>](../reference/tags/script.md), which is similar to JavaScript.

```cfml
// tag
<cfif redirect>
    <cflocation url="https://www.lucee.org">
</cfif>

// cfscript
if (redirect)
    location url="https://www.lucee.org";
    // or
    location(url="https://www.lucee.org");
}

// tags
<cfloop from=1 to=10 item="i">
  <cfoutput>#i#</cfoutput>
</cfloop>

// cfscript
loop from=1 to=10 item="i" {
  echo(i);
}
```

# Functions

- **function-createguid** - Creates a Globally Unique Identifier (GUID). A GUID is a 36-character string representation of a unique 128-bit integer xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx where x is a hexadecimal digit. A GUID is just a UUID with one extra dash.
- **function-createobject** - The CreateObject function takes different arguments depending on the value of the first argument:
- **function-createulid** - Generates a ULID (Universally Unique Lexicographically Sortable Identifier)
- **function-createuuid** - Creates a Universally Unique Identifier (UUID). A UUID is a 35-character string representation of a unique 128-bit integer xxxxxxxx-xxxx-xxxx-xxxxxxxxxxxxxxxx where x is a hexadecimal digit.
- **function-getcurrenttemplatepath** - Gets the absolute path of the page that calls this function.
- **function-len** - Determines the length of a string, array or struct

# Tags

- **tag-abort** - **Stops processing of a page at the tag location.** CFML returns everything that was processed before the cfabort tag. The cfabort tag is often used with conditional logic to stop processing a page when a condition occurs.
- **tag-catch** - Used only inside a cftry, the cfcatch tag catches and process exceptions.
- **tag-component** - Creates and defines a component object
- **tag-content** - Defines the MIME type returned by the current page. Optionally, lets you specify the name of a file to be returned with the page.
- **tag-directory** - Handles interactions with directories.
- **tag-dump** - Outputs the elements, variables and values of most kinds of CFML objects. Useful for debugging. You can display the contents of simple and complex variables, objects, components, user-defined functions, and other elements.
- **tag-else** - Used with cfelse and cfelseif, cfif lets you create simple and compound conditional statements in CFML. The value in the cfif tag can be any expression.
- **tag-elseif** - Used with cfelse and cfelseif, cfif lets you create simple and compound conditional statements in CFML. The value in the cfif tag can be any expression.
- **tag-execute** - Enables developers to execute a process on a server computer.
- **tag-file** - Handles all interactions with files
- **tag-function** - Defines a function within a CFML component that can accept arguments and return a value.
- **tag-header** - Generates custom HTTP response headers to return to the client.
- **tag-http** - Lets you execute HTTP POST and GET operations on files.
- **tag-if** - Used with cfelse and cfelseif, cfif lets you create simple and compound conditional statements in CFML. The value in the cfif tag can be any expression.
- **tag-include** - Lets you embed references to pages in CFML. You can embed cfinclude tags recursively. For an additional method of encapsulating CFML
- **tag-location** - Redirect the current request to another URL.
- **tag-lock** - Provides two types of locks to ensure the integrity of shared data: Exclusive lock and Read-only lock.
- **tag-loop** - Looping is a very powerful programming technique that lets you repeat a set of instructions or display output repeatedly until one or more conditions are met. cfloop supports five types of loops.
- **tag-mail** - Sends e-mail messages by an SMTP server.
- **tag-module** - Invokes a custom tag for use in cfml templates. The cfmodule tag can help deal with custom tag name conflicts. Use the template attribute to name a template that contains the custom tag definition, including its path..
- **tag-output** - Displays the results of a database query or other operation. To nest cfoutput tags, see the &amp;quot;Usage&amp;quot; section.
- **tag-param** - Tests for a parameter's existence, tests its data type, and provides a default value if one is not assigned.
- **tag-query** - Passes SQL statements to a data source. Not limited to queries.
- **tag-return** - Returns result values from a component method. Contains an expression returned as result of the function.
- **tag-savecontent** - Saves the generated content inside the tag body in a variable.
- **tag-script** - Encloses a code segment containing cfscript.
- **tag-set** - Define a CFML variable. If the variable exists, cfset resets it to the specified value.
- **tag-switch** - Used with cfcase and cfdefaultcase. Evaluates a passed expression and passes control to the cfcase tag that matches the expression result. You can optionally code a cfdefaultcase tag, which receives control if there is no matching cfcase tag value.
- **tag-try** - Used with one or more cfcatch tags, the cftry tag lets you catch and process exceptions in CFML pages.
- **tag-application** - Defines a CFML Application and configures the properties / behavior of that Application

# Categories

- **category-compat** - Whilst Lucee is broadly compatible with Adobe ColdFusion, there are some differences.

# Guides

- **application-context-guide** - How to create and configure the Application.cfc
- **thread-usage** - Complete guide to using threads and parallel execution in Lucee
- **types-in-lucee** - This document explains types in Lucee. Lucee is still an untyped language. Types are only a check put on top of the language.
- **component-getclass-method** - This document explains the getClass() method for CFML components that implement Java interfaces, enabling seamless Java interoperability.
- **lucee-5-to-6-migration-guide** - Comprehensive guide for migrating from Lucee 5 to Lucee 6, addressing breaking changes and compatibility issues
- **changelog** - Here is a list of all the new Tags and Functions, Attributes and Arguments that have been added to Lucee over time.
- **lucee-editors-IDEs** - Modern IDEs supporting for CFML development
- **language-syntax-differences** -  Architecture Adobe ColdFusion (ACF) is configured in a way that only one single web context is available for a server instance. This means that if you do not secure your single applications they might become vulnerable, you will have to use sandbox security, single instances, etc. This and the fact that you do not have the ability to configure individual CF settings for each virtual host are the major disadvantages of this setup
- **new-operator** - This document provides a guide on using the new operator in Lucee for creating instances of CFML components and Java classes.
- **null_support** - This document explains how to set null support in the Lucee server admin, assigning `null` value for a variable and how to use `null` and `nullvalue`.
- **operators** - Mathematical, Logical, Ternary, Comparison, String and Elvis Operators
- **reserved-words** - The only reserved words in Lucee are null, true and false. scope names
- **scopes** - local, arguments, query, variables, this, cgi, cffile, url, form, cookie, client, thread, caller, request
- **mail-how-to-send-a-mail** - How to send an email using Lucee with help of the tag cfmail.
- **tag-syntax** - How to use tags in script