# Components (CFCs)



# Functions

- **function-componentcacheclear** - flush the component path cache
- **function-componentcachelist** - list elements in the component path cache
- **function-createobject** - The CreateObject function takes different arguments depending on the value of the first argument:
- **function-getcomponentmetadata** - Gets metadata (such as the functions and implemented interfaces of a component) for a CFC or Interface.
- **function-getcomponentstaticscope** - returns the static scope of a specific component, of course access rules apply.
- **function-getmetadata** - Returns back meta information depending on the object passed in
- **function-isclosure** - checks if given Object is a closure or not.
- **function-iscustomfunction** - Determines whether a name represents a custom function
- **function-isinstanceof** - Determines whether an object is an instance of a Lucee interface or component, or of a Java class.
- **function-isvalid** - Tests whether a value meets a validation or data type rule.

# Tags

- **tag-argument** - Allows subtag data to be saved with the base tag. Applies only to custom tags.
- **tag-component** - Creates and defines a component object
- **tag-function** - Defines a function within a CFML component that can accept arguments and return a value.
- **tag-interface** - Defines an interface that consists of a set of signatures for functions.
- **tag-invoke** - Invokes component methods from within a page or component. You use this tag to reference a WSDL file and consume a web service from within a block of CFML code.
- **tag-invokeargument** - Argument for the Invoke Tag
- **tag-object** - Lets you call methods in COM, CORBA, and JAVA objects.
- **tag-return** - Returns result values from a component method. Contains an expression returned as result of the function.
- **tag-static** - defines a static constructor within components

# Guides

- **lucee-5-access-modifiers** - public and private scope for component variables
- **dynamic-proxy-enhancements** - Learn about the improvements to dynamic proxy creation in Lucee 7, including automatic inclusion of component functions and properties when implementing Java interfaces.
- **component-getclass-method** - This document explains the getClass() method for CFML components that implement Java interfaces, enabling seamless Java interoperability.
- **tips-implicit-conversions** - Following up with [Magic Functions - Implicit Component Getters / Setters ](../guides/Various/TIPS/TIPS-magic-function.md), there's one more gem. Again, this has been around since Lucee 2. We're going to make a new, yet similar example. This time, we're going to create an address object: address.cfc ```lucee getStreet1()  getCity() , getState()  getPostalCode() ``` *index
- **inline-component** - Learn how to create and use inline components in Lucee. This guide demonstrates how to define components directly within your CFML code, making it easier to create and use components without needing a separate .cfc file. Examples include creating an inline component and using it similarly to closures.
- **tips-magic-functions** -  Enabling Magic Functions via Admin You can enable magic functions in the web / server context by going to: http://{your host name}/lucee/admin/web.cfm?action=resources.component - Local web context http://{your host name}/lucee/admin/server.cfm?action=resources.component - Global web context Enable the setting: `Implicit notation` **The Code** Once, you've checked and enabled it, we're ready to start with some code
- **new-operator** - This document provides a guide on using the new operator in Lucee for creating instances of CFML components and Java classes.
- **static-scope-in-components** - Understanding the static scope in Lucee components and how it can be used for shared data and functions.
- **sub-component** - Learn how to create and use sub components in Lucee. This guide demonstrates how to define additional components within a .cfc file, making it easier to organize related components. Examples include creating a main component with sub components, and how to address/load these sub components.


# Categories

[Scopes](scopes.md)