# Compatibility / Migration with other CFML engines

Whilst Lucee is broadly compatible with Adobe ColdFusion, there are some differences.

Some are for performance reasons, others due to Adobe mis-adopting or adding features which conflict with Lucee additions to the language. Sometimes it's a trade off between being compatible and respecting our existing users.

Our issue tracker has an [acf-compat](https://luceeserver.atlassian.net/issues/?jql=labels%20%3D%20%22acf-compat%22)  label which tracks all the known differences.

# Functions

- **function-arraycontains** - Returns the position of the first element in the array that matches the item that we are searching for, or 0 if the item is not found.
- **function-gettimezone** - returns the timezone defined for the current request.

# Tags

- **tag-queryparam** - Checks the data type of a query parameter.

# Guides

- **breaking-changes-5-4-to-6-0** - A guide to breaking changes introduced in Lucee between version 5.4 and 6.0
- **breaking-changes-6-0-to-6-1** - A guide to breaking changes introduced in Lucee between version 6.0 and 6.1
- **breaking-changes-6-1-to-6-2** - A guide to breaking changes introduced in Lucee between version 6.1 and 6.2
- **breaking-changes-6-2-to-7-0** - A guide to breaking changes introduced in Lucee between version 6.2 and 7.0
- **deprecated** - Backwards compatibility is considered super important in Lucee.
- **lucee-5-to-6-migration-guide** - Comprehensive guide for migrating from Lucee 5 to Lucee 6, addressing breaking changes and compatibility issues
- **changelog** - Here is a list of all the new Tags and Functions, Attributes and Arguments that have been added to Lucee over time.
- **language-syntax-differences** -  Architecture Adobe ColdFusion (ACF) is configured in a way that only one single web context is available for a server instance. This means that if you do not secure your single applications they might become vulnerable, you will have to use sandbox security, single instances, etc. This and the fact that you do not have the ability to configure individual CF settings for each virtual host are the major disadvantages of this setup
- **updating-lucee-migrate-from-railo** - Lucee 4.5 is forked from the Railo CFML Server (version 4.2) so you can easily migrate an existing Railo installation as follows.
- **updating-lucee-migrate-from-acf** - How to migrate/port your code from Adobe ColdFusion to Lucee
- **scopes** - local, arguments, query, variables, this, cgi, cffile, url, form, cookie, client, thread, caller, request


# Categories

[Core CFML Language](core.md)