# Cache



# Functions

- **function-cacheclear** - Flushes the cache
- **function-cachecount** - Returns the amount (integer) of keys stored in the cache.
- **function-cachedelete** - Deletes a single element from the cache.
- **function-cacheget** - Gets an object that is stored in the cache.
- **function-cachegetall** - this function return a structure containing all elements inside the cache.
- **function-cachegetallids** - this function return an array containing all keys inside the cache.
- **function-cachegetdefaultcachename** - return the default cache name for a specific type
- **function-cachegetmetadata** - returns a structure with some Metadata regarding the cache elements
- **function-cachegetproperties** - Gets the cache properties for the object cache, the page cache, or both.
- **function-cacheidexists** - Returns true/false whether the cache contains an element with the certain id.
- **function-cachekeyexists** - this function is deprecated
- **function-cacheput** - Stores an object in the cache, with a life time and an idle time.
- **function-cacheregionexists** - this function exists solely for the purpose of compatibility with other CFML Engines.
- **function-cacheregionnew** - This function exists solely for the purpose of compatibility with other CFML Engines.
- **function-cacheregionremove** - this function exists solely for the purpose of compatibility with other CFML Engines.
- **function-cacheremove** - removes elements from cache defined with argument ids.
- **function-cacheremoveall** - this function is deprecated, use instead cacheClear. Removes all elements from the cache
- **function-cachesetproperties** - This function is not supported by Lucee
- **function-componentcacheclear** - flush the component path cache
- **function-componentcachelist** - list elements in the component path cache
- **function-ctcacheclear** - flush the custom tag path cache
- **function-ctcachelist** - list elements in the custom tag path cache
- **function-entityload** - Loads and returns an array of entities of the specified entityname.
- **function-inspecttemplates** - Flag all the cfml code (cfm, cfcs) in the cache of compiled code (aka the Page Pool) to be checked once for any changes.
- **function-pagepoolclear** - Clear out all the cfml code (cfm, cfcs) in the cache of compiled code (aka the Page Pool)
- **function-pagepoollist** - Lists all the cfml code (cfm, cfcs) in the cache of compiled code (aka the Page Pool)
- **function-query** - Create and populate a query object in the form query(columnName1:[1,2,3],columnName2:[4,5,6])
- **function-queryexecute** - Executes a SQL query, returns the result.
- **function-rediscommand** - execute any redis function without any interpretation from Lucee.
- **function-rediscommandlowpriority** - This function works the same way as RedisCommand with only one difference. In case the connection pool is down to one free connection. The thread will wait for at least one connection more get free. So this command will not use the last connection available.
- **function-redisconnectionpoolinfo** - Gives back detailed information about the Redis connection pool.
- **function-systemcacheclear** - clears all caches or the specified cache

# Tags

- **tag-cache** - Speeds up page rendering when dynamic content
- **tag-distributedlock** - Redis based lock that can be used across servers
- **tag-file** - Handles all interactions with files
- **tag-http** - Lets you execute HTTP POST and GET operations on files.
- **tag-objectcache** - Flushes an object cache or returns the current size.
- **tag-query** - Passes SQL statements to a data source. Not limited to queries.

# Guides

- **caches-defined-in-application-cfc** - How to add per-application caches via Application.cfc in Lucee.
- **cache-a-query-for-the-curr-context** - Cache a Query for the current request in Lucee.
- **lucee-5-cached-within** -  CachedWithin The attribute `cachedWithin` has been added to the tags `cffile` and `cfhttp` and it has also been added as an interface to Lucee so you can make your own `cachedwithin` implementation. Supported with cffile and cfhttp The possibility to cache the result of the tags `cffile` and `cfhttp` has been added in Lucee 5 using the attribute `cachedWithin` for these tags
- **list-existing-cache-conn** - List existing Cache Connections available in Lucee.
- **session-handling** - Comprehensive guide on session handling and configuration in Lucee, including session types, storage options, and security considerations.
- **webserver-cache** -  Performance / Caching The settings you make here determine how Lucee deals with changed CFM files. Normally Lucee will compile any modified file into a new Java class file. While this is very fast (depending on the complexity and size of the file to this might take around 10ms), however, each , , CFC invocation, CustomTags call, etc