# Arrays



# Functions

- **function-array** - Creates a new array
- **function-arrayappend** - Appends an array element to an array.
- **function-arrayavg** - Calculates the average of the values in an array. All elements in the array must contain values that can be automatically converted to numeric.
- **function-arrayclear** - Removes all elements from an array.
- **function-arraycontains** - Returns the position of the first element in the array that matches the item that we are searching for, or 0 if the item is not found.
- **function-arraycontainsnocase** - Returns the position of the first element in the array whose string value contains the substring passed (not case sensitive), or 0 if no such element is found.
- **function-arraydelete** - Deletes specified object from given array
- **function-arraydeleteat** - Deletes an element from an array and resizes the array so that the deleted element doesn't leave a gap.
- **function-arraydeletenocase** - Deletes specified object from given array, in case of a string the case of the string does not matter.
- **function-arrayeach** - call the given UDF/Closure with every value in the array.
- **function-arrayevery** - This function calls a given closure/function with every element in a given array and returns true, if all of the closure calls returns true.
- **function-arrayfilter** - This function creates a new Array that returns all the values from an array that match the given filter.
- **function-arrayfind** - These functions searches the array for the specified object.
- **function-arrayfindall** - These functions searches the array for the specified object and return the positions of all occurrence of this values.
- **function-arrayfindallnocase** - These functions searches the array for the specified object and return the positions of all occurrence of this values.
- **function-arrayfindnocase** - These functions performs a case-insensitive search in the array for the specified object.
- **function-arrayfirst** - Returns the first item from an array. Throws an error if the array is empty.
- **function-arrayindexexists** - Returns whether there exists an item in the array at the selected index.
- **function-arrayinsertat** - Inserts a value at the specified position in the array. If the element is inserted before the end of the array, Lucee shifts the positions of all elements with a higher index to make room.
- **function-arrayisdefined** - Returns whether there exists an item in the array at the selected index.
- **function-arrayisempty** - Determines if the array is empty.
- **function-arraylast** - Returns the last element of an array
- **function-arraylen** - Returns the length of a given array
- **function-arraymap** - Calls the given closure with every element in the given array. the function returns an array that contains all values returned by the closure.
- **function-arraymax** - Returns the largest numeric value in an array. If the array parameter value is an empty array, returns zero. All elements must contain values that can be automatically converted to numeric values.
- **function-arraymedian** - Calculates the Median value of items in an array.
- **function-arraymerge** - This function creates a new array with data from the two passed arrays. To add all the data from one array into another without creating a new array see the built in function ArrayAppend(arr1, arr2, true).
- **function-arraymid** - Extracts a sub array from an array.
- **function-arraymin** - Returns the smallest numeric value in an array. If the array parameter value is an empty array, returns zero. All elements must contain values that can be automatically converted to numeric values.
- **function-arraynew** - create a new array
- **function-arrayPop** - pops the last element from an array. In case the array is empty an exception is thrown, unless the second argument &amp;quot;defaultValue&amp;quot; is provided, in that case that value is returned.
- **function-arrayprepend** - Inserts an array element at the beginning of an array and shifts the positions of the existing elements to make room.
- **function-arrayPush** - Inserts an array element at the end of an array and return the new size of the array.
- **function-arrayreduce** - Iterates over every entry of the given array and calls the closure with every element. This function will reduce the array to a single value and will return the value.
- **function-arrayremoveduplicates** - Removes duplicate values from array.
- **function-arrayresize** - Resets an array to a specified minimum number of elements.
- **function-arrayreverse** - Returns a new array, with all the elements reversed
- **function-arrayset** - In a one-dimensional array, sets the elements in a specified index range to a value. Useful for initializing an array after a call to ArrayNew.
- **function-arrayshift** - pops the first element from an array and shift the rest of the values to the left. In case the array is empty an exception is thrown, unless the second argument &amp;quot;defaultValue&amp;quot; is provided, in that case that value is returned.
- **function-arrayslice** - Returns a new array, from the start position up to the count of elements
- **function-arraysome** - This function calls a given closure/function with every element in a given array and returns true, if one of the closure calls returns true.
- **function-arraysort** - Sorts array elements numerically or alphanumerically.
- **function-arraysplice** - Modifies an array by removing elements and adding new elements. It starts from the index, removes as many elements as specified by elementCountForRemoval, and puts the replacements starting from index position. Return the removed elements.
- **function-arraysum** - The sum of values in an array. If the array parameter value is an empty array, returns zero.
- **function-arrayswap** - Swaps array values of an array at specified positions. This function is more efficient than multiple cfset tags
- **function-arraytolist** - Transform the array to a list of elements delimiter by the given string
- **function-arraytostruct** - Transform the array to a struct, by default, the index of the array is the key of the struct
- **function-arrayUnShift** - Adds an element at the beginning of the array and shifts the rest of the elements to the right.
- **function-isarray** - Determines whether a value is an array.
- **function-isvalid** - Tests whether a value meets a validation or data type rule.
- **function-len** - Determines the length of a string, array or struct
- **function-listqualifiedtoarray** - Copies the elements of a list to an array.
- **function-listtoarray** - Copies the elements of a list to an array.
- **function-querycolumnarray** - return the column names as array

# Methods

- **method-array-append** - Appends an array element to an array.
- **method-array-avg** - Calculates the average of the values in an array. All elements in the array must contain values that can be automatically converted to numeric.
- **method-array-clear** - Removes all elements from an array.
- **method-array-contains** - Returns the position of the first element in the array that matches the item that we are searching for, or 0 if the item is not found.
- **method-array-containsnocase** - Returns the position of the first element in the array whose string value contains the substring passed (not case sensitive), or 0 if no such element is found.
- **method-array-delete** - Deletes specified object from given array
- **method-array-deleteat** - Deletes an element from an array and resizes the array so that the deleted element doesn't leave a gap.
- **method-array-deletenocase** - Deletes specified object from given array, in case of a string the case of the string does not matter.
- **method-array-each** - call the given UDF/Closure with every value in the array.
- **method-array-every** - This function calls a given closure/function with every element in a given array and returns true, if all of the closure calls returns true.
- **method-array-filter** - This function creates a new Array that returns all the values from an array that match the given filter.
- **method-array-find** - These functions searches the array for the specified object.
- **method-array-findall** - These functions searches the array for the specified object and return the positions of all occurrence of this values.
- **method-array-findallnocase** - These functions searches the array for the specified object and return the positions of all occurrence of this values.
- **method-array-findnocase** - These functions performs a case-insensitive search in the array for the specified object.
- **method-array-first** - Returns the first item from an array. Throws an error if the array is empty.
- **method-array-indexexists** - Returns whether there exists an item in the array at the selected index.
- **method-array-insertat** - Inserts a value at the specified position in the array. If the element is inserted before the end of the array, Lucee shifts the positions of all elements with a higher index to make room.
- **method-array-isdefined** - Returns whether there exists an item in the array at the selected index.
- **method-array-isempty** - Determines if the array is empty.
- **method-array-last** - Returns the last element of an array
- **method-array-len** - Returns the length of a given array
- **method-array-map** - Calls the given closure with every element in the given array. the function returns an array that contains all values returned by the closure.
- **method-array-max** - Returns the largest numeric value in an array. If the array parameter value is an empty array, returns zero. All elements must contain values that can be automatically converted to numeric values.
- **method-array-median** - Calculates the Median value of items in an array. All elements in the array must contain values that can be converted to numeric.
- **method-array-merge** - This function creates a new array with data from the two passed arrays. To add all the data from one array into another without creating a new array see the built in function ArrayAppend(arr1, arr2, true).
- **method-array-mid** - Extracts a sub array from an array.
- **method-array-min** - Returns the smallest numeric value in an array. If the array parameter value is an empty array, returns zero. All elements must contain values that can be automatically converted to numeric values.
- **method-array-pop** - pops the last element from an array. In case the array is empty an exception is thrown, unless the second argument &amp;quot;defaultValue&amp;quot; is provided, in that case that value is returned.
- **method-array-prepend** - Inserts an array element at the beginning of an array and shifts the positions of the existing elements to make room.
- **method-array-push** - Inserts an array element at the end of an array and return the new size of the array.
- **method-array-reduce** - Iterates over every entry of the given array and calls the closure with every element. This function will reduce the array to a single value and will return the value.
- **method-array-removeduplicates** - Removes duplicate values from array.
- **method-array-resize** - Resets an array to a specified minimum number of elements. This can improve performance, if used to size an array to its expected maximum. For more than 500 elements, use ArrayResize immediately after using the ArrayNew tag.
- **method-array-reverse** - Returns a new array, with all the elements reversed
- **method-array-set** - In a one-dimensional array, sets the elements in a specified index range to a value. Useful for initializing an array after a call to ArrayNew.
- **method-array-shift** - pops the first element from an array and shift the rest of the values to the left. In case the array is empty an exception is thrown, unless the second argument &amp;quot;defaultValue&amp;quot; is provided, in that case that value is returned.
- **method-array-slice** - Returns a new array, from the start position up to the count of elements
- **method-array-some** - This function calls a given closure/function with every element in a given array and returns true, if one of the closure calls returns true.
- **method-array-sort** - Sorts array elements numerically or alphanumerically.
- **method-array-splice** - Modifies an array by removing elements and adding new elements. It starts from the index, removes as many elements as specified by elementCountForRemoval, and puts the replacements starting from index position. Return the removed elements.
- **method-array-sum** - The sum of values in an array. If the array parameter value is an empty array, returns zero.
- **method-array-swap** - Swaps array values of an array at specified positions. This function is more efficient than multiple cfset tags
- **method-array-tolist** - Transform the array to a list of elements delimiter by the given string
- **method-array-tostruct** - Transform the array to a struct, by default, the index of the array is the key of the struct
- **method-array-unshift** - Adds an element at the beginning of the array and shifts the rest of the elements to the right.
- **method-query-columnarray** - return the column names as array
- **method-string-listqualifiedtoarray** - Copies the elements of a list to an array.
- **method-string-listtoarray** - Copies the elements of a list to an array.

# Objects

- **object-array** - Unlike some other languages, Arrays in CFML start at 1 rather than 0. Arrays in Lucee are passed by reference, see [Migrating to Lucee from ColdFusion](../guides/updating-lucee/migrate-from-acf.md)