# Ajax features

All the CFML ajax/client side tags are considered [deprecated](../reference/deprecated.md) in Lucee and are only provided for minimal backwards compatibility.

They aren't extensible and there are far better modern, javascript alternatives available.

Here are some (older) examples of how to replace these tags with javascript <https://static.raymondcamden.com/cfuitherightway/index.html>

# Functions

- **function-ajaxonload** - Causes the specified JavaScript function to run when the page loads.

# Tags

- **tag-ajaximport** - Controls the JavaScript files that are imported for use on pages that use Luceex AJAX tags and features.
- **tag-ajaxproxy** - Creates a JavaScript proxy for a component, for use in an AJAX client. Alternatively, creates a proxy for a single CFC method, JavaScript function, or URL that is bound to one or more control attribute values.
- **tag-div** - Creates an HTML tag with specified contents and lets you to use bind expressions to dynamically control the tag contents.
- **tag-form** - Builds a form with CFML custom control tags that provide more functionality than standard HTML form input elements (XML and Flash type not supported).
- **tag-input** - Used inside cfform to place radio buttons, checkboxes, or text boxes. Provides input validation for the specified control type.
- **tag-layout** - This tag is [deprecated](../reference/deprecated.md)
- **tag-layoutarea** - This tag is [deprecated](../reference/deprecated.md)
- **tag-map** - This are provided for backwards compatibility, and should be considered [deprecated](../reference/deprecated.md) These tags are quite limited and difficult to extend, it's recommended to use a modern javascript mapping API instead.(Requires AJAX extension)
- **tag-mapitem** - Used with [<cfmap>](../reference/tags/map.md), this tag lets you add markers on the map. This tag is [deprecated](../reference/deprecated.md)
- **tag-select** - Used inside cfform, cfselect lets you construct a drop-down list box form control. You can populate the drop-down list box from a query, or using the option tag. Use option elements to populate lists. The syntax for the option tag is the same as for its HTML counterpart.
- **tag-slider** - Used inside cfform, cfslider lets you place a slider control in a CFML form. A slider control is like a sliding volume control. The slider groove is the area over which the slider moves.
- **tag-window** - Creates a pop-up window in the browser. Does not create a separate browser pop-up instance.

# Categories

- **category-javascript** - 

# Guides

- **tag-calendar** - The tag ` ` is not supported by Lucee.
- **tag-formgroup** - The ` ` tag is not supported by Lucee.
- **tag-formitem** - The ` ` tag is not supported by Lucee.
- **tag-grid** - The ` ` tag is not supported by Lucee.
- **tag-gridcolumn** - The ` ` tag is not supported by Lucee.
- **tag-gridrow** - The ` ` tag is not supported by Lucee.
- **tag-textarea** - The ` ` tag is not supported by Lucee.
- **tag-tree** - The ` ` tag is not supported by Lucee.
- **ajax-bind-syntax** - Most of the tags support a binding statement in the url or source attributes. The following syntax is supported.


# See Also

[DeserializeJSON()](../reference/functions/deserializejson.md), [SerializeJSON()](../reference/functions/serializejson.md)