# AI / LLM Integration

The AI support feature is experimental and the function API may be subject to change.

# Functions

- **function-aigetmetadata** - Retrieves metadata about a configured AI endpoint. Returns information about the endpoint's configuration, and optionally detailed information about available models and associated files.
- **function-aihas** - Checks whether a specific AI endpoint is configured and available for use.
- **function-createaisession** - Creates a new AI session for interaction with Large Language Models (LLMs). The session maintains conversation history and context between interactions. Each session can be configured with different parameters to optimize for specific use cases like code analysis, content generation, or data processing. Common usage patterns: - Exception analysis and debugging assistance - Code documentation generation - Query optimization suggestions - Security review assistance - Performance optimization recommendations The session persists until explicitly terminated or the application restarts
- **function-inquiryaisession** - Sends a question/message to an AI session and returns the response. The function maintains conversation context from previous interactions within the same session. The response can either be returned as a complete string or streamed in chunks to a listener function for real-time processing.
- **function-loadaisession** - Restores an AI session from a serialized JSON string or struct. This function recreates an AI session with: - Original configuration settings (temperature, limits, timeouts) - Complete conversation history - System message prompt The function supports loading sessions by: - AI engine name - Engine ID (using `id:` prefix) - Default engine (using `default:` prefix) This function pairs with `SerializeAISession()` to provide persistence for AI conversations across requests or application restarts
- **function-luceeaigetmetadata** - Retrieves metadata about a configured AI endpoint. Returns information about the endpoint's configuration, and optionally detailed information about available models and associated files.
- **function-luceeaihas** - Checks whether a specific AI endpoint is configured and available for use.
- **function-luceecreateaisession** - Creates a new AI session for interaction with Large Language Models (LLMs). The session maintains conversation history and context between interactions. Each session can be configured with different parameters to optimize for specific use cases like code analysis, content generation, or data processing. Common usage patterns: - Exception analysis and debugging assistance - Code documentation generation - Query optimization suggestions - Security review assistance - Performance optimization recommendations The session persists until explicitly terminated or the application restarts
- **function-luceeinquiryaisession** - Sends a question/message to an AI session and returns the response. The function maintains conversation context from previous interactions within the same session. The response can either be returned as a complete string or streamed in chunks to a listener function for real-time processing.
- **function-serializeaisession** - Serializes an AI session to a JSON string that includes its configuration and conversation history. The serialized content includes: - Configuration settings (temperature, limits, timeouts, system message) - Complete conversation history with questions and answers This function is useful for: - Persisting AI sessions - Debugging AI conversations - Sharing or transferring AI session data - Storing AI conversation history Use `LoadAISession()` to restore a serialized session

# Guides

- **ai** -  AI (Experimental) Lucee 6.2 includes experimental support for AI integration, which will be finalized with the release of Lucee 7. This documentation is subject to change, reflecting Lucee's aim to remain adaptable to future advancements. Feedback is welcome to help tailor functionality to users' needs. Configuration In Lucee 6
- **ai-augmentation-lucene** - Documentation for augmenting AI queries using Lucene search in Lucee
- **ai-documentation-setup** - Guide to configuring AI for use in Lucee's Documentation tab, leveraging retrieval-augmented generation (RAG) and enhanced search functionality.
- **ai-session-serialization** - Documentation for serializing and deserializing AI sessions in Lucee